/*
 * Decompiled with CFR 0.152.
 */
package sun.instrument;

import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.jar.JarFile;
import sun.instrument.TransformerManager;

public class InstrumentationImpl
implements Instrumentation {
    private final TransformerManager mTransformerManager = new TransformerManager(false);
    private TransformerManager mRetransfomableTransformerManager = null;
    private final long mNativeAgent;
    private final boolean mEnvironmentSupportsRedefineClasses;
    private volatile boolean mEnvironmentSupportsRetransformClassesKnown;
    private volatile boolean mEnvironmentSupportsRetransformClasses;
    private final boolean mEnvironmentSupportsNativeMethodPrefix;

    private InstrumentationImpl(long nativeAgent, boolean environmentSupportsRedefineClasses, boolean environmentSupportsNativeMethodPrefix) {
        this.mNativeAgent = nativeAgent;
        this.mEnvironmentSupportsRedefineClasses = environmentSupportsRedefineClasses;
        this.mEnvironmentSupportsRetransformClassesKnown = false;
        this.mEnvironmentSupportsRetransformClasses = false;
        this.mEnvironmentSupportsNativeMethodPrefix = environmentSupportsNativeMethodPrefix;
    }

    @Override
    public void addTransformer(ClassFileTransformer transformer) {
        this.addTransformer(transformer, false);
    }

    @Override
    public synchronized void addTransformer(ClassFileTransformer transformer, boolean canRetransform) {
        if (transformer == null) {
            throw new NullPointerException("null passed as 'transformer' in addTransformer");
        }
        if (canRetransform) {
            if (!this.isRetransformClassesSupported()) {
                throw new UnsupportedOperationException("adding retransformable transformers is not supported in this environment");
            }
            if (this.mRetransfomableTransformerManager == null) {
                this.mRetransfomableTransformerManager = new TransformerManager(true);
            }
            this.mRetransfomableTransformerManager.addTransformer(transformer);
            if (this.mRetransfomableTransformerManager.getTransformerCount() == 1) {
                this.setHasRetransformableTransformers(this.mNativeAgent, true);
            }
        } else {
            this.mTransformerManager.addTransformer(transformer);
        }
    }

    @Override
    public synchronized boolean removeTransformer(ClassFileTransformer transformer) {
        if (transformer == null) {
            throw new NullPointerException("null passed as 'transformer' in removeTransformer");
        }
        TransformerManager mgr = this.findTransformerManager(transformer);
        if (mgr != null) {
            mgr.removeTransformer(transformer);
            if (mgr.isRetransformable() && mgr.getTransformerCount() == 0) {
                this.setHasRetransformableTransformers(this.mNativeAgent, false);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isModifiableClass(Class<?> theClass) {
        if (theClass == null) {
            throw new NullPointerException("null passed as 'theClass' in isModifiableClass");
        }
        return this.isModifiableClass0(this.mNativeAgent, theClass);
    }

    @Override
    public boolean isRetransformClassesSupported() {
        if (!this.mEnvironmentSupportsRetransformClassesKnown) {
            this.mEnvironmentSupportsRetransformClasses = this.isRetransformClassesSupported0(this.mNativeAgent);
            this.mEnvironmentSupportsRetransformClassesKnown = true;
        }
        return this.mEnvironmentSupportsRetransformClasses;
    }

    @Override
    public void retransformClasses(Class<?> ... classes) {
        if (!this.isRetransformClassesSupported()) {
            throw new UnsupportedOperationException("retransformClasses is not supported in this environment");
        }
        this.retransformClasses0(this.mNativeAgent, classes);
    }

    @Override
    public boolean isRedefineClassesSupported() {
        return this.mEnvironmentSupportsRedefineClasses;
    }

    @Override
    public void redefineClasses(ClassDefinition ... definitions) throws ClassNotFoundException {
        if (!this.isRedefineClassesSupported()) {
            throw new UnsupportedOperationException("redefineClasses is not supported in this environment");
        }
        if (definitions == null) {
            throw new NullPointerException("null passed as 'definitions' in redefineClasses");
        }
        for (int i = 0; i < definitions.length; ++i) {
            if (definitions[i] != null) continue;
            throw new NullPointerException("element of 'definitions' is null in redefineClasses");
        }
        if (definitions.length == 0) {
            return;
        }
        this.redefineClasses0(this.mNativeAgent, definitions);
    }

    @Override
    public Class[] getAllLoadedClasses() {
        return this.getAllLoadedClasses0(this.mNativeAgent);
    }

    @Override
    public Class[] getInitiatedClasses(ClassLoader loader) {
        return this.getInitiatedClasses0(this.mNativeAgent, loader);
    }

    @Override
    public long getObjectSize(Object objectToSize) {
        if (objectToSize == null) {
            throw new NullPointerException("null passed as 'objectToSize' in getObjectSize");
        }
        return this.getObjectSize0(this.mNativeAgent, objectToSize);
    }

    @Override
    public void appendToBootstrapClassLoaderSearch(JarFile jarfile) {
        this.appendToClassLoaderSearch0(this.mNativeAgent, jarfile.getName(), true);
    }

    @Override
    public void appendToSystemClassLoaderSearch(JarFile jarfile) {
        this.appendToClassLoaderSearch0(this.mNativeAgent, jarfile.getName(), false);
    }

    @Override
    public boolean isNativeMethodPrefixSupported() {
        return this.mEnvironmentSupportsNativeMethodPrefix;
    }

    @Override
    public synchronized void setNativeMethodPrefix(ClassFileTransformer transformer, String prefix) {
        if (!this.isNativeMethodPrefixSupported()) {
            throw new UnsupportedOperationException("setNativeMethodPrefix is not supported in this environment");
        }
        if (transformer == null) {
            throw new NullPointerException("null passed as 'transformer' in setNativeMethodPrefix");
        }
        TransformerManager mgr = this.findTransformerManager(transformer);
        if (mgr == null) {
            throw new IllegalArgumentException("transformer not registered in setNativeMethodPrefix");
        }
        mgr.setNativeMethodPrefix(transformer, prefix);
        String[] prefixes = mgr.getNativeMethodPrefixes();
        this.setNativeMethodPrefixes(this.mNativeAgent, prefixes, mgr.isRetransformable());
    }

    private TransformerManager findTransformerManager(ClassFileTransformer transformer) {
        if (this.mTransformerManager.includesTransformer(transformer)) {
            return this.mTransformerManager;
        }
        if (this.mRetransfomableTransformerManager != null && this.mRetransfomableTransformerManager.includesTransformer(transformer)) {
            return this.mRetransfomableTransformerManager;
        }
        return null;
    }

    private native boolean isModifiableClass0(long var1, Class<?> var3);

    private native boolean isRetransformClassesSupported0(long var1);

    private native void setHasRetransformableTransformers(long var1, boolean var3);

    private native void retransformClasses0(long var1, Class<?>[] var3);

    private native void redefineClasses0(long var1, ClassDefinition[] var3) throws ClassNotFoundException;

    private native Class[] getAllLoadedClasses0(long var1);

    private native Class[] getInitiatedClasses0(long var1, ClassLoader var3);

    private native long getObjectSize0(long var1, Object var3);

    private native void appendToClassLoaderSearch0(long var1, String var3, boolean var4);

    private native void setNativeMethodPrefixes(long var1, String[] var3, boolean var4);

    private static void setAccessible(final AccessibleObject ao, final boolean accessible) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ao.setAccessible(accessible);
                return null;
            }
        });
    }

    private void loadClassAndStartAgent(String classname, String methodname, String optionsString) throws Throwable {
        ClassLoader mainAppLoader = ClassLoader.getSystemClassLoader();
        Class<?> javaAgentClass = mainAppLoader.loadClass(classname);
        Method m = null;
        NoSuchMethodException firstExc = null;
        boolean twoArgAgent = false;
        try {
            m = javaAgentClass.getDeclaredMethod(methodname, String.class, Instrumentation.class);
            twoArgAgent = true;
        }
        catch (NoSuchMethodException x) {
            firstExc = x;
        }
        if (m == null) {
            try {
                m = javaAgentClass.getDeclaredMethod(methodname, String.class);
            }
            catch (NoSuchMethodException x) {
                // empty catch block
            }
        }
        if (m == null) {
            try {
                m = javaAgentClass.getMethod(methodname, String.class, Instrumentation.class);
                twoArgAgent = true;
            }
            catch (NoSuchMethodException x) {
                // empty catch block
            }
        }
        if (m == null) {
            try {
                m = javaAgentClass.getMethod(methodname, String.class);
            }
            catch (NoSuchMethodException x) {
                throw firstExc;
            }
        }
        InstrumentationImpl.setAccessible(m, true);
        if (twoArgAgent) {
            m.invoke(null, optionsString, this);
        } else {
            m.invoke(null, optionsString);
        }
        InstrumentationImpl.setAccessible(m, false);
    }

    private void loadClassAndCallPremain(String classname, String optionsString) throws Throwable {
        this.loadClassAndStartAgent(classname, "premain", optionsString);
    }

    private void loadClassAndCallAgentmain(String classname, String optionsString) throws Throwable {
        this.loadClassAndStartAgent(classname, "agentmain", optionsString);
    }

    private byte[] transform(ClassLoader loader, String classname, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer, boolean isRetransformer) {
        TransformerManager mgr;
        TransformerManager transformerManager = mgr = isRetransformer ? this.mRetransfomableTransformerManager : this.mTransformerManager;
        if (mgr == null) {
            return null;
        }
        return mgr.transform(loader, classname, classBeingRedefined, protectionDomain, classfileBuffer);
    }

    static {
        System.loadLibrary("instrument");
    }
}

