/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;
import sun.nio.cs.ext.GB18030;

public class CharToByteGB18030
extends CharToByteConverter {
    private char highHalfZoneCode;
    boolean flushed = true;
    private static final int GB18030_SINGLE_BYTE = 1;
    private static final int GB18030_DOUBLE_BYTE = 2;
    private static final int GB18030_FOUR_BYTE = 3;
    private static short[] index1;
    private static String[] index2;
    private int currentState;

    public CharToByteGB18030() {
        GB18030 nioCoder = new GB18030();
        this.currentState = 2;
        this.subBytes = new byte[1];
        this.subBytes[0] = 63;
        index1 = nioCoder.getEncoderIndex1();
        index2 = nioCoder.getEncoderIndex2();
    }

    public int flush(byte[] output, int outStart, int outEnd) throws MalformedInputException {
        if (this.highHalfZoneCode != '\u0000') {
            this.highHalfZoneCode = '\u0000';
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        this.reset();
        this.flushed = true;
        return 0;
    }

    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
        this.currentState = 2;
    }

    public boolean canConvert(char c) {
        return (c < '\ud800' || c > '\udfff') && c < '\ufffe';
    }

    /*
     * Enabled aggressive block sorting
     */
    public int convert(char[] input, int inOff, int inEnd, byte[] output, int outOff, int outEnd) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        int linearDiffValue = 0;
        int hiByte = 0;
        int loByte = 0;
        this.charOff = inOff;
        this.byteOff = outOff;
        this.flushed = false;
        if (this.highHalfZoneCode != '\u0000') {
            if (input[inOff] >= '\udc00' && input[inOff] <= '\udfff') {
                char[] newBuf = new char[inEnd - inOff + 1];
                newBuf[0] = this.highHalfZoneCode;
                System.arraycopy(input, inOff, newBuf, 1, inEnd - inOff);
                --this.charOff;
                input = newBuf;
                inOff = 0;
                inEnd = newBuf.length;
                this.highHalfZoneCode = '\u0000';
            } else {
                this.badInputLength = 0;
                throw new MalformedInputException();
            }
        }
        while (this.charOff < inEnd) {
            block25: {
                char inputChar;
                if ((inputChar = input[this.charOff++]) >= '\ud800' && inputChar <= '\udbff') {
                    if (this.charOff + 1 > inEnd) {
                        this.highHalfZoneCode = inputChar;
                        return this.byteOff - outOff;
                    }
                    char previousChar = inputChar;
                    inputChar = input[this.charOff];
                    if (inputChar >= '\udc00' && inputChar <= '\udfff') {
                        int inputSize = 2;
                        ++this.charOff;
                        linearDiffValue = (previousChar - 55296) * 1024 + (inputChar - 56320) + 189000;
                        this.currentState = 3;
                        break block25;
                    } else {
                        this.badInputLength = 1;
                        throw new MalformedInputException();
                    }
                }
                if (inputChar >= '\udc00' && inputChar <= '\udfff') {
                    this.badInputLength = 1;
                    throw new MalformedInputException();
                }
                if (inputChar >= '\u0000' && inputChar <= '\u007f') {
                    if (this.byteOff >= outEnd) {
                        throw new ConversionBufferFullException();
                    }
                    this.currentState = 1;
                    output[this.byteOff++] = (byte)inputChar;
                } else if (inputChar <= '\ua4c6' || inputChar >= '\ue000') {
                    int outByteVal = this.getGB18030(index1, index2, inputChar);
                    if (outByteVal == 65533) {
                        if (!this.subMode) {
                            this.badInputLength = 1;
                            throw new UnknownCharacterException();
                        }
                        if (this.byteOff >= outEnd) {
                            throw new ConversionBufferFullException();
                        }
                        output[this.byteOff++] = this.subBytes[0];
                        continue;
                    }
                    hiByte = (outByteVal & 0xFF00) >> 8;
                    loByte = outByteVal & 0xFF;
                    linearDiffValue = (hiByte - 32) * 256 + loByte;
                    if (inputChar >= '\ue000' && inputChar < '\uf900') {
                        linearDiffValue += 33469;
                    } else if (inputChar >= '\uf900') {
                        linearDiffValue += 37801;
                    }
                    this.currentState = hiByte > 128 ? 2 : 3;
                } else if (inputChar >= '\ua4c7' && inputChar <= '\ud7ff') {
                    linearDiffValue = inputChar - 21827;
                    this.currentState = 3;
                } else {
                    this.badInputLength = 1;
                    throw new MalformedInputException();
                }
            }
            if (this.currentState == 1) continue;
            if (this.currentState == 2) {
                if (this.byteOff + 2 > outEnd) {
                    throw new ConversionBufferFullException();
                }
                output[this.byteOff++] = (byte)hiByte;
                output[this.byteOff++] = (byte)loByte;
                continue;
            }
            if (this.byteOff + 4 > outEnd) {
                throw new ConversionBufferFullException();
            }
            byte b4 = (byte)(linearDiffValue % 10 + 48);
            byte b3 = (byte)((linearDiffValue /= 10) % 126 + 129);
            byte b2 = (byte)((linearDiffValue /= 126) % 10 + 48);
            byte b1 = (byte)(linearDiffValue / 10 + 129);
            output[this.byteOff++] = b1;
            output[this.byteOff++] = b2;
            output[this.byteOff++] = b3;
            output[this.byteOff++] = b4;
        }
        return this.byteOff - outOff;
    }

    public int getMaxBytesPerChar() {
        return 4;
    }

    public String getCharacterEncoding() {
        return "GB18030";
    }

    private int getGB18030(short[] outerIndex, String[] innerIndex, char ch) {
        int offset = outerIndex[(ch & 0xFF00) >> 8] << 8;
        return innerIndex[offset >> 12].charAt((offset & 0xFFF) + (ch & 0xFF));
    }
}

