/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.banner.workspace;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceInformation;
import org.gephi.project.api.WorkspaceListener;
import org.gephi.project.api.WorkspaceProvider;
import org.gephi.ui.utils.UIUtils;
import org.netbeans.swing.tabcontrol.DefaultTabDataModel;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbedContainer;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.openide.awt.Actions;
import org.openide.util.Lookup;
import org.openide.windows.WindowManager;

public class WorkspacePanel
extends JPanel
implements WorkspaceListener,
PropertyChangeListener {
    private final transient DefaultTabDataModel tabDataModel;
    private final transient TabDisplayer tabbedContainer;

    public WorkspacePanel() {
        if (UIUtils.isFlatLafLightLookAndFeel()) {
            UIManager.put("EditorTab.background", Color.WHITE);
        }
        this.initComponents();
        this.tabDataModel = new DefaultTabDataModel();
        WinsysInfoForTabbedContainer ws = new WinsysInfoForTabbedContainer(){

            public Object getOrientation(Component cmpnt) {
                return TabDisplayer.ORIENTATION_CENTER;
            }

            public boolean inMaximizedMode(Component cmpnt) {
                return false;
            }

            public boolean isTopComponentMaximizationEnabled() {
                return false;
            }
        };
        this.tabbedContainer = new TabDisplayer((TabDataModel)this.tabDataModel, 1, ws);
        this.tabbedContainer.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (WorkspacePanel.this.tabbedContainer.getSelectionModel().getSelectedIndex() != -1) {
                    TabData tabData = WorkspacePanel.this.tabDataModel.getTab(WorkspacePanel.this.tabbedContainer.getSelectionModel().getSelectedIndex());
                    Workspace workspace = (Workspace)tabData.getUserObject();
                    ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
                    if (pc.getCurrentWorkspace() != null && pc.getCurrentWorkspace() != workspace) {
                        pc.openWorkspace(workspace);
                    }
                }
            }
        });
        this.tabbedContainer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabActionEvent tabActionEvent = (TabActionEvent)e;
                if (tabActionEvent.getActionCommand().equals("close")) {
                    TabData tabData = WorkspacePanel.this.tabDataModel.getTab(tabActionEvent.getTabIndex());
                    Actions.forID((String)"Workspace", (String)"org.gephi.desktop.project.actions.DeleteWorkspace").actionPerformed(new ActionEvent(tabData.getUserObject(), 0, null));
                    tabActionEvent.consume();
                } else if (tabActionEvent.getActionCommand().equals("closeAll")) {
                    Actions.forID((String)"File", (String)"org.gephi.desktop.project.actions.CloseProject").actionPerformed(null);
                    tabActionEvent.consume();
                } else if (tabActionEvent.getActionCommand().equals("closeAllButThis")) {
                    TabData tabData = WorkspacePanel.this.tabDataModel.getTab(tabActionEvent.getTabIndex());
                    Actions.forID((String)"Workspace", (String)"org.gephi.desktop.project.actions.DeleteOtherWorkspaces").actionPerformed(new ActionEvent(tabData.getUserObject(), 0, null));
                    tabActionEvent.consume();
                } else if (tabActionEvent.getActionCommand().equals("select")) {
                    TabData tabData = WorkspacePanel.this.tabDataModel.getTab(tabActionEvent.getTabIndex());
                    ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
                    pc.openWorkspace((Workspace)tabData.getUserObject());
                    tabActionEvent.consume();
                }
            }
        });
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
                pc.addWorkspaceListener((WorkspaceListener)WorkspacePanel.this);
                WorkspacePanel.this.refreshModel();
            }
        });
    }

    private synchronized void refreshModel() {
        WorkspaceProvider workspaceProvider;
        Workspace[] workspaces;
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        if (pc.getCurrentProject() != null && (workspaces = (workspaceProvider = (WorkspaceProvider)pc.getCurrentProject().getLookup().lookup(WorkspaceProvider.class)).getWorkspaces()).length > 0) {
            for (Workspace workspace : workspaces) {
                int index = this.tabDataModel.size();
                WorkspaceInformation workspaceInformation = (WorkspaceInformation)workspace.getLookup().lookup(WorkspaceInformation.class);
                this.tabDataModel.addTab(index, new TabData((Object)workspace, null, workspaceInformation.getName(), workspaceInformation.getSource()));
                if (workspaceProvider.getCurrentWorkspace() != workspace) continue;
                this.tabbedContainer.getSelectionModel().setSelectedIndex(index);
                ((WorkspaceInformation)workspace.getLookup().lookup(WorkspaceInformation.class)).addChangeListener((PropertyChangeListener)this);
            }
            this.add((Component)this.tabbedContainer, "Center");
            this.getParent().revalidate();
            return;
        }
        this.tabbedContainer.getSelectionModel().clearSelection();
        if (this.tabDataModel.size() > 0) {
            this.tabDataModel.removeTabs(0, this.tabDataModel.size() - 1);
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public void initialize(final Workspace workspace) {
        final WorkspaceInformation workspaceInformation = (WorkspaceInformation)workspace.getLookup().lookup(WorkspaceInformation.class);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WorkspacePanel.this.tabDataModel.addTab(WorkspacePanel.this.tabDataModel.size(), new TabData((Object)workspace, null, workspaceInformation.getName(), workspaceInformation.getSource()));
                if (WorkspacePanel.this.tabDataModel.size() == 1) {
                    WorkspacePanel.this.add((Component)WorkspacePanel.this.tabbedContainer, "Center");
                    WorkspacePanel.this.getParent().revalidate();
                }
            }
        });
    }

    public void select(final Workspace workspace) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < WorkspacePanel.this.tabDataModel.size(); ++i) {
                    TabData tabData = WorkspacePanel.this.tabDataModel.getTab(i);
                    if (tabData.getUserObject() != workspace) continue;
                    if (WorkspacePanel.this.tabbedContainer.getSelectionModel().getSelectedIndex() != i) {
                        WorkspacePanel.this.tabbedContainer.getSelectionModel().setSelectedIndex(i);
                    }
                    WorkspacePanel.this.tabDataModel.setText(i, workspace.getName());
                    ((WorkspaceInformation)workspace.getLookup().lookup(WorkspaceInformation.class)).addChangeListener((PropertyChangeListener)WorkspacePanel.this);
                    break;
                }
            }
        });
    }

    public void unselect(Workspace workspace) {
        ((WorkspaceInformation)workspace.getLookup().lookup(WorkspaceInformation.class)).removeChangeListener((PropertyChangeListener)this);
    }

    public void close(final Workspace workspace) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < WorkspacePanel.this.tabDataModel.size(); ++i) {
                    TabData tabData = WorkspacePanel.this.tabDataModel.getTab(i);
                    if (tabData.getUserObject() != workspace) continue;
                    WorkspacePanel.this.tabDataModel.removeTab(i);
                    break;
                }
                if (WorkspacePanel.this.tabDataModel.size() == 0) {
                    WorkspacePanel.this.tabbedContainer.getSelectionModel().clearSelection();
                    WorkspacePanel.this.remove((Component)WorkspacePanel.this.tabbedContainer);
                    WorkspacePanel.this.getParent().revalidate();
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("rename")) {
            final WorkspaceInformation workspaceInformation = (WorkspaceInformation)evt.getSource();
            final int index = this.tabbedContainer.getSelectionModel().getSelectedIndex();
            if (!this.tabDataModel.getTab(index).getText().equals(workspaceInformation.getName())) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WorkspacePanel.this.tabDataModel.setText(index, workspaceInformation.getName());
                    }
                });
            }
        } else if (evt.getPropertyName().equals("setSource")) {
            final WorkspaceInformation workspaceInformation = (WorkspaceInformation)evt.getSource();
            final int index = this.tabbedContainer.getSelectionModel().getSelectedIndex();
            if (this.tabDataModel.getTab(index).getTooltip() == null || !this.tabDataModel.getTab(index).getTooltip().equals(workspaceInformation.getSource())) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WorkspacePanel.this.tabDataModel.setToolTipTextAt(index, workspaceInformation.getSource());
                    }
                });
            }
        }
    }
}

