/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.jpeg;

import com.drew.metadata.Directory;
import com.drew.metadata.MetadataException;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.jpeg.JpegComponent;
import com.drew.metadata.jpeg.JpegDirectory;

public class JpegDescriptor
extends TagDescriptor {
    public JpegDescriptor(Directory directory) {
        super(directory);
    }

    @Override
    public String getDescription(int tagType) throws MetadataException {
        switch (tagType) {
            case 6: {
                return this.getComponentDataDescription(0);
            }
            case 7: {
                return this.getComponentDataDescription(1);
            }
            case 8: {
                return this.getComponentDataDescription(2);
            }
            case 9: {
                return this.getComponentDataDescription(3);
            }
            case 0: {
                return this.getDataPrecisionDescription();
            }
            case 1: {
                return this.getImageHeightDescription();
            }
            case 3: {
                return this.getImageWidthDescription();
            }
        }
        return this._directory.getString(tagType);
    }

    public String getImageWidthDescription() {
        return String.valueOf(this._directory.getString(3)) + " pixels";
    }

    public String getImageHeightDescription() {
        return String.valueOf(this._directory.getString(1)) + " pixels";
    }

    public String getDataPrecisionDescription() {
        return String.valueOf(this._directory.getString(0)) + " bits";
    }

    public String getComponentDataDescription(int componentNumber) throws MetadataException {
        JpegComponent component = ((JpegDirectory)this._directory).getComponent(componentNumber);
        if (component == null) {
            throw new MetadataException("No Jpeg component exists with number " + componentNumber);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(component.getComponentName());
        sb.append(" component: Quantization table ");
        sb.append(component.getQuantizationTableNumber());
        sb.append(", Sampling factors ");
        sb.append(component.getHorizontalSamplingFactor());
        sb.append(" horiz/");
        sb.append(component.getVerticalSamplingFactor());
        sb.append(" vert");
        return sb.toString();
    }
}

