/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.util.Collection;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.ImplicitTagLibraryInfo;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.compiler.TagConstants;
import org.apache.jasper.compiler.TagLibraryInfoImpl;
import org.apache.tomcat.Jar;
import org.apache.tomcat.util.descriptor.DigesterFactory;
import org.apache.tomcat.util.descriptor.LocalResolver;
import org.apache.tomcat.util.descriptor.tld.TldResourcePath;
import org.apache.tomcat.util.security.PrivilegedGetTccl;
import org.apache.tomcat.util.security.PrivilegedSetTccl;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.EntityResolver2;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

class JspDocumentParser
extends DefaultHandler2
implements TagConstants {
    private static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    private static final String JSP_URI = "http://java.sun.com/JSP/Page";
    private final ParserController parserController;
    private final JspCompilationContext ctxt;
    private final PageInfo pageInfo;
    private final String path;
    private StringBuilder charBuffer;
    private Node current;
    private Node scriptlessBodyNode;
    private Locator locator;
    private Mark startMark;
    private boolean inDTD;
    private boolean isValidating;
    private final EntityResolver2 entityResolver;
    private final ErrorDispatcher err;
    private final boolean isTagFile;
    private final boolean directivesOnly;
    private boolean isTop;
    private int tagDependentNesting = 0;
    private boolean tagDependentPending = false;

    JspDocumentParser(ParserController parserController, String string, boolean bl, boolean bl2) {
        this.parserController = parserController;
        this.ctxt = parserController.getJspCompilationContext();
        this.pageInfo = parserController.getCompiler().getPageInfo();
        this.err = parserController.getCompiler().getErrorDispatcher();
        this.path = string;
        this.isTagFile = bl;
        this.directivesOnly = bl2;
        this.isTop = true;
        String string2 = this.ctxt.getServletContext().getInitParameter("org.apache.jasper.XML_BLOCK_EXTERNAL");
        boolean bl3 = string2 == null ? true : Boolean.parseBoolean(string2);
        this.entityResolver = new LocalResolver(DigesterFactory.SERVLET_API_PUBLIC_IDS, DigesterFactory.SERVLET_API_SYSTEM_IDS, bl3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node.Nodes parse(ParserController parserController, String string, Jar jar, Node node, boolean bl, boolean bl2, String string2, String string3, boolean bl3, boolean bl4) throws JasperException {
        JspDocumentParser jspDocumentParser = new JspDocumentParser(parserController, string, bl, bl2);
        Node.Nodes nodes = null;
        try {
            Node.Root root = new Node.Root(null, node, true);
            root.setPageEncoding(string2);
            root.setJspConfigPageEncoding(string3);
            root.setIsEncodingSpecifiedInProlog(bl3);
            root.setIsBomPresent(bl4);
            jspDocumentParser.current = root;
            if (node == null) {
                jspDocumentParser.addInclude(root, jspDocumentParser.pageInfo.getIncludePrelude());
            } else {
                jspDocumentParser.isTop = false;
            }
            jspDocumentParser.isValidating = false;
            SAXParser sAXParser = JspDocumentParser.getSAXParser(false, jspDocumentParser);
            InputSource inputSource = JspUtil.getInputSource(string, jar, jspDocumentParser.ctxt);
            try {
                sAXParser.parse(inputSource, (DefaultHandler)jspDocumentParser);
            }
            catch (EnableDTDValidationException enableDTDValidationException) {
                sAXParser = JspDocumentParser.getSAXParser(true, jspDocumentParser);
                jspDocumentParser.isValidating = true;
                try {
                    inputSource.getByteStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                inputSource = JspUtil.getInputSource(string, jar, jspDocumentParser.ctxt);
                sAXParser.parse(inputSource, (DefaultHandler)jspDocumentParser);
            }
            finally {
                try {
                    inputSource.getByteStream().close();
                }
                catch (IOException iOException) {}
            }
            if (node == null) {
                jspDocumentParser.addInclude(root, jspDocumentParser.pageInfo.getIncludeCoda());
            }
            nodes = new Node.Nodes(root);
        }
        catch (IOException iOException) {
            jspDocumentParser.err.jspError(iOException, "jsp.error.data.file.read", string);
        }
        catch (SAXParseException sAXParseException) {
            jspDocumentParser.err.jspError(new Mark(jspDocumentParser.ctxt, string, sAXParseException.getLineNumber(), sAXParseException.getColumnNumber()), (Exception)sAXParseException, sAXParseException.getMessage(), new String[0]);
        }
        catch (Exception exception) {
            jspDocumentParser.err.jspError(exception, "jsp.error.data.file.processing", string);
        }
        return nodes;
    }

    private void addInclude(Node node, Collection<String> collection) throws SAXException {
        if (collection != null) {
            for (String string : collection) {
                AttributesImpl attributesImpl = new AttributesImpl();
                attributesImpl.addAttribute("", "file", "file", "CDATA", string);
                Node.IncludeDirective includeDirective = new Node.IncludeDirective(attributesImpl, null, node);
                this.processIncludeDirective(string, includeDirective);
            }
        }
    }

    @Override
    public InputSource getExternalSubset(String string, String string2) throws SAXException, IOException {
        return this.entityResolver.getExternalSubset(string, string2);
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        return this.entityResolver.resolveEntity(string, string2);
    }

    @Override
    public InputSource resolveEntity(String string, String string2, String string3, String string4) throws SAXException, IOException {
        return this.entityResolver.resolveEntity(string, string2, string3, string4);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4;
        AttributesImpl attributesImpl = null;
        AttributesImpl attributesImpl2 = null;
        AttributesImpl attributesImpl3 = null;
        this.processChars();
        this.checkPrefixes(string, string3, attributes);
        if (!(!this.directivesOnly || JSP_URI.equals(string) && string2.startsWith("directive."))) {
            return;
        }
        if (this.current instanceof Node.JspText) {
            throw new SAXParseException(Localizer.getMessage("jsp.error.text.has_subelement"), this.locator);
        }
        this.startMark = new Mark(this.ctxt, this.path, this.locator.getLineNumber(), this.locator.getColumnNumber());
        boolean bl = false;
        for (int i = attributes.getLength() - 1; i >= 0; --i) {
            bl = false;
            string4 = attributes.getQName(i);
            if (!string4.startsWith("xmlns")) {
                if (attributesImpl2 == null) {
                    attributesImpl2 = new AttributesImpl();
                }
                attributesImpl2.addAttribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getType(i), attributes.getValue(i));
                continue;
            }
            if (string4.startsWith("xmlns:jsp")) {
                bl = true;
            } else {
                String string5 = attributes.getValue(i);
                bl = this.pageInfo.hasTaglib(string5);
            }
            if (bl) {
                if (attributesImpl == null) {
                    attributesImpl = new AttributesImpl();
                }
                attributesImpl.addAttribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getType(i), attributes.getValue(i));
                continue;
            }
            if (attributesImpl3 == null) {
                attributesImpl3 = new AttributesImpl();
            }
            attributesImpl3.addAttribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getType(i), attributes.getValue(i));
        }
        Node node = null;
        if (this.tagDependentPending && JSP_URI.equals(string) && string2.equals("body")) {
            this.tagDependentPending = false;
            ++this.tagDependentNesting;
            this.current = this.parseStandardAction(string3, string2, attributesImpl2, attributesImpl3, attributesImpl, this.startMark);
            return;
        }
        if (this.tagDependentPending && JSP_URI.equals(string) && string2.equals("attribute")) {
            this.current = this.parseStandardAction(string3, string2, attributesImpl2, attributesImpl3, attributesImpl, this.startMark);
            return;
        }
        if (this.tagDependentPending) {
            this.tagDependentPending = false;
            ++this.tagDependentNesting;
        }
        if (this.tagDependentNesting > 0) {
            node = new Node.UninterpretedTag(string3, string2, attributesImpl2, attributesImpl3, attributesImpl, this.startMark, this.current);
        } else if (JSP_URI.equals(string)) {
            node = this.parseStandardAction(string3, string2, attributesImpl2, attributesImpl3, attributesImpl, this.startMark);
        } else {
            node = this.parseCustomAction(string3, string2, string, attributesImpl2, attributesImpl3, attributesImpl, this.startMark, this.current);
            if (node == null) {
                node = new Node.UninterpretedTag(string3, string2, attributesImpl2, attributesImpl3, attributesImpl, this.startMark, this.current);
            } else {
                string4 = JspDocumentParser.getBodyType((Node.CustomTag)node);
                if (this.scriptlessBodyNode == null && string4.equalsIgnoreCase("scriptless")) {
                    this.scriptlessBodyNode = node;
                } else if ("tagdependent".equalsIgnoreCase(string4)) {
                    this.tagDependentPending = true;
                }
            }
        }
        this.current = node;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (this.charBuffer == null) {
            this.charBuffer = new StringBuilder();
        }
        this.charBuffer.append(cArray, n, n2);
    }

    private void processChars() throws SAXException {
        int n;
        int n2;
        if (this.charBuffer == null || this.directivesOnly) {
            return;
        }
        boolean bl = true;
        if (!(this.current instanceof Node.JspText) && !(this.current instanceof Node.NamedAttribute)) {
            for (n2 = 0; n2 < this.charBuffer.length(); ++n2) {
                n = this.charBuffer.charAt(n2);
                if (n == 32 || n == 10 || n == 13 || n == 9) continue;
                bl = false;
                break;
            }
        }
        if (!bl && this.tagDependentPending) {
            this.tagDependentPending = false;
            ++this.tagDependentNesting;
        }
        if (this.tagDependentNesting > 0 || this.pageInfo.isELIgnored() || this.current instanceof Node.ScriptingElement) {
            if (this.charBuffer.length() > 0) {
                Node.TemplateText templateText = new Node.TemplateText(this.charBuffer.toString(), this.startMark, this.current);
            }
            this.startMark = new Mark(this.ctxt, this.path, this.locator.getLineNumber(), this.locator.getColumnNumber());
            this.charBuffer = null;
            return;
        }
        if (this.current instanceof Node.JspText || this.current instanceof Node.NamedAttribute || !bl) {
            n2 = this.startMark.getLineNumber();
            n = this.startMark.getColumnNumber();
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < this.charBuffer.length(); ++i) {
                char c;
                block29: {
                    c = this.charBuffer.charAt(i);
                    if (c == '\n') {
                        n = 1;
                        ++n2;
                    } else {
                        ++n;
                    }
                    if ((n3 == 36 || n3 == 35) && c == '{') {
                        n4 = n3;
                        if (charArrayWriter.size() > 0) {
                            Node.TemplateText templateText = new Node.TemplateText(charArrayWriter.toString(), this.startMark, this.current);
                            charArrayWriter.reset();
                            this.startMark = new Mark(this.ctxt, this.path, n2, n - 2);
                        }
                        ++i;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        n3 = 0;
                        while (true) {
                            if (i >= this.charBuffer.length()) {
                                throw new SAXParseException(Localizer.getMessage("jsp.error.unterminated", (char)n4 + "{"), this.locator);
                            }
                            c = this.charBuffer.charAt(i);
                            if (c == '\n') {
                                n = 1;
                                ++n2;
                            } else {
                                ++n;
                            }
                            if (n3 == 92 && (bl2 || bl3)) {
                                charArrayWriter.write(c);
                                n3 = 0;
                            } else {
                                if (c == '}') {
                                    Node.ELExpression eLExpression = new Node.ELExpression((char)n4, charArrayWriter.toString(), this.startMark, this.current);
                                    charArrayWriter.reset();
                                    this.startMark = new Mark(this.ctxt, this.path, n2, n);
                                    break block29;
                                }
                                if (c == '\"') {
                                    bl3 = !bl3;
                                } else if (c == '\'') {
                                    bl2 = !bl2;
                                }
                                charArrayWriter.write(c);
                                n3 = c;
                            }
                            ++i;
                        }
                    }
                    if (n3 == 92 && (c == '$' || c == '#')) {
                        if (this.pageInfo.isELIgnored()) {
                            charArrayWriter.write(92);
                        }
                        charArrayWriter.write(c);
                        c = '\u0000';
                    } else {
                        if (n3 == 36 || n3 == 35 || n3 == 92) {
                            charArrayWriter.write(n3);
                        }
                        if (c != '$' && c != '#' && c != '\\') {
                            charArrayWriter.write(c);
                        }
                    }
                }
                n3 = c;
            }
            if (n3 == 36 || n3 == 35 || n3 == 92) {
                charArrayWriter.write(n3);
            }
            if (charArrayWriter.size() > 0) {
                Node.TemplateText templateText = new Node.TemplateText(charArrayWriter.toString(), this.startMark, this.current);
            }
        }
        this.startMark = new Mark(this.ctxt, this.path, this.locator.getLineNumber(), this.locator.getColumnNumber());
        this.charBuffer = null;
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4;
        Node node;
        int n;
        Node.Nodes nodes;
        this.processChars();
        if (!(!this.directivesOnly || JSP_URI.equals(string) && string2.startsWith("directive."))) {
            return;
        }
        if (this.current instanceof Node.NamedAttribute) {
            boolean bl = ((Node.NamedAttribute)this.current).isTrim();
            nodes = this.current.getBody();
            for (n = 0; nodes != null && n < nodes.size(); ++n) {
                node = nodes.getNode(n);
                if (!(node instanceof Node.TemplateText)) continue;
                if (n == 0) {
                    if (!bl) continue;
                    ((Node.TemplateText)node).ltrim();
                    continue;
                }
                if (n == nodes.size() - 1) {
                    if (!bl) continue;
                    ((Node.TemplateText)node).rtrim();
                    continue;
                }
                if (!((Node.TemplateText)node).isAllSpace()) continue;
                nodes.remove(node);
            }
        } else if (this.current instanceof Node.ScriptingElement) {
            this.checkScriptingBody((Node.ScriptingElement)this.current);
        }
        if (this.isTagDependent(this.current)) {
            --this.tagDependentNesting;
        }
        if (this.scriptlessBodyNode != null && this.current.equals(this.scriptlessBodyNode)) {
            this.scriptlessBodyNode = null;
        }
        if (this.current instanceof Node.CustomTag && "empty".equalsIgnoreCase(string4 = JspDocumentParser.getBodyType((Node.CustomTag)this.current)) && (nodes = this.current.getBody()) != null && nodes.size() > 0) {
            for (n = 0; n < nodes.size(); ++n) {
                node = nodes.getNode(n);
                if (node instanceof Node.NamedAttribute) continue;
                throw new SAXParseException(Localizer.getMessage("jasper.error.emptybodycontent.nonempty", this.current.qName), this.locator);
            }
        }
        if (this.current.getParent() != null) {
            this.current = this.current.getParent();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.processChars();
        if (!this.inDTD) {
            this.startMark = new Mark(this.ctxt, this.path, this.locator.getLineNumber(), this.locator.getColumnNumber());
            Node.Comment comment = new Node.Comment(new String(cArray, n, n2), this.startMark, this.current);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        this.processChars();
        this.startMark = new Mark(this.ctxt, this.path, this.locator.getLineNumber(), this.locator.getColumnNumber());
    }

    @Override
    public void endCDATA() throws SAXException {
        this.processChars();
    }

    @Override
    public void startEntity(String string) throws SAXException {
    }

    @Override
    public void endEntity(String string) throws SAXException {
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
        if (!this.isValidating) {
            this.fatalError(new EnableDTDValidationException("jsp.error.enable_dtd_validation", null));
        }
        this.inDTD = true;
    }

    @Override
    public void endDTD() throws SAXException {
        this.inDTD = false;
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        TagLibraryInfo tagLibraryInfo;
        if (this.directivesOnly && !JSP_URI.equals(string2)) {
            return;
        }
        try {
            tagLibraryInfo = this.getTaglibInfo(string, string2);
        }
        catch (JasperException jasperException) {
            throw new SAXParseException(Localizer.getMessage("jsp.error.could.not.add.taglibraries"), this.locator, (Exception)((Object)jasperException));
        }
        if (tagLibraryInfo != null) {
            if (this.pageInfo.getTaglib(string2) == null) {
                this.pageInfo.addTaglib(string2, tagLibraryInfo);
            }
            this.pageInfo.pushPrefixMapping(string, string2);
        } else {
            this.pageInfo.pushPrefixMapping(string, null);
        }
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
        String string2;
        if (this.directivesOnly && !JSP_URI.equals(string2 = this.pageInfo.getURI(string))) {
            return;
        }
        this.pageInfo.popPrefixMapping(string);
    }

    private Node parseStandardAction(String string, String string2, Attributes attributes, Attributes attributes2, Attributes attributes3, Mark mark) throws SAXException {
        Node node = null;
        if (string2.equals("root")) {
            if (!(this.current instanceof Node.Root)) {
                throw new SAXParseException(Localizer.getMessage("jsp.error.nested_jsproot"), this.locator);
            }
            node = new Node.JspRoot(string, attributes, attributes2, attributes3, mark, this.current);
            if (this.isTop) {
                this.pageInfo.setHasJspRoot(true);
            }
        } else if (string2.equals("directive.page")) {
            if (this.isTagFile) {
                throw new SAXParseException(Localizer.getMessage("jsp.error.action.istagfile", string2), this.locator);
            }
            node = new Node.PageDirective(string, attributes, attributes2, attributes3, mark, this.current);
            String string3 = attributes.getValue("import");
            if (string3 != null) {
                ((Node.PageDirective)node).addImport(string3);
            }
        } else if (string2.equals("directive.include")) {
            node = new Node.IncludeDirective(string, attributes, attributes2, attributes3, mark, this.current);
            this.processIncludeDirective(attributes.getValue("file"), node);
        } else if (string2.equals("declaration")) {
            if (this.scriptlessBodyNode != null) {
                throw new SAXParseException(Localizer.getMessage("jsp.error.no.scriptlets", string2), this.locator);
            }
            node = new Node.Declaration(string, attributes2, attributes3, mark, this.current);
        } else if (string2.equals("scriptlet")) {
            if (this.scriptlessBodyNode != null) {
                throw new SAXParseException(Localizer.getMessage("jsp.error.no.scriptlets", string2), this.locator);
            }
            node = new Node.Scriptlet(string, attributes2, attributes3, mark, this.current);
        } else if (string2.equals("expression")) {
            if (this.scriptlessBodyNode != null) {
                throw new SAXParseException(Localizer.getMessage("jsp.error.no.scriptlets", string2), this.locator);
            }
            node = new Node.Expression(string, attributes2, attributes3, mark, this.current);
        } else if (string2.equals("useBean")) {
            node = new Node.UseBean(string, attributes, attributes2, attributes3, mark, this.current);
        } else if (string2.equals("setProperty")) {
            node = new Node.SetProperty(string, attributes, attributes2, attributes3, mark, this.current);
        } else if (string2.equals("getProperty")) {
            node = new Node.GetProperty(string, attributes, attributes2, attributes3, mark, this.current);
        } else if (string2.equals("include")) {
            node = new Node.IncludeAction(string, attributes, attributes2, attributes3, mark, this.current);
        } else if (string2.equals("forward")) {
            node = new Node.ForwardAction(string, attributes, attributes2, attributes3, mark, this.current);
        } else if (string2.equals("param")) {
            node = new Node.ParamAction(string, attributes, attributes2, attributes3, mark, this.current);
        } else if (string2.equals("params")) {
            node = new Node.ParamsAction(string, attributes2, attributes3, mark, this.current);
        } else if (string2.equals("plugin")) {
            node = new Node.PlugIn(string, attributes, attributes2, attributes3, mark, this.current);
        } else if (string2.equals("text")) {
            node = new Node.JspText(string, attributes2, attributes3, mark, this.current);
        } else if (string2.equals("body")) {
            node = new Node.JspBody(string, attributes2, attributes3, mark, this.current);
        } else if (string2.equals("attribute")) {
            node = new Node.NamedAttribute(string, attributes, attributes2, attributes3, mark, this.current);
        } else if (string2.equals("output")) {
            node = new Node.JspOutput(string, attributes, attributes2, attributes3, mark, this.current);
        } else if (string2.equals("directive.tag")) {
            if (!this.isTagFile) {
                throw new SAXParseException(Localizer.getMessage("jsp.error.action.isnottagfile", string2), this.locator);
            }
            node = new Node.TagDirective(string, attributes, attributes2, attributes3, mark, this.current);
            String string4 = attributes.getValue("import");
            if (string4 != null) {
                ((Node.TagDirective)node).addImport(string4);
            }
        } else if (string2.equals("directive.attribute")) {
            if (!this.isTagFile) {
                throw new SAXParseException(Localizer.getMessage("jsp.error.action.isnottagfile", string2), this.locator);
            }
            node = new Node.AttributeDirective(string, attributes, attributes2, attributes3, mark, this.current);
        } else if (string2.equals("directive.variable")) {
            if (!this.isTagFile) {
                throw new SAXParseException(Localizer.getMessage("jsp.error.action.isnottagfile", string2), this.locator);
            }
            node = new Node.VariableDirective(string, attributes, attributes2, attributes3, mark, this.current);
        } else if (string2.equals("invoke")) {
            if (!this.isTagFile) {
                throw new SAXParseException(Localizer.getMessage("jsp.error.action.isnottagfile", string2), this.locator);
            }
            node = new Node.InvokeAction(string, attributes, attributes2, attributes3, mark, this.current);
        } else if (string2.equals("doBody")) {
            if (!this.isTagFile) {
                throw new SAXParseException(Localizer.getMessage("jsp.error.action.isnottagfile", string2), this.locator);
            }
            node = new Node.DoBodyAction(string, attributes, attributes2, attributes3, mark, this.current);
        } else if (string2.equals("element")) {
            node = new Node.JspElement(string, attributes, attributes2, attributes3, mark, this.current);
        } else if (string2.equals("fallback")) {
            node = new Node.FallBackAction(string, attributes2, attributes3, mark, this.current);
        } else {
            throw new SAXParseException(Localizer.getMessage("jsp.error.xml.badStandardAction", string2), this.locator);
        }
        return node;
    }

    private Node parseCustomAction(String string, String string2, String string3, Attributes attributes, Attributes attributes2, Attributes attributes3, Mark mark, Node node) throws SAXException {
        String string4;
        TagLibraryInfo tagLibraryInfo = this.pageInfo.getTaglib(string3);
        if (tagLibraryInfo == null) {
            return null;
        }
        TagInfo tagInfo = tagLibraryInfo.getTag(string2);
        TagFileInfo tagFileInfo = tagLibraryInfo.getTagFile(string2);
        if (tagInfo == null && tagFileInfo == null) {
            throw new SAXParseException(Localizer.getMessage("jsp.error.xml.bad_tag", string2, string3), this.locator);
        }
        Class<?> clazz = null;
        if (tagInfo != null) {
            string4 = tagInfo.getTagClassName();
            try {
                clazz = this.ctxt.getClassLoader().loadClass(string4);
            }
            catch (Exception exception) {
                throw new SAXParseException(Localizer.getMessage("jsp.error.loadclass.taghandler", string4, string), this.locator, exception);
            }
        }
        string4 = this.getPrefix(string);
        Node.CustomTag customTag = null;
        customTag = tagInfo != null ? new Node.CustomTag(string, string4, string2, string3, attributes, attributes2, attributes3, mark, node, tagInfo, clazz) : new Node.CustomTag(string, string4, string2, string3, attributes, attributes2, attributes3, mark, node, tagFileInfo);
        return customTag;
    }

    private TagLibraryInfo getTaglibInfo(String string, String string2) throws JasperException {
        TagLibraryInfo tagLibraryInfo = null;
        if (string2.startsWith("urn:jsptagdir:")) {
            String string3 = string2.substring("urn:jsptagdir:".length());
            tagLibraryInfo = new ImplicitTagLibraryInfo(this.ctxt, this.parserController, this.pageInfo, string, string3, this.err);
        } else {
            boolean bl = false;
            if (string2.startsWith("urn:jsptld:")) {
                string2 = string2.substring("urn:jsptld:".length());
            } else {
                bl = true;
            }
            TldResourcePath tldResourcePath = this.ctxt.getTldResourcePath(string2);
            if (tldResourcePath != null || !bl) {
                if (this.ctxt.getOptions().isCaching()) {
                    tagLibraryInfo = this.ctxt.getOptions().getCache().get(string2);
                }
                if (tagLibraryInfo == null) {
                    tagLibraryInfo = new TagLibraryInfoImpl(this.ctxt, this.parserController, this.pageInfo, string, string2, tldResourcePath, this.err);
                    if (this.ctxt.getOptions().isCaching()) {
                        this.ctxt.getOptions().getCache().put(string2, tagLibraryInfo);
                    }
                }
            }
        }
        return tagLibraryInfo;
    }

    private void checkScriptingBody(Node.ScriptingElement scriptingElement) throws SAXException {
        Node.Nodes nodes = scriptingElement.getBody();
        if (nodes != null) {
            int n = nodes.size();
            for (int i = 0; i < n; ++i) {
                Node node = nodes.getNode(i);
                if (node instanceof Node.TemplateText) continue;
                String string = "scriptlet";
                if (scriptingElement instanceof Node.Declaration) {
                    string = "declaration";
                }
                if (scriptingElement instanceof Node.Expression) {
                    string = "expression";
                }
                String string2 = Localizer.getMessage("jsp.error.parse.xml.scripting.invalid.body", string);
                throw new SAXParseException(string2, this.locator);
            }
        }
    }

    private void processIncludeDirective(String string, Node node) throws SAXException {
        if (string == null) {
            return;
        }
        try {
            this.parserController.parse(string, node, null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SAXParseException(Localizer.getMessage("jsp.error.file.not.found", string), this.locator, fileNotFoundException);
        }
        catch (Exception exception) {
            throw new SAXParseException(exception.getMessage(), this.locator, exception);
        }
    }

    private void checkPrefixes(String string, String string2, Attributes attributes) {
        this.checkPrefix(string, string2);
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            this.checkPrefix(attributes.getURI(i), attributes.getQName(i));
        }
    }

    private void checkPrefix(String string, String string2) {
        String string3 = this.getPrefix(string2);
        if (string3.length() > 0) {
            this.pageInfo.addPrefix(string3);
            if ("jsp".equals(string3) && !JSP_URI.equals(string)) {
                this.pageInfo.setIsJspPrefixHijacked(true);
            }
        }
    }

    private String getPrefix(String string) {
        int n = string.indexOf(58);
        if (n != -1) {
            return string.substring(0, n);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SAXParser getSAXParser(boolean bl, JspDocumentParser jspDocumentParser) throws Exception {
        ClassLoader classLoader;
        Object object;
        Thread thread = Thread.currentThread();
        if (Constants.IS_SECURITY_ENABLED) {
            object = new PrivilegedGetTccl(thread);
            classLoader = (ClassLoader)AccessController.doPrivileged(object);
        } else {
            classLoader = thread.getContextClassLoader();
        }
        try {
            if (Constants.IS_SECURITY_ENABLED) {
                object = new PrivilegedSetTccl(thread, JspDocumentParser.class.getClassLoader());
                AccessController.doPrivileged(object);
            } else {
                thread.setContextClassLoader(JspDocumentParser.class.getClassLoader());
            }
            object = SAXParserFactory.newInstance();
            ((SAXParserFactory)object).setNamespaceAware(true);
            ((SAXParserFactory)object).setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            ((SAXParserFactory)object).setValidating(bl);
            if (bl) {
                ((SAXParserFactory)object).setFeature("http://xml.org/sax/features/validation", true);
                ((SAXParserFactory)object).setFeature("http://apache.org/xml/features/validation/schema", true);
            }
            SAXParser sAXParser = ((SAXParserFactory)object).newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setProperty(LEXICAL_HANDLER_PROPERTY, jspDocumentParser);
            xMLReader.setErrorHandler(jspDocumentParser);
            SAXParser sAXParser2 = sAXParser;
            return sAXParser2;
        }
        finally {
            if (Constants.IS_SECURITY_ENABLED) {
                PrivilegedSetTccl privilegedSetTccl = new PrivilegedSetTccl(thread, classLoader);
                AccessController.doPrivileged(privilegedSetTccl);
            } else {
                thread.setContextClassLoader(classLoader);
            }
        }
    }

    private static String getBodyType(Node.CustomTag customTag) {
        if (customTag.getTagInfo() != null) {
            return customTag.getTagInfo().getBodyContent();
        }
        return customTag.getTagFileInfo().getTagInfo().getBodyContent();
    }

    private boolean isTagDependent(Node node) {
        if (node instanceof Node.CustomTag) {
            String string = JspDocumentParser.getBodyType((Node.CustomTag)node);
            return "tagdependent".equalsIgnoreCase(string);
        }
        return false;
    }

    private static class EnableDTDValidationException
    extends SAXParseException {
        private static final long serialVersionUID = 1L;

        EnableDTDValidationException(String string, Locator locator) {
            super(string, locator);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

