/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.insights.schema;

import com.datastax.dse.driver.internal.core.insights.schema.LoadBalancingInfo;
import com.datastax.dse.driver.internal.core.insights.schema.SpeculativeExecutionInfo;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SpecificExecutionProfile {
    @JsonProperty(value="readTimeout")
    private final Integer readTimeout;
    @JsonProperty(value="loadBalancing")
    private final LoadBalancingInfo loadBalancing;
    @JsonProperty(value="speculativeExecution")
    private SpeculativeExecutionInfo speculativeExecution;
    @JsonProperty(value="consistency")
    private final String consistency;
    @JsonProperty(value="serialConsistency")
    private final String serialConsistency;
    @JsonProperty(value="graphOptions")
    private Map<String, Object> graphOptions;

    @JsonCreator
    public SpecificExecutionProfile(@JsonProperty(value="readTimeout") Integer readTimeoutMillis, @JsonProperty(value="loadBalancing") LoadBalancingInfo loadBalancing, @JsonProperty(value="speculativeExecution") SpeculativeExecutionInfo speculativeExecutionInfo, @JsonProperty(value="consistency") String consistency, @JsonProperty(value="serialConsistency") String serialConsistency, @JsonProperty(value="graphOptions") Map<String, Object> graphOptions) {
        this.readTimeout = readTimeoutMillis;
        this.loadBalancing = loadBalancing;
        this.speculativeExecution = speculativeExecutionInfo;
        this.consistency = consistency;
        this.serialConsistency = serialConsistency;
        this.graphOptions = graphOptions;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public LoadBalancingInfo getLoadBalancing() {
        return this.loadBalancing;
    }

    public SpeculativeExecutionInfo getSpeculativeExecution() {
        return this.speculativeExecution;
    }

    public String getConsistency() {
        return this.consistency;
    }

    public String getSerialConsistency() {
        return this.serialConsistency;
    }

    public Map<String, Object> getGraphOptions() {
        return this.graphOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpecificExecutionProfile)) {
            return false;
        }
        SpecificExecutionProfile that = (SpecificExecutionProfile)o;
        return Objects.equals(this.readTimeout, that.readTimeout) && Objects.equals(this.loadBalancing, that.loadBalancing) && Objects.equals(this.speculativeExecution, that.speculativeExecution) && Objects.equals(this.consistency, that.consistency) && Objects.equals(this.serialConsistency, that.serialConsistency) && Objects.equals(this.graphOptions, that.graphOptions);
    }

    public int hashCode() {
        return Objects.hash(this.readTimeout, this.loadBalancing, this.speculativeExecution, this.consistency, this.serialConsistency, this.graphOptions);
    }

    public String toString() {
        return "SpecificExecutionProfile{readTimeout=" + this.readTimeout + ", loadBalancing=" + this.loadBalancing + ", speculativeExecution=" + this.speculativeExecution + ", consistency='" + this.consistency + '\'' + ", serialConsistency='" + this.serialConsistency + '\'' + ", graphOptions=" + this.graphOptions + '}';
    }
}

