/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.CursorFlag;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.SqlCountHolder;
import org.firebirdsql.gds.ng.StatementState;
import org.firebirdsql.gds.ng.StatementType;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.listeners.StatementListener;
import org.firebirdsql.jaybird.parser.FirebirdReservedWords;
import org.firebirdsql.jaybird.parser.LocalStatementType;
import org.firebirdsql.jaybird.parser.SqlParser;
import org.firebirdsql.jaybird.parser.StatementDetector;
import org.firebirdsql.jdbc.CompletionReason;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdRowUpdater;
import org.firebirdsql.jdbc.FirebirdStatement;
import org.firebirdsql.jdbc.GeneratedKeysSupport;
import org.firebirdsql.jdbc.QuoteStrategy;
import org.firebirdsql.jdbc.escape.FBEscapedParser;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.util.FirebirdSupportInfo;
import org.firebirdsql.util.Primitives;

public class FBStatement
implements FirebirdStatement {
    private static final Logger log = LoggerFactory.getLogger(FBStatement.class);
    private static final AtomicInteger STATEMENT_ID_GENERATOR = new AtomicInteger();
    private final int localStatementId = STATEMENT_ID_GENERATOR.incrementAndGet();
    protected final GDSHelper gdsHelper;
    protected final FBObjectListener.StatementListener statementListener;
    protected FbStatement fbStatement;
    private FBResultSet currentRs;
    private SqlCountHolder sqlCountHolder;
    private boolean closed;
    protected boolean completed = true;
    private boolean escapedProcessing = true;
    private volatile boolean closeOnCompletion;
    private boolean currentStatementGeneratedKeys;
    protected SQLWarning firstWarning;
    private LocalStatementType jbStatementType = LocalStatementType.OTHER;
    protected StatementResult currentStatementResult = StatementResult.NO_MORE_RESULTS;
    protected boolean isSingletonResult;
    protected final List<RowValue> specialResult = new ArrayList<RowValue>();
    protected int maxRows;
    protected int fetchSize;
    private int maxFieldSize;
    private String cursorName;
    private final int rsConcurrency;
    private final int rsType;
    private final int rsHoldability;
    private int fetchDirection = 1000;
    private final FBObjectListener.ResultSetListener resultSetListener = new RSListener();
    protected final FBConnection connection;
    private static final Set<StatementState> INVALID_STATEMENT_STATES = EnumSet.of(StatementState.ERROR, StatementState.CLOSING, StatementState.CLOSED);
    private static final int INSERTED_ROWS_COUNT = 1;
    private static final int UPDATED_ROWS_COUNT = 2;
    private static final int DELETED_ROWS_COUNT = 3;
    private List<String> batchList = new ArrayList<String>();
    private static final Pattern SIMPLE_IDENTIFIER_PATTERN = Pattern.compile("\\p{Alpha}[\\p{Alnum}_$]*");

    protected FBStatement(GDSHelper c, int rsType, int rsConcurrency, int rsHoldability, FBObjectListener.StatementListener statementListener) throws SQLException {
        this.gdsHelper = c;
        this.rsConcurrency = rsConcurrency;
        this.rsType = rsType;
        this.rsHoldability = rsHoldability;
        this.statementListener = statementListener;
        this.connection = statementListener != null ? statementListener.getConnection() : null;
        this.closed = false;
    }

    String getCursorName() {
        return this.cursorName;
    }

    @Override
    public boolean isValid() {
        return !this.closed && !INVALID_STATEMENT_STATES.contains((Object)this.fbStatement.getState());
    }

    protected final LockCloseable withLock() {
        return this.gdsHelper.withLock();
    }

    public void completeStatement() throws SQLException {
        this.completeStatement(CompletionReason.OTHER);
    }

    public void completeStatement(CompletionReason reason) throws SQLException {
        if (this.currentRs != null && (reason != CompletionReason.COMMIT || this.currentRs.getHoldability() == 2)) {
            this.closeResultSet(false, reason);
        }
        if (!this.completed) {
            this.notifyStatementCompleted();
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkValidity();
        this.currentStatementGeneratedKeys = false;
        try (LockCloseable ignored = this.withLock();){
            this.notifyStatementStarted();
            if (!this.internalExecute(sql)) {
                throw new FBSQLException("Query did not return a result set.", "07005");
            }
            ResultSet resultSet = this.getResultSet();
            return resultSet;
        }
    }

    protected void notifyStatementStarted() throws SQLException {
        this.notifyStatementStarted(true);
    }

    protected void notifyStatementStarted(boolean closeResultSet) throws SQLException {
        if (closeResultSet) {
            this.closeResultSet(false);
        }
        this.statementListener.executionStarted(this);
        if (this.fbStatement != null) {
            this.fbStatement.setTransaction(this.gdsHelper.getCurrentTransaction());
        }
        this.completed = false;
    }

    protected void notifyStatementCompleted() throws SQLException {
        this.notifyStatementCompleted(true);
    }

    protected void notifyStatementCompleted(boolean success) throws SQLException {
        this.completed = true;
        this.statementListener.statementCompleted(this, success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkValidity();
        this.currentStatementGeneratedKeys = false;
        Throwable throwable = null;
        try (LockCloseable ignored = this.withLock();){
            int n;
            this.notifyStatementStarted();
            try {
                if (this.internalExecute(sql)) {
                    throw new FBSQLException("Update statement returned results.");
                }
                n = this.getUpdateCountMinZero();
            }
            catch (Throwable throwable2) {
                try {
                    this.notifyStatementCompleted();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            this.notifyStatementCompleted();
            return n;
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (this.execute(sql, autoGeneratedKeys)) {
                throw new FBSQLException("Update statement returned results.");
            }
            int n = this.getUpdateCountMinZero();
            return n;
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (this.execute(sql, columnIndexes)) {
                throw new FBSQLException("Update statement returned results.");
            }
            int n = this.getUpdateCountMinZero();
            return n;
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (this.execute(sql, columnNames)) {
                throw new FBSQLException("Update statement returned results.");
            }
            int n = this.getUpdateCountMinZero();
            return n;
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            GeneratedKeysSupport.Query query = this.connection.getGeneratedKeysSupport().buildQuery(sql, autoGeneratedKeys);
            boolean bl = this.executeImpl(query);
            return bl;
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            GeneratedKeysSupport.Query query = this.connection.getGeneratedKeysSupport().buildQuery(sql, columnIndexes);
            boolean bl = this.executeImpl(query);
            return bl;
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            GeneratedKeysSupport.Query query = this.connection.getGeneratedKeysSupport().buildQuery(sql, columnNames);
            boolean bl = this.executeImpl(query);
            return bl;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkValidity();
        if (this.isGeneratedKeyQuery()) {
            return new FBResultSet(this.fbStatement.getRowDescriptor(), this.connection, new ArrayList<RowValue>(this.specialResult), this.resultSetListener, true, false);
        }
        return new FBResultSet(this.fbStatement.emptyRowDescriptor(), Collections.emptyList());
    }

    @Override
    public void close() throws SQLException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean ignoreAlreadyClosed) throws SQLException {
        block20: {
            if (this.isClosed()) {
                if (ignoreAlreadyClosed) {
                    return;
                }
                throw new FBSQLException("This statement is already closed.");
            }
            try (LockCloseable ignored = this.withLock();){
                if (this.fbStatement == null) break block20;
                try {
                    try {
                        this.closeResultSet(false, CompletionReason.STATEMENT_CLOSE);
                    }
                    finally {
                        this.fbStatement.close();
                    }
                }
                finally {
                    this.fbStatement = null;
                    this.batchList = null;
                }
            }
        }
        this.closed = true;
        this.statementListener.statementClosed(this);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        if (max < 0) {
            throw new FBSQLException("Can't set max field size negative", "HY009");
        }
        this.maxFieldSize = max;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new FBSQLException("Max rows can't be less than 0", "HY009");
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.escapedProcessing = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            if (this.fbStatement == null) {
                int n = 0;
                return n;
            }
            int n = (int)TimeUnit.MILLISECONDS.toSeconds(this.fbStatement.getTimeout());
            return n;
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            this.requireStatement().setTimeout(TimeUnit.SECONDS.toMillis(seconds));
        }
    }

    @Override
    public void cancel() throws SQLException {
        this.checkValidity();
        if (!FirebirdSupportInfo.supportInfoFor(this.connection).supportsCancelOperation()) {
            throw new SQLFeatureNotSupportedException("Cancel not supported");
        }
        this.gdsHelper.cancelOperation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.firstWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.firstWarning = null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.cursorName = name;
    }

    boolean isUpdatableCursor() {
        return this.cursorName != null;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkValidity();
        this.currentStatementGeneratedKeys = false;
        return this.executeImpl(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeImpl(String sql) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.notifyStatementStarted();
            boolean hasResultSet = false;
            try {
                hasResultSet = this.internalExecute(sql);
            }
            finally {
                if (!hasResultSet) {
                    this.notifyStatementCompleted();
                }
            }
            boolean bl = hasResultSet;
            return bl;
        }
    }

    private boolean executeImpl(GeneratedKeysSupport.Query query) throws SQLException {
        this.currentStatementGeneratedKeys = query.generatesKeys();
        return this.executeImpl(query.getQueryString());
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkValidity();
        return this.getResultSet(false);
    }

    public ResultSet getResultSet(boolean metaDataQuery) throws SQLException {
        if (this.fbStatement == null) {
            throw new FBSQLException("No statement was executed.");
        }
        if (this.currentRs != null) {
            return this.currentRs;
        }
        if (this.cursorName != null) {
            this.fbStatement.setCursorName(this.cursorName);
        }
        if (!this.isGeneratedKeyQuery() && this.currentStatementResult.isResultSet()) {
            if (!this.isSingletonResult) {
                if (this.cursorName != null) {
                    this.fbStatement.setCursorName(this.cursorName);
                }
                this.currentRs = new FBResultSet(this.connection, this, this.fbStatement, this.resultSetListener, metaDataQuery, this.rsType, this.rsConcurrency, this.rsHoldability, false);
                return this.currentRs;
            }
            if (!this.specialResult.isEmpty()) {
                this.currentRs = this.createSpecialResultSet(this.resultSetListener);
                return this.currentRs;
            }
        }
        return null;
    }

    protected FBResultSet createSpecialResultSet(FBObjectListener.ResultSetListener resultSetListener) throws SQLException {
        return new FBResultSet(this.fbStatement.getRowDescriptor(), this.connection, new ArrayList<RowValue>(this.specialResult), resultSetListener, true, false);
    }

    @Override
    public boolean hasOpenResultSet() {
        return this.currentRs != null;
    }

    protected final int getUpdateCountMinZero() throws SQLException {
        return Math.max(0, this.getUpdateCount());
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkValidity();
        if (this.currentStatementResult != StatementResult.UPDATE_COUNT) {
            return -1;
        }
        this.populateSqlCounts();
        int insCount = this.sqlCountHolder.getIntegerInsertCount();
        int updCount = this.sqlCountHolder.getIntegerUpdateCount();
        int delCount = this.sqlCountHolder.getIntegerDeleteCount();
        return Math.max(Math.max(updCount, delCount), insCount);
    }

    private void populateSqlCounts() throws SQLException {
        if (this.sqlCountHolder == null) {
            this.sqlCountHolder = this.fbStatement.getSqlCounts();
        }
    }

    private int getChangedRowsCount(int type) throws SQLException {
        if (this.currentStatementResult != StatementResult.UPDATE_COUNT) {
            return -1;
        }
        this.populateSqlCounts();
        switch (type) {
            case 1: {
                return this.sqlCountHolder.getIntegerInsertCount();
            }
            case 2: {
                return this.sqlCountHolder.getIntegerUpdateCount();
            }
            case 3: {
                return this.sqlCountHolder.getIntegerDeleteCount();
            }
        }
        throw new IllegalArgumentException(String.format("Specified type %d is unknown.", type));
    }

    @Override
    public int getDeletedRowsCount() throws SQLException {
        return this.getChangedRowsCount(3);
    }

    @Override
    public int getInsertedRowsCount() throws SQLException {
        return this.getChangedRowsCount(1);
    }

    @Override
    public int getUpdatedRowsCount() throws SQLException {
        return this.getChangedRowsCount(2);
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(3);
    }

    @Override
    public boolean getMoreResults(int mode) throws SQLException {
        boolean closeResultSet;
        this.checkValidity();
        boolean bl = closeResultSet = mode == 3 || mode == 1;
        if (this.currentStatementResult.isResultSet() && closeResultSet) {
            this.closeResultSet(true);
        }
        this.currentStatementResult = this.currentStatementResult.nextResult();
        return this.currentStatementResult.isResultSet();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkValidity();
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                this.fetchDirection = direction;
                break;
            }
            default: {
                throw FbExceptionBuilder.forException(337248278).messageParameter(direction).toSQLException();
            }
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkValidity();
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkValidity();
        if (rows < 0) {
            throw new FBSQLException("Can't set negative fetch size", "HY009");
        }
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkValidity();
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.rsConcurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.rsType;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.rsHoldability;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkValidity();
        try (LockCloseable ignored = this.withLock();){
            this.batchList.add(sql);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkValidity();
        try (LockCloseable ignored = this.withLock();){
            this.batchList.clear();
        }
    }

    @Override
    public final int[] executeBatch() throws SQLException {
        if (this.connection.getAutoCommit()) {
            this.addWarning(new SQLWarning("Batch updates should be run with auto-commit disabled.", "01000"));
        }
        return Primitives.toIntArray(this.executeBatchInternal());
    }

    /*
     * Exception decompiling
     */
    protected List<Long> executeBatchInternal() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void executeSingleForBatch(List<Long> responses, String sql) throws SQLException {
        if (this.internalExecute(sql)) {
            throw this.createBatchUpdateException("Statements executed as batch should not produce a result set", "HY000", 0, Primitives.toLongArray(responses), null);
        }
        responses.add(this.getLargeUpdateCountMinZero());
    }

    protected final BatchUpdateException createBatchUpdateException(String reason, String SQLState, int vendorCode, long[] updateCounts, Throwable cause) {
        return new BatchUpdateException(reason, SQLState, vendorCode, updateCounts, cause);
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkValidity();
        return this.connection;
    }

    void closeResultSet(boolean notifyListener) throws SQLException {
        this.closeResultSet(notifyListener, CompletionReason.OTHER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeResultSet(boolean notifyListener, CompletionReason completionReason) throws SQLException {
        boolean wasCompleted = this.completed;
        try {
            FBResultSet currentRs = this.currentRs;
            if (currentRs != null) {
                this.currentRs = null;
                currentRs.close(notifyListener, completionReason);
            }
        }
        finally {
            try {
                if (this.fbStatement != null) {
                    this.fbStatement.ensureClosedCursor(completionReason.isTransactionEnd());
                }
            }
            finally {
                if (notifyListener && !wasCompleted) {
                    this.statementListener.statementCompleted(this);
                }
            }
        }
    }

    @Override
    @Deprecated
    public ResultSet getCurrentResultSet() throws SQLException {
        return this.getResultSet();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkValidity();
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkValidity();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Unable to unwrap to class " + iface.getName());
        }
        return iface.cast(this);
    }

    @Override
    public void closeOnCompletion() {
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() {
        return this.closeOnCompletion;
    }

    protected boolean internalExecute(String sql) throws SQLException {
        this.checkValidity();
        this.prepareFixedStatement(sql);
        return this.internalExecute(RowValue.EMPTY_ROW_VALUE);
    }

    protected boolean internalExecute(RowValue rowValue) throws SQLException {
        try {
            this.fbStatement.execute(rowValue);
            boolean hasResultSet = this.currentStatementResult.isResultSet();
            if (hasResultSet && this.isGeneratedKeyQuery()) {
                this.fetchMultiRowGeneratedKeys();
                return false;
            }
            return hasResultSet;
        }
        catch (SQLException e) {
            this.currentStatementResult = StatementResult.NO_MORE_RESULTS;
            throw e;
        }
    }

    private void fetchMultiRowGeneratedKeys() throws SQLException {
        RowsFetchedListener rowsFetchedListener = new RowsFetchedListener();
        try {
            this.fbStatement.addStatementListener(rowsFetchedListener);
            while (!rowsFetchedListener.isAllRowsFetched()) {
                this.fbStatement.fetchRows(Integer.MAX_VALUE);
            }
            this.fbStatement.closeCursor();
            this.currentStatementResult = StatementResult.UPDATE_COUNT;
        }
        finally {
            this.fbStatement.removeStatementListener(rowsFetchedListener);
        }
    }

    protected void prepareFixedStatement(String sql) throws SQLException {
        if (this.fbStatement == null) {
            this.requireStatement();
        } else {
            this.fbStatement.setTransaction(this.gdsHelper.getCurrentTransaction());
        }
        String statementText = this.escapedProcessing ? this.nativeSQL(sql) : sql;
        this.fbStatement.prepare(statementText);
        StatementType fbStatementType = this.fbStatement.getType();
        this.jbStatementType = fbStatementType == StatementType.SELECT || fbStatementType == StatementType.STORED_PROCEDURE ? FBStatement.determineJaybirdStatementType(statementText) : LocalStatementType.OTHER;
    }

    private static LocalStatementType determineJaybirdStatementType(String statementText) {
        StatementDetector detector = new StatementDetector(false);
        SqlParser.withReservedWords(FirebirdReservedWords.latest()).withVisitor(detector).of(statementText).parse();
        return detector.getStatementType();
    }

    protected FbStatement requireStatement() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (this.fbStatement == null) {
                this.fbStatement = this.gdsHelper.allocateStatement();
                this.fbStatement.addStatementListener(this.createStatementListener());
                if (this.needsScrollableCursorEnabled()) {
                    this.fbStatement.setCursorFlag(CursorFlag.CURSOR_TYPE_SCROLLABLE);
                }
            }
            FbStatement fbStatement = this.fbStatement;
            return fbStatement;
        }
    }

    protected boolean needsScrollableCursorEnabled() {
        return this.rsType != 1003 && this.rsHoldability != 1 && this.connection != null && this.connection.isScrollableCursor("SERVER") && this.fbStatement.supportsFetchScroll();
    }

    protected void addWarning(SQLWarning warning) {
        if (this.firstWarning == null) {
            this.firstWarning = warning;
        } else {
            this.firstWarning.setNextWarning(warning);
        }
    }

    protected String nativeSQL(String sql) throws SQLException {
        if (this.connection != null) {
            return this.connection.nativeSQL(sql);
        }
        return FBEscapedParser.toNativeSql(sql);
    }

    protected boolean isGeneratedKeyQuery() {
        return this.currentStatementGeneratedKeys;
    }

    String getExecutionPlan() throws SQLException {
        return this.fbStatement.getExecutionPlan();
    }

    String getExplainedExecutionPlan() throws SQLException {
        return this.fbStatement.getExplainedExecutionPlan();
    }

    @Override
    public String getLastExecutionPlan() throws SQLException {
        this.checkValidity();
        if (this.fbStatement == null) {
            throw new FBSQLException("No statement was executed, plan cannot be obtained.");
        }
        return this.getExecutionPlan();
    }

    @Override
    public String getLastExplainedExecutionPlan() throws SQLException {
        this.checkValidity();
        if (this.fbStatement == null) {
            throw new FBSQLException("No statement was executed, detailed plan cannot be obtained.");
        }
        return this.getExplainedExecutionPlan();
    }

    int getStatementType() throws SQLException {
        if (this.fbStatement == null) {
            return StatementType.NONE.getStatementTypeCode();
        }
        return this.fbStatement.getType().getStatementTypeCode();
    }

    protected void checkValidity() throws SQLException {
        if (this.isClosed()) {
            throw new FBSQLException("Statement is already closed.", "26000");
        }
    }

    protected final long getLargeUpdateCountMinZero() throws SQLException {
        return Math.max(0L, this.getLargeUpdateCount());
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.checkValidity();
        if (this.currentStatementResult != StatementResult.UPDATE_COUNT) {
            return -1L;
        }
        this.populateSqlCounts();
        long insCount = this.sqlCountHolder.getLongInsertCount();
        long updCount = this.sqlCountHolder.getLongUpdateCount();
        long delCount = this.sqlCountHolder.getLongDeleteCount();
        return Math.max(Math.max(insCount, updCount), delCount);
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        if (max > Integer.MAX_VALUE) {
            this.addWarning(new SQLWarning(String.format("Implementation limit: maxRows cannot exceed Integer.MAX_VALUE, value was %d, reset to 0", max), "HY009"));
            max = 0L;
        }
        this.setMaxRows((int)max);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        return this.getMaxRows();
    }

    @Override
    public final long[] executeLargeBatch() throws SQLException {
        if (this.connection.getAutoCommit()) {
            this.addWarning(new SQLWarning("Batch updates should be run with auto-commit disabled.", "01000"));
        }
        return Primitives.toLongArray(this.executeBatchInternal());
    }

    @Override
    public final long executeLargeUpdate(String sql) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.executeUpdate(sql);
            long l = this.getLargeUpdateCountMinZero();
            return l;
        }
    }

    @Override
    public final long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (this.execute(sql, autoGeneratedKeys)) {
                throw new FBSQLException("Update statement returned results.");
            }
            long l = this.getLargeUpdateCountMinZero();
            return l;
        }
    }

    @Override
    public final long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (this.execute(sql, columnIndexes)) {
                throw new FBSQLException("Update statement returned results.");
            }
            long l = this.getLargeUpdateCountMinZero();
            return l;
        }
    }

    @Override
    public final long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (this.execute(sql, columnNames)) {
                throw new FBSQLException("Update statement returned results.");
            }
            long l = this.getLargeUpdateCountMinZero();
            return l;
        }
    }

    @Override
    public String enquoteLiteral(String val) throws SQLException {
        if (this.gdsHelper.getCurrentDatabase().getDatabaseDialect() == 1) {
            return '\"' + val.replace("\"", "\"\"") + '\"';
        }
        return "'" + val.replace("'", "''") + "'";
    }

    @Override
    public String enquoteNCharLiteral(String val) throws SQLException {
        return this.enquoteLiteral(val);
    }

    @Override
    public String enquoteIdentifier(String identifier, boolean alwaysQuote) throws SQLException {
        int len = identifier.length();
        if (len < 1 || len > this.connection.getMetaData().getMaxColumnNameLength()) {
            throw new SQLException("Invalid name");
        }
        if (!alwaysQuote && SIMPLE_IDENTIFIER_PATTERN.matcher(identifier).matches()) {
            return identifier;
        }
        QuoteStrategy quoteStrategy = this.connection.getQuoteStrategy();
        if (quoteStrategy == QuoteStrategy.NO_QUOTES) {
            throw new SQLFeatureNotSupportedException("Quoted identifiers not supported in dialect 1");
        }
        if (identifier.matches("^\".+\"$")) {
            return identifier;
        }
        return quoteStrategy.quoteObjectName(identifier);
    }

    @Override
    public boolean isSimpleIdentifier(String identifier) throws SQLException {
        int len = identifier.length();
        return len >= 1 && len <= this.connection.getMetaData().getMaxColumnNameLength() && SIMPLE_IDENTIFIER_PATTERN.matcher(identifier).matches();
    }

    @Override
    public final int getLocalStatementId() {
        return this.localStatementId;
    }

    public final int hashCode() {
        return this.localStatementId;
    }

    public final boolean equals(Object other) {
        if (!(other instanceof FirebirdStatement)) {
            return false;
        }
        FirebirdStatement otherStmt = (FirebirdStatement)other;
        return this.localStatementId == otherStmt.getLocalStatementId();
    }

    protected StatementListener createStatementListener() {
        return new FBStatementListener();
    }

    private static final class RowsFetchedListener
    implements StatementListener {
        private boolean allRowsFetched;

        private RowsFetchedListener() {
        }

        @Override
        public void afterLast(FbStatement sender) {
            this.allRowsFetched = true;
        }

        public boolean isAllRowsFetched() {
            return this.allRowsFetched;
        }
    }

    private final class FBStatementListener
    implements StatementListener {
        private FBStatementListener() {
        }

        @Override
        public void receivedRow(FbStatement sender, RowValue rowValue) {
            if (this.isUnexpectedSender(sender)) {
                return;
            }
            if (FBStatement.this.isSingletonResult) {
                FBStatement.this.specialResult.clear();
                FBStatement.this.specialResult.add(rowValue);
            } else if (FBStatement.this.isGeneratedKeyQuery()) {
                FBStatement.this.specialResult.add(rowValue);
            }
        }

        @Override
        public void statementExecuted(FbStatement sender, boolean hasResultSet, boolean hasSingletonResult) {
            if (this.isUnexpectedSender(sender)) {
                return;
            }
            FBStatement.this.currentStatementResult = this.determineInitialStatementResult(hasResultSet, hasSingletonResult);
            FBStatement.this.isSingletonResult = hasSingletonResult;
        }

        private StatementResult determineInitialStatementResult(boolean hasResultSet, boolean hasSingletonResult) {
            if (hasResultSet || hasSingletonResult && !FBStatement.this.isGeneratedKeyQuery()) {
                if (FBStatement.this.jbStatementType == LocalStatementType.SELECT) {
                    return StatementResult.RESULT_SET;
                }
                return StatementResult.RESULT_SET_WITH_UPDATE_COUNT;
            }
            if (FBStatement.this.fbStatement.getType().isTypeWithUpdateCounts() && FBStatement.this.jbStatementType != LocalStatementType.EXECUTE_PROCEDURE) {
                return StatementResult.UPDATE_COUNT;
            }
            return StatementResult.NO_MORE_RESULTS;
        }

        @Override
        public void statementStateChanged(FbStatement sender, StatementState newState, StatementState previousState) {
            if (this.isUnexpectedSender(sender)) {
                return;
            }
            switch (newState) {
                case PREPARED: {
                    break;
                }
                case EXECUTING: {
                    FBStatement.this.specialResult.clear();
                    FBStatement.this.sqlCountHolder = null;
                    FBStatement.this.currentStatementResult = StatementResult.NO_MORE_RESULTS;
                    FBStatement.this.isSingletonResult = false;
                    try {
                        FBStatement.this.clearWarnings();
                        break;
                    }
                    catch (SQLException e) {
                        throw new AssertionError("Unexpected SQLException", e);
                    }
                }
            }
        }

        @Override
        public void warningReceived(FbStatement sender, SQLWarning warning) {
            if (this.isUnexpectedSender(sender)) {
                return;
            }
            FBStatement.this.addWarning(warning);
        }

        @Override
        public void sqlCounts(FbStatement sender, SqlCountHolder sqlCounts) {
            if (this.isUnexpectedSender(sender)) {
                return;
            }
            FBStatement.this.sqlCountHolder = sqlCounts;
        }

        private boolean isUnexpectedSender(FbStatement sender) {
            if (sender != FBStatement.this.fbStatement) {
                log.debugf("Received statement listener update from unrelated statement [%s]", (Object)sender);
                sender.removeStatementListener(this);
                return true;
            }
            return false;
        }
    }

    protected static enum StatementResult {
        RESULT_SET(true){

            @Override
            public StatementResult nextResult() {
                return NO_MORE_RESULTS;
            }
        }
        ,
        RESULT_SET_WITH_UPDATE_COUNT(true){

            @Override
            public StatementResult nextResult() {
                return UPDATE_COUNT;
            }
        }
        ,
        UPDATE_COUNT(false){

            @Override
            public StatementResult nextResult() {
                return NO_MORE_RESULTS;
            }
        }
        ,
        NO_MORE_RESULTS(false){

            @Override
            public StatementResult nextResult() {
                return NO_MORE_RESULTS;
            }
        };

        private final boolean resultSet;

        private StatementResult(boolean resultSet) {
            this.resultSet = resultSet;
        }

        public abstract StatementResult nextResult();

        public final boolean isResultSet() {
            return this.resultSet;
        }
    }

    private final class RSListener
    implements FBObjectListener.ResultSetListener {
        private boolean rowUpdaterSeparateTransaction;

        private RSListener() {
        }

        @Override
        public void resultSetClosed(ResultSet rs) throws SQLException {
            FBStatement.this.currentRs = null;
            FBStatement.this.notifyStatementCompleted();
            if (FBStatement.this.closeOnCompletion) {
                FBStatement.this.close();
            }
        }

        @Override
        public void allRowsFetched(ResultSet rs) throws SQLException {
            if (FBStatement.this.connection != null && FBStatement.this.connection.getAutoCommit()) {
                rs.close();
            }
        }

        @Override
        public void executionCompleted(FirebirdRowUpdater updater, boolean success) throws SQLException {
            if (this.rowUpdaterSeparateTransaction) {
                FBStatement.this.notifyStatementCompleted(success);
            }
        }

        @Override
        public void executionStarted(FirebirdRowUpdater updater) throws SQLException {
            FbTransaction stmtTransaction;
            FbTransaction fbTransaction = stmtTransaction = FBStatement.this.fbStatement != null ? FBStatement.this.fbStatement.getTransaction() : null;
            if (stmtTransaction != null && stmtTransaction.getState() == TransactionState.ACTIVE) {
                this.rowUpdaterSeparateTransaction = false;
            } else {
                this.rowUpdaterSeparateTransaction = true;
                FBStatement.this.notifyStatementStarted(false);
            }
        }
    }
}

