/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBParameterMetaData;
import org.firebirdsql.jdbc.FBPreparedStatement;
import org.firebirdsql.jdbc.FBProcedureCall;
import org.firebirdsql.jdbc.FBProcedureParam;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdCallableStatement;
import org.firebirdsql.jdbc.StoredProcedureMetaData;
import org.firebirdsql.jdbc.escape.FBEscapedCallParser;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.TypeConversionException;

public class FBCallableStatement
extends FBPreparedStatement
implements CallableStatement,
FirebirdCallableStatement {
    static final String SET_BY_STRING_NOT_SUPPORTED = "Setting parameters by name is not supported";
    static final String NATIVE_CALL_COMMAND = "EXECUTE PROCEDURE ";
    static final String NATIVE_SELECT_COMMAND = "SELECT * FROM ";
    private ResultSet singletonRs;
    protected boolean selectableProcedure;
    protected FBProcedureCall procedureCall;
    private List<FBProcedureCall> batchList = new ArrayList<FBProcedureCall>();

    protected FBCallableStatement(GDSHelper c, String sql, int rsType, int rsConcurrency, int rsHoldability, StoredProcedureMetaData storedProcMetaData, FBObjectListener.StatementListener statementListener, FBObjectListener.BlobListener blobListener) throws SQLException {
        super(c, rsType, rsConcurrency, rsHoldability, statementListener, blobListener);
        FBEscapedCallParser parser = new FBEscapedCallParser();
        this.procedureCall = parser.parseCall(this.nativeSQL(sql));
        if (storedProcMetaData.canGetSelectableInformation()) {
            this.setSelectabilityAutomatically(storedProcMetaData);
        }
    }

    @Override
    void close(boolean ignoreAlreadyClosed) throws SQLException {
        this.batchList = null;
        super.close(ignoreAlreadyClosed);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.notifyStatementStarted(false);
            this.prepareFixedStatement(this.procedureCall.getSQL(this.isSelectableProcedure()));
            FBParameterMetaData fBParameterMetaData = new FBParameterMetaData(this.fbStatement.getParameterDescriptor(), this.connection);
            return fBParameterMetaData;
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkValidity();
        try (LockCloseable ignored = this.withLock();){
            this.procedureCall.checkParameters();
            this.batchList.add((FBProcedureCall)this.procedureCall.clone());
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkValidity();
        try (LockCloseable ignored = this.withLock();){
            this.batchList.clear();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected List<Long> executeBatchInternal() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void executeSingleForBatch(List<Long> results) throws SQLException {
        if (this.internalExecute(!this.isSelectableProcedure())) {
            throw new SQLException("Statements executed as batch should not produce a result set", "07003");
        }
        results.add(this.getLargeUpdateCountMinZero());
    }

    @Override
    public void setSelectableProcedure(boolean selectableProcedure) {
        this.selectableProcedure = selectableProcedure;
    }

    @Override
    public boolean isSelectableProcedure() {
        return this.selectableProcedure;
    }

    protected void setRequiredTypes() throws SQLException {
        this.setRequiredTypesInternal((FBResultSet)(this.singletonRs != null ? this.singletonRs : this.getResultSet()));
    }

    private void setRequiredTypesInternal(FBResultSet resultSet) throws SQLException {
        for (FBProcedureParam param : this.procedureCall.getOutputParams()) {
            if (param == null) continue;
            FBField field = resultSet.getField(this.procedureCall.mapOutParamIndexToPosition(param.getIndex()), false);
            field.setRequiredType(param.getType());
        }
    }

    @Override
    protected void prepareFixedStatement(String sql) throws SQLException {
        if (this.fbStatement != null) {
            return;
        }
        super.prepareFixedStatement(sql);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkValidity();
        try (LockCloseable ignored = this.withLock();){
            this.notifyStatementStarted(false);
            this.prepareFixedStatement(this.procedureCall.getSQL(this.isSelectableProcedure()));
        }
        return super.getMetaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        this.procedureCall.checkParameters();
        boolean hasResultSet = false;
        try (LockCloseable ignored = this.withLock();){
            this.notifyStatementStarted();
            try {
                this.prepareFixedStatement(this.procedureCall.getSQL(this.isSelectableProcedure()));
                hasResultSet = this.internalExecute(!this.isSelectableProcedure());
                if (hasResultSet) {
                    this.setRequiredTypes();
                }
            }
            finally {
                if (!hasResultSet) {
                    this.notifyStatementCompleted();
                }
            }
            boolean bl = hasResultSet;
            return bl;
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.procedureCall.checkParameters();
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            this.notifyStatementStarted();
            this.prepareFixedStatement(this.procedureCall.getSQL(this.isSelectableProcedure()));
            if (!this.internalExecute(!this.isSelectableProcedure())) {
                throw new FBSQLException("No resultset for sql", "07005");
            }
            ResultSet rs = this.getResultSet();
            this.setRequiredTypesInternal((FBResultSet)rs);
            ResultSet resultSet = rs;
            return resultSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        this.procedureCall.checkParameters();
        Throwable throwable = null;
        try (LockCloseable ignored = this.withLock();){
            int n;
            try {
                this.notifyStatementStarted();
                this.prepareFixedStatement(this.procedureCall.getSQL(this.isSelectableProcedure()));
                boolean hasResults = this.internalExecute(!this.isSelectableProcedure());
                if (hasResults) {
                    this.setRequiredTypes();
                }
                n = this.getUpdateCountMinZero();
            }
            catch (Throwable throwable2) {
                try {
                    this.notifyStatementCompleted();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            this.notifyStatementCompleted();
            return n;
        }
    }

    @Override
    protected boolean internalExecute(boolean sendOutParams) throws SQLException {
        this.singletonRs = null;
        int counter = 0;
        for (FBProcedureParam param : this.procedureCall.getInputParams()) {
            if (param == null || !param.isParam()) continue;
            Object value = param.getValue();
            FBField field = this.getField(++counter);
            if (value == null) {
                field.setNull();
                continue;
            }
            if (value instanceof WrapperWithCalendar) {
                this.setField(field, (WrapperWithCalendar)value);
                continue;
            }
            if (value instanceof WrapperWithLong) {
                this.setField(field, (WrapperWithLong)value);
                continue;
            }
            field.setObject(value);
        }
        boolean hasResultSet = super.internalExecute(sendOutParams);
        if (hasResultSet && this.isSingletonResult) {
            this.singletonRs = new FBResultSet(this.fbStatement.getRowDescriptor(), this.connection, new ArrayList<RowValue>(this.specialResult), null, true, false);
        }
        return hasResultSet;
    }

    @Override
    protected FBResultSet createSpecialResultSet(FBObjectListener.ResultSetListener resultSetListener) throws SQLException {
        return new FBResultSet(this.fbStatement.getRowDescriptor(), this.connection, new ArrayList<RowValue>(this.specialResult), resultSetListener, false, false);
    }

    private void setField(FBField field, WrapperWithLong value) throws SQLException {
        Object obj = value.getValue();
        if (obj == null) {
            field.setNull();
        } else {
            long longValue = value.getLongValue();
            if (obj instanceof InputStream) {
                field.setBinaryStream((InputStream)obj, longValue);
            } else if (obj instanceof Reader) {
                field.setCharacterStream((Reader)obj, longValue);
            } else {
                throw new TypeConversionException("Cannot convert type " + obj.getClass().getName());
            }
        }
    }

    private void setField(FBField field, WrapperWithCalendar value) throws SQLException {
        Object obj = value.getValue();
        if (obj == null) {
            field.setNull();
        } else {
            Calendar cal = value.getCalendar();
            if (obj instanceof Timestamp) {
                field.setTimestamp((Timestamp)obj, cal);
            } else if (obj instanceof Date) {
                field.setDate((Date)obj, cal);
            } else if (obj instanceof Time) {
                field.setTime((Time)obj, cal);
            } else {
                throw new TypeConversionException("Cannot convert type " + obj.getClass().getName());
            }
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.procedureCall.registerOutParam(parameterIndex, sqlType);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType) throws SQLException {
        this.registerOutParameter(parameterIndex, (int)sqlType.getVendorTypeNumber());
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, (int)sqlType.getVendorTypeNumber(), scale);
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterIndex, (int)sqlType.getVendorTypeNumber(), typeName);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.getAndAssertSingletonResultSet().wasNull();
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getString(parameterIndex);
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getBoolean(parameterIndex);
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getByte(parameterIndex);
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getShort(parameterIndex);
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getInt(parameterIndex);
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getLong(parameterIndex);
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getFloat(parameterIndex);
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getDouble(parameterIndex);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getBigDecimal(parameterIndex, scale);
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getBytes(parameterIndex);
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getDate(parameterIndex);
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getTime(parameterIndex);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getTimestamp(parameterIndex);
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getObject(parameterIndex);
    }

    @Override
    public Object getObject(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getObject(colName);
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getObject(parameterIndex, map);
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        return this.getAndAssertSingletonResultSet().getObject(colName, map);
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getObject(parameterIndex, type);
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        return this.getAndAssertSingletonResultSet().getObject(parameterName, type);
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getBigDecimal(parameterIndex);
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getRef(parameterIndex);
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getBlob(parameterIndex);
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getClob(parameterIndex);
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getArray(parameterIndex);
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getDate(parameterIndex, cal);
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getTime(parameterIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getTimestamp(parameterIndex, cal);
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getURL(parameterIndex);
    }

    @Override
    public String getString(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getString(colName);
    }

    @Override
    public boolean getBoolean(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getBoolean(colName);
    }

    @Override
    public byte getByte(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getByte(colName);
    }

    @Override
    public short getShort(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getShort(colName);
    }

    @Override
    public int getInt(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getInt(colName);
    }

    @Override
    public long getLong(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getLong(colName);
    }

    @Override
    public float getFloat(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getFloat(colName);
    }

    @Override
    public double getDouble(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getDouble(colName);
    }

    @Override
    public byte[] getBytes(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getBytes(colName);
    }

    @Override
    public Date getDate(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getDate(colName);
    }

    @Override
    public Time getTime(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getTime(colName);
    }

    @Override
    public Timestamp getTimestamp(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getTimestamp(colName);
    }

    @Override
    public BigDecimal getBigDecimal(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getBigDecimal(colName);
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getRef(colName);
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getBlob(colName);
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getClob(colName);
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getArray(colName);
    }

    @Override
    public Date getDate(String colName, Calendar cal) throws SQLException {
        return this.getAndAssertSingletonResultSet().getDate(colName, cal);
    }

    @Override
    public Time getTime(String colName, Calendar cal) throws SQLException {
        return this.getAndAssertSingletonResultSet().getTime(colName, cal);
    }

    @Override
    public Timestamp getTimestamp(String colName, Calendar cal) throws SQLException {
        return this.getAndAssertSingletonResultSet().getTimestamp(colName, cal);
    }

    @Override
    public URL getURL(String colName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getURL(colName);
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getCharacterStream(parameterIndex);
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getCharacterStream(parameterName);
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getNCharacterStream(parameterIndex);
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getNCharacterStream(parameterName);
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getNString(parameterIndex);
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getNString(parameterName);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.setCharacterStream(parameterName, value, length);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        this.setCharacterStream(parameterName, value);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setClob(parameterName, reader, length);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        this.setClob(parameterName, reader);
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        this.setString(parameterName, value);
    }

    @Override
    public void registerOutParameter(String param1, int param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void registerOutParameter(String param1, int param2, int param3) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void registerOutParameter(String param1, int param2, String param3) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType) throws SQLException {
        this.registerOutParameter(parameterName, (int)sqlType.getVendorTypeNumber());
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterName, (int)sqlType.getVendorTypeNumber(), scale);
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterName, (int)sqlType.getVendorTypeNumber(), typeName);
    }

    @Override
    public void setURL(String param1, URL param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setNull(String param1, int param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setBoolean(String param1, boolean param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setByte(String param1, byte param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setShort(String param1, short param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setInt(String param1, int param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setLong(String param1, long param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setFloat(String param1, float param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setDouble(String param1, double param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setBigDecimal(String param1, BigDecimal param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setString(String param1, String param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setBytes(String param1, byte[] param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setDate(String param1, Date param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setTime(String param1, Time param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setTimestamp(String param1, Timestamp param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setAsciiStream(String param1, InputStream param2, int param3) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setBinaryStream(String param1, InputStream param2, int param3) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setObject(String param1, Object param2, int param3, int param4) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setObject(String param1, Object param2, int param3) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setObject(String param1, Object param2) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setCharacterStream(String param1, Reader param2, int param3) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setDate(String param1, Date param2, Calendar param3) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setTime(String param1, Time param2, Calendar param3) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setTimestamp(String param1, Timestamp param2, Calendar param3) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setNull(String param1, int param2, String param3) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new FBDriverNotCapableException("getGeneratedKeys is not supported on CallableStatement");
    }

    protected void assertHasData(ResultSet rs) throws SQLException {
        if (rs == null) {
            throw new SQLException("Current statement has no data to return.", "07005");
        }
        if (rs.getRow() != 0) {
            return;
        }
        rs.next();
        if (rs.getRow() == 0) {
            throw new SQLException("Current statement has no data to return.", "07005");
        }
    }

    protected ResultSet getAndAssertSingletonResultSet() throws SQLException {
        ResultSet rs = !this.isSelectableProcedure() && this.singletonRs != null ? this.singletonRs : this.getResultSet();
        this.assertHasData(rs);
        return rs;
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new WrapperWithLong(inputStream, length));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new WrapperWithLong(inputStream, length));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(inputStream);
    }

    @Override
    public void setBlob(int parameterIndex, Blob blob) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(blob);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new WrapperWithLong(inputStream, length));
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(inputStream);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new WrapperWithLong(reader, length));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new WrapperWithLong(reader, length));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(reader);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new WrapperWithLong(reader, length));
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(reader);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new WrapperWithCalendar(x, cal));
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(Float.valueOf(x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(null);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(null);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new WrapperWithCalendar(x, cal));
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(new WrapperWithCalendar(x, cal));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.procedureCall.getInputParam(parameterIndex).setValue(x);
    }

    private void setSelectabilityAutomatically(StoredProcedureMetaData storedProcMetaData) throws SQLException {
        this.selectableProcedure = storedProcMetaData.isSelectable(this.procedureCall.getName());
    }

    @Deprecated
    protected int findOutParameter(String paramName) throws SQLException {
        return this.getAndAssertSingletonResultSet().findColumn(paramName);
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getNClob(parameterIndex);
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getNClob(parameterName);
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getRowId(parameterIndex);
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getRowId(parameterName);
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        parameterIndex = this.procedureCall.mapOutParamIndexToPosition(parameterIndex);
        return this.getAndAssertSingletonResultSet().getSQLXML(parameterIndex);
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        return this.getAndAssertSingletonResultSet().getSQLXML(parameterName);
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        this.setClob(parameterName, (Clob)value);
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw new FBDriverNotCapableException(SET_BY_STRING_NOT_SUPPORTED);
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw new FBDriverNotCapableException("Type SQLXML not supported");
    }

    private static class WrapperWithLong {
        private final Object value;
        private final long longValue;

        private WrapperWithLong(Object value, long longValue) {
            this.value = value;
            this.longValue = longValue;
        }

        private Object getValue() {
            return this.value;
        }

        private long getLongValue() {
            return this.longValue;
        }
    }

    private static class WrapperWithCalendar {
        private final Object value;
        private final Calendar c;

        private WrapperWithCalendar(Object value, Calendar c) {
            this.value = value;
            this.c = c;
        }

        private Object getValue() {
            return this.value;
        }

        private Calendar getCalendar() {
            return this.c;
        }
    }
}

