/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLException;
import java.sql.SQLWarning;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.ng.BlobLengthProcessor;
import org.firebirdsql.gds.ng.FbBlob;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.InfoProcessor;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.TransactionHelper;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.gds.ng.listeners.DatabaseListener;
import org.firebirdsql.gds.ng.listeners.ExceptionListener;
import org.firebirdsql.gds.ng.listeners.ExceptionListenerDispatcher;
import org.firebirdsql.gds.ng.listeners.TransactionListener;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public abstract class AbstractFbBlob
implements FbBlob,
TransactionListener,
DatabaseListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractFbBlob.class);
    protected final ExceptionListenerDispatcher exceptionListenerDispatcher = new ExceptionListenerDispatcher(this);
    private final BlobParameterBuffer blobParameterBuffer;
    private FbTransaction transaction;
    private FbDatabase database;
    private boolean open;
    private boolean eof;

    protected AbstractFbBlob(FbDatabase database, FbTransaction transaction, BlobParameterBuffer blobParameterBuffer) {
        this.database = database;
        this.transaction = transaction;
        this.blobParameterBuffer = blobParameterBuffer;
        transaction.addWeakTransactionListener(this);
    }

    @Override
    public final boolean isOpen() {
        try (LockCloseable ignored = this.withLock();){
            boolean bl = this.open;
            return bl;
        }
    }

    @Override
    public final boolean isEof() {
        try (LockCloseable ignored = this.withLock();){
            boolean bl = this.eof || !this.open;
            return bl;
        }
    }

    protected final void setEof() {
        if (this.isOutput()) {
            return;
        }
        try (LockCloseable ignored = this.withLock();){
            this.eof = true;
        }
    }

    protected final void resetEof() {
        try (LockCloseable ignored = this.withLock();){
            this.eof = false;
        }
    }

    protected final void setOpen(boolean open) {
        try (LockCloseable ignored = this.withLock();){
            FbDatabase database = this.database;
            if (open) {
                database.addWeakDatabaseListener(this);
            } else {
                database.removeDatabaseListener(this);
                FbTransaction transaction = this.transaction;
                if (transaction != null) {
                    transaction.removeTransactionListener(this);
                }
            }
            this.open = open;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (!this.open) {
                return;
            }
            try {
                if (this.isEndingTransaction()) {
                    this.releaseResources();
                } else {
                    this.checkDatabaseAttached();
                    this.checkTransactionActive();
                    this.closeImpl();
                }
            }
            finally {
                this.setOpen(false);
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
        finally {
            this.exceptionListenerDispatcher.shutdown();
        }
    }

    protected abstract void closeImpl() throws SQLException;

    @Override
    public final void cancel() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            try {
                if (this.isEndingTransaction()) {
                    this.releaseResources();
                } else {
                    this.checkDatabaseAttached();
                    this.checkTransactionActive();
                    this.cancelImpl();
                }
            }
            finally {
                this.setOpen(false);
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    protected abstract void cancelImpl() throws SQLException;

    protected abstract void releaseResources();

    protected final LockCloseable withLock() {
        FbDatabase database = this.database;
        if (database != null) {
            return database.withLock();
        }
        return LockCloseable.NO_OP;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void transactionStateChanged(FbTransaction transaction, TransactionState newState, TransactionState previousState) {
        if (this.getTransaction() != transaction) {
            transaction.removeTransactionListener(this);
            return;
        }
        switch (1.$SwitchMap$org$firebirdsql$gds$ng$TransactionState[newState.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                try {
                    this.close();
                }
                catch (SQLException e) {
                    AbstractFbBlob.log.error("Exception while closing blob during transaction end", e);
                }
                break;
            }
            case 4: 
            case 5: {
                ignored = this.withLock();
                var5_6 = null;
                this.clearTransaction();
                this.setOpen(false);
                this.releaseResources();
                if (ignored == null) break;
                if (var5_6 == null) ** GOTO lbl27
                try {
                    ignored.close();
                }
                catch (Throwable var6_7) {
                    var5_6.addSuppressed(var6_7);
                }
                break;
lbl27:
                // 1 sources

                ignored.close();
                break;
                catch (Throwable var6_8) {
                    try {
                        var5_6 = var6_8;
                        throw var6_8;
                    }
                    catch (Throwable var7_9) {
                        if (ignored != null) {
                            if (var5_6 != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable var8_10) {
                                    var5_6.addSuppressed(var8_10);
                                }
                            } else {
                                ignored.close();
                            }
                        }
                        throw var7_9;
                    }
                }
            }
        }
    }

    @Override
    public void detaching(FbDatabase database) {
        if (this.database != database) {
            database.removeDatabaseListener(this);
            return;
        }
        try (LockCloseable ignored = this.withLock();){
            if (this.open) {
                log.debugf("blob with blobId %d still open on database detach", (Object)this.getBlobId());
                try {
                    this.close();
                }
                catch (SQLException e) {
                    log.error("Blob close in detaching event failed", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detached(FbDatabase database) {
        try (LockCloseable ignored = this.withLock();){
            if (this.database == database) {
                this.open = false;
                this.clearDatabase();
                this.clearTransaction();
                this.releaseResources();
            }
        }
        finally {
            database.removeDatabaseListener(this);
        }
    }

    @Override
    public void warningReceived(FbDatabase database, SQLWarning warning) {
    }

    protected final boolean isEndingTransaction() {
        FbTransaction transaction = this.getTransaction();
        if (transaction != null) {
            TransactionState transactionState = transaction.getState();
            return transactionState == TransactionState.COMMITTING || transactionState == TransactionState.ROLLING_BACK || transactionState == TransactionState.PREPARING;
        }
        return false;
    }

    protected final void checkTransactionActive() throws SQLException {
        TransactionHelper.checkTransactionActive(this.getTransaction(), 335544370);
    }

    protected void checkDatabaseAttached() throws SQLException {
        FbDatabase database = this.database;
        if (database == null || !database.isAttached()) {
            throw new FbExceptionBuilder().nonTransientException(335544372).toSQLException();
        }
    }

    protected void checkBlobOpen() throws SQLException {
        if (!this.isOpen()) {
            throw new FbExceptionBuilder().nonTransientException(335544328).toSQLException();
        }
    }

    protected void checkBlobClosed() throws SQLException {
        if (this.isOpen()) {
            throw new FbExceptionBuilder().nonTransientException(335544355).toSQLException();
        }
    }

    protected FbTransaction getTransaction() {
        try (LockCloseable ignored = this.withLock();){
            FbTransaction fbTransaction = this.transaction;
            return fbTransaction;
        }
    }

    protected final void clearTransaction() {
        FbTransaction transaction;
        try (LockCloseable ignored = this.withLock();){
            transaction = this.transaction;
            this.transaction = null;
        }
        if (transaction != null) {
            transaction.removeTransactionListener(this);
        }
    }

    @Override
    public FbDatabase getDatabase() {
        try (LockCloseable ignored = this.withLock();){
            FbDatabase fbDatabase = this.database;
            return fbDatabase;
        }
    }

    @Override
    public <T> T getBlobInfo(byte[] requestItems, int bufferLength, InfoProcessor<T> infoProcessor) throws SQLException {
        byte[] blobInfo = this.getBlobInfo(requestItems, bufferLength);
        try {
            return infoProcessor.process(blobInfo);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long length() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkDatabaseAttached();
            if (this.isOutput() && this.getBlobId() == 0L) {
                throw FbExceptionBuilder.forException(335544329).toSQLException();
            }
            BlobLengthProcessor blobLengthProcessor = this.createBlobLengthProcessor();
            long l = this.getBlobInfo(blobLengthProcessor.getBlobLengthItems(), 20, blobLengthProcessor);
            return l;
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public final void addExceptionListener(ExceptionListener listener) {
        this.exceptionListenerDispatcher.addListener(listener);
    }

    @Override
    public final void removeExceptionListener(ExceptionListener listener) {
        this.exceptionListenerDispatcher.removeListener(listener);
    }

    protected final void clearDatabase() {
        FbDatabase database;
        try (LockCloseable ignored = this.withLock();){
            database = this.database;
            this.database = null;
        }
        if (database != null) {
            database.removeDatabaseListener(this);
        }
    }

    protected BlobParameterBuffer getBlobParameterBuffer() {
        return this.blobParameterBuffer;
    }

    protected BlobLengthProcessor createBlobLengthProcessor() {
        return new BlobLengthProcessor();
    }

    @Override
    public int getMaximumSegmentSize() {
        return 32765;
    }
}

