/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.traversal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Routine;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.tools.traversal.SchemaTraversalHandler;
import schemacrawler.utility.NamedObjectSort;

public class SchemaTraverser {
    private Catalog catalog;
    private SchemaTraversalHandler handler;
    private Comparator<NamedObject> tablesComparator = NamedObjectSort.natural;
    private Comparator<NamedObject> routinesComparator = NamedObjectSort.natural;

    public Catalog getCatalog() {
        return this.catalog;
    }

    public SchemaTraversalHandler getHandler() {
        return this.handler;
    }

    public Comparator<NamedObject> getRoutinesComparator() {
        return this.routinesComparator;
    }

    public Comparator<NamedObject> getTablesComparator() {
        return this.tablesComparator;
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = Objects.requireNonNull(catalog, "No catalog provided");
    }

    public void setHandler(SchemaTraversalHandler handler) {
        this.handler = Objects.requireNonNull(handler, "No handler provided");
    }

    public void setRoutinesComparator(Comparator<NamedObject> routinesComparator) {
        this.routinesComparator = Objects.requireNonNull(routinesComparator, "No routines comparator provided");
    }

    public void setTablesComparator(Comparator<NamedObject> tablesComparator) {
        this.tablesComparator = Objects.requireNonNull(tablesComparator, "No tables comparator provided");
    }

    public final void traverse() {
        Collection<ColumnDataType> columnDataTypes = this.catalog.getColumnDataTypes();
        Collection<Table> tables = this.catalog.getTables();
        Collection<Routine> routines = this.catalog.getRoutines();
        Collection<Synonym> synonyms = this.catalog.getSynonyms();
        Collection<Sequence> sequences = this.catalog.getSequences();
        this.handler.begin();
        this.handler.handleHeaderStart();
        this.handler.handle(this.catalog.getCrawlInfo());
        this.handler.handleHeaderEnd();
        if (!tables.isEmpty()) {
            this.handler.handleTablesStart();
            ArrayList<Table> tablesList = new ArrayList<Table>(tables);
            tablesList.sort(this.tablesComparator);
            for (Table table : tablesList) {
                this.handler.handle(table);
            }
            this.handler.handleTablesEnd();
        }
        if (!routines.isEmpty()) {
            this.handler.handleRoutinesStart();
            ArrayList<Routine> routinesList = new ArrayList<Routine>(routines);
            routinesList.sort(this.routinesComparator);
            for (Routine routine : routinesList) {
                this.handler.handle(routine);
            }
            this.handler.handleRoutinesEnd();
        }
        if (!sequences.isEmpty()) {
            this.handler.handleSequencesStart();
            for (Sequence sequence : sequences) {
                this.handler.handle(sequence);
            }
            this.handler.handleSequencesEnd();
        }
        if (!synonyms.isEmpty()) {
            this.handler.handleSynonymsStart();
            for (Synonym synonym : synonyms) {
                this.handler.handle(synonym);
            }
            this.handler.handleSynonymsEnd();
        }
        if (!columnDataTypes.isEmpty()) {
            this.handler.handleColumnDataTypesStart();
            for (ColumnDataType columnDataType : columnDataTypes) {
                this.handler.handle(columnDataType);
            }
            this.handler.handleColumnDataTypesEnd();
        }
        this.handler.handleInfoStart();
        this.handler.handle(this.catalog.getDatabaseInfo());
        this.handler.handle(this.catalog.getJdbcDriverInfo());
        this.handler.handleInfoEnd();
        this.handler.end();
    }
}

