/*
 * Decompiled with CFR 0.152.
 */
package com.theokanning.openai.completion.chat;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.theokanning.openai.completion.chat.ChatMessage;
import java.util.List;
import java.util.Map;

public class ChatCompletionRequest {
    String model;
    List<ChatMessage> messages;
    Double temperature;
    @JsonProperty(value="top_p")
    Double topP;
    Integer n;
    Boolean stream;
    List<String> stop;
    @JsonProperty(value="max_tokens")
    Integer maxTokens;
    @JsonProperty(value="presence_penalty")
    Double presencePenalty;
    @JsonProperty(value="frequency_penalty")
    Double frequencyPenalty;
    @JsonProperty(value="logit_bias")
    Map<String, Integer> logitBias;
    String user;
    List<?> functions;
    @JsonProperty(value="function_call")
    ChatCompletionRequestFunctionCall functionCall;

    public static ChatCompletionRequestBuilder builder() {
        return new ChatCompletionRequestBuilder();
    }

    public String getModel() {
        return this.model;
    }

    public List<ChatMessage> getMessages() {
        return this.messages;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Integer getN() {
        return this.n;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Map<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    public String getUser() {
        return this.user;
    }

    public List<?> getFunctions() {
        return this.functions;
    }

    public ChatCompletionRequestFunctionCall getFunctionCall() {
        return this.functionCall;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setMessages(List<ChatMessage> messages) {
        this.messages = messages;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    @JsonProperty(value="top_p")
    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public void setStream(Boolean stream) {
        this.stream = stream;
    }

    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    @JsonProperty(value="max_tokens")
    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    @JsonProperty(value="presence_penalty")
    public void setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    @JsonProperty(value="frequency_penalty")
    public void setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    @JsonProperty(value="logit_bias")
    public void setLogitBias(Map<String, Integer> logitBias) {
        this.logitBias = logitBias;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setFunctions(List<?> functions) {
        this.functions = functions;
    }

    @JsonProperty(value="function_call")
    public void setFunctionCall(ChatCompletionRequestFunctionCall functionCall) {
        this.functionCall = functionCall;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatCompletionRequest)) {
            return false;
        }
        ChatCompletionRequest other = (ChatCompletionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$temperature = this.getTemperature();
        Double other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Double this$topP = this.getTopP();
        Double other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Integer this$n = this.getN();
        Integer other$n = other.getN();
        if (this$n == null ? other$n != null : !((Object)this$n).equals(other$n)) {
            return false;
        }
        Boolean this$stream = this.getStream();
        Boolean other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !((Object)this$stream).equals(other$stream)) {
            return false;
        }
        Integer this$maxTokens = this.getMaxTokens();
        Integer other$maxTokens = other.getMaxTokens();
        if (this$maxTokens == null ? other$maxTokens != null : !((Object)this$maxTokens).equals(other$maxTokens)) {
            return false;
        }
        Double this$presencePenalty = this.getPresencePenalty();
        Double other$presencePenalty = other.getPresencePenalty();
        if (this$presencePenalty == null ? other$presencePenalty != null : !((Object)this$presencePenalty).equals(other$presencePenalty)) {
            return false;
        }
        Double this$frequencyPenalty = this.getFrequencyPenalty();
        Double other$frequencyPenalty = other.getFrequencyPenalty();
        if (this$frequencyPenalty == null ? other$frequencyPenalty != null : !((Object)this$frequencyPenalty).equals(other$frequencyPenalty)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<ChatMessage> this$messages = this.getMessages();
        List<ChatMessage> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        List<String> this$stop = this.getStop();
        List<String> other$stop = other.getStop();
        if (this$stop == null ? other$stop != null : !((Object)this$stop).equals(other$stop)) {
            return false;
        }
        Map<String, Integer> this$logitBias = this.getLogitBias();
        Map<String, Integer> other$logitBias = other.getLogitBias();
        if (this$logitBias == null ? other$logitBias != null : !((Object)this$logitBias).equals(other$logitBias)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        List<?> this$functions = this.getFunctions();
        List<?> other$functions = other.getFunctions();
        if (this$functions == null ? other$functions != null : !((Object)this$functions).equals(other$functions)) {
            return false;
        }
        ChatCompletionRequestFunctionCall this$functionCall = this.getFunctionCall();
        ChatCompletionRequestFunctionCall other$functionCall = other.getFunctionCall();
        return !(this$functionCall == null ? other$functionCall != null : !((Object)this$functionCall).equals(other$functionCall));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatCompletionRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Double $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Integer $n = this.getN();
        result = result * 59 + ($n == null ? 43 : ((Object)$n).hashCode());
        Boolean $stream = this.getStream();
        result = result * 59 + ($stream == null ? 43 : ((Object)$stream).hashCode());
        Integer $maxTokens = this.getMaxTokens();
        result = result * 59 + ($maxTokens == null ? 43 : ((Object)$maxTokens).hashCode());
        Double $presencePenalty = this.getPresencePenalty();
        result = result * 59 + ($presencePenalty == null ? 43 : ((Object)$presencePenalty).hashCode());
        Double $frequencyPenalty = this.getFrequencyPenalty();
        result = result * 59 + ($frequencyPenalty == null ? 43 : ((Object)$frequencyPenalty).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<ChatMessage> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        List<String> $stop = this.getStop();
        result = result * 59 + ($stop == null ? 43 : ((Object)$stop).hashCode());
        Map<String, Integer> $logitBias = this.getLogitBias();
        result = result * 59 + ($logitBias == null ? 43 : ((Object)$logitBias).hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        List<?> $functions = this.getFunctions();
        result = result * 59 + ($functions == null ? 43 : ((Object)$functions).hashCode());
        ChatCompletionRequestFunctionCall $functionCall = this.getFunctionCall();
        result = result * 59 + ($functionCall == null ? 43 : ((Object)$functionCall).hashCode());
        return result;
    }

    public String toString() {
        return "ChatCompletionRequest(model=" + this.getModel() + ", messages=" + this.getMessages() + ", temperature=" + this.getTemperature() + ", topP=" + this.getTopP() + ", n=" + this.getN() + ", stream=" + this.getStream() + ", stop=" + this.getStop() + ", maxTokens=" + this.getMaxTokens() + ", presencePenalty=" + this.getPresencePenalty() + ", frequencyPenalty=" + this.getFrequencyPenalty() + ", logitBias=" + this.getLogitBias() + ", user=" + this.getUser() + ", functions=" + this.getFunctions() + ", functionCall=" + this.getFunctionCall() + ")";
    }

    public ChatCompletionRequest(String model, List<ChatMessage> messages, Double temperature, Double topP, Integer n, Boolean stream, List<String> stop, Integer maxTokens, Double presencePenalty, Double frequencyPenalty, Map<String, Integer> logitBias, String user, List<?> functions, ChatCompletionRequestFunctionCall functionCall) {
        this.model = model;
        this.messages = messages;
        this.temperature = temperature;
        this.topP = topP;
        this.n = n;
        this.stream = stream;
        this.stop = stop;
        this.maxTokens = maxTokens;
        this.presencePenalty = presencePenalty;
        this.frequencyPenalty = frequencyPenalty;
        this.logitBias = logitBias;
        this.user = user;
        this.functions = functions;
        this.functionCall = functionCall;
    }

    public ChatCompletionRequest() {
    }

    public static class ChatCompletionRequestBuilder {
        private String model;
        private List<ChatMessage> messages;
        private Double temperature;
        private Double topP;
        private Integer n;
        private Boolean stream;
        private List<String> stop;
        private Integer maxTokens;
        private Double presencePenalty;
        private Double frequencyPenalty;
        private Map<String, Integer> logitBias;
        private String user;
        private List<?> functions;
        private ChatCompletionRequestFunctionCall functionCall;

        ChatCompletionRequestBuilder() {
        }

        public ChatCompletionRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public ChatCompletionRequestBuilder messages(List<ChatMessage> messages) {
            this.messages = messages;
            return this;
        }

        public ChatCompletionRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        @JsonProperty(value="top_p")
        public ChatCompletionRequestBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public ChatCompletionRequestBuilder n(Integer n) {
            this.n = n;
            return this;
        }

        public ChatCompletionRequestBuilder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        public ChatCompletionRequestBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        @JsonProperty(value="max_tokens")
        public ChatCompletionRequestBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        @JsonProperty(value="presence_penalty")
        public ChatCompletionRequestBuilder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        @JsonProperty(value="frequency_penalty")
        public ChatCompletionRequestBuilder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        @JsonProperty(value="logit_bias")
        public ChatCompletionRequestBuilder logitBias(Map<String, Integer> logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public ChatCompletionRequestBuilder user(String user) {
            this.user = user;
            return this;
        }

        public ChatCompletionRequestBuilder functions(List<?> functions) {
            this.functions = functions;
            return this;
        }

        @JsonProperty(value="function_call")
        public ChatCompletionRequestBuilder functionCall(ChatCompletionRequestFunctionCall functionCall) {
            this.functionCall = functionCall;
            return this;
        }

        public ChatCompletionRequest build() {
            return new ChatCompletionRequest(this.model, this.messages, this.temperature, this.topP, this.n, this.stream, this.stop, this.maxTokens, this.presencePenalty, this.frequencyPenalty, this.logitBias, this.user, this.functions, this.functionCall);
        }

        public String toString() {
            return "ChatCompletionRequest.ChatCompletionRequestBuilder(model=" + this.model + ", messages=" + this.messages + ", temperature=" + this.temperature + ", topP=" + this.topP + ", n=" + this.n + ", stream=" + this.stream + ", stop=" + this.stop + ", maxTokens=" + this.maxTokens + ", presencePenalty=" + this.presencePenalty + ", frequencyPenalty=" + this.frequencyPenalty + ", logitBias=" + this.logitBias + ", user=" + this.user + ", functions=" + this.functions + ", functionCall=" + this.functionCall + ")";
        }
    }

    public static class ChatCompletionRequestFunctionCall {
        String name;

        public static ChatCompletionRequestFunctionCall of(String name) {
            return new ChatCompletionRequestFunctionCall(name);
        }

        public static ChatCompletionRequestFunctionCallBuilder builder() {
            return new ChatCompletionRequestFunctionCallBuilder();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChatCompletionRequestFunctionCall)) {
                return false;
            }
            ChatCompletionRequestFunctionCall other = (ChatCompletionRequestFunctionCall)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChatCompletionRequestFunctionCall;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "ChatCompletionRequest.ChatCompletionRequestFunctionCall(name=" + this.getName() + ")";
        }

        public ChatCompletionRequestFunctionCall(String name) {
            this.name = name;
        }

        public ChatCompletionRequestFunctionCall() {
        }

        public static class ChatCompletionRequestFunctionCallBuilder {
            private String name;

            ChatCompletionRequestFunctionCallBuilder() {
            }

            public ChatCompletionRequestFunctionCallBuilder name(String name) {
                this.name = name;
                return this;
            }

            public ChatCompletionRequestFunctionCall build() {
                return new ChatCompletionRequestFunctionCall(this.name);
            }

            public String toString() {
                return "ChatCompletionRequest.ChatCompletionRequestFunctionCall.ChatCompletionRequestFunctionCallBuilder(name=" + this.name + ")";
            }
        }
    }
}

