/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ReferenceObject;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Schema;
import org.hsqldb.SchemaObject;
import org.hsqldb.SchemaObjectSet;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Table;
import org.hsqldb.TableUtil;
import org.hsqldb.TableWorks;
import org.hsqldb.TriggerDef;
import org.hsqldb.TypeInvariants;
import org.hsqldb.error.Error;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.FilteredIterator;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.List;
import org.hsqldb.lib.MultiValueHashMap;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.map.BaseHashMap;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;

public class SchemaManager {
    Database database;
    HsqlNameManager.HsqlName defaultSchemaHsqlName;
    int defaultTableType = 4;
    HsqlNameManager.HsqlName[] catalogNameArray;
    long schemaChangeTimestamp;
    Table dualTable;
    OrderedHashMap<String, Schema> schemaMap = new OrderedHashMap();
    MultiValueHashMap<HsqlNameManager.HsqlName, HsqlNameManager.HsqlName> referenceMap = new MultiValueHashMap();
    UserSchemaFilter userSchemaFilter = new UserSchemaFilter();
    ReadWriteLock lock = new ReentrantReadWriteLock();
    Lock readLock = this.lock.readLock();
    Lock writeLock = this.lock.writeLock();
    long[][] tempIndexRoots;

    public SchemaManager(Database database) {
        this.database = database;
        this.defaultSchemaHsqlName = SqlInvariants.INFORMATION_SCHEMA_HSQLNAME;
        this.catalogNameArray = new HsqlNameManager.HsqlName[]{database.getCatalogName()};
        Schema schema = new Schema(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, SqlInvariants.INFORMATION_SCHEMA_HSQLNAME.owner);
        this.schemaMap.put(schema.getName().name, schema);
        try {
            schema.charsetLookup.add(Charset.SQL_TEXT, false);
            schema.charsetLookup.add(Charset.SQL_IDENTIFIER_CHARSET, false);
            schema.charsetLookup.add(Charset.SQL_CHARACTER, false);
            schema.collationLookup.add(Collation.getDefaultInstance(), false);
            schema.collationLookup.add(Collation.getDefaultIgnoreCaseInstance(), false);
            schema.typeLookup.add(TypeInvariants.CARDINAL_NUMBER, false);
            schema.typeLookup.add(TypeInvariants.YES_OR_NO, false);
            schema.typeLookup.add(TypeInvariants.CHARACTER_DATA, false);
            schema.typeLookup.add(TypeInvariants.SQL_IDENTIFIER, false);
            schema.typeLookup.add(TypeInvariants.TIME_STAMP, false);
            schema.typeLookup.add(TypeInvariants.NCNAME, false);
            schema.typeLookup.add(TypeInvariants.URI, false);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    public void setSchemaChangeTimestamp() {
        this.schemaChangeTimestamp = this.database.txManager.getSystemChangeNumber();
    }

    public long getSchemaChangeTimestamp() {
        return this.schemaChangeTimestamp;
    }

    public HsqlNameManager.HsqlName getSQLJSchemaHsqlName() {
        return SqlInvariants.SQLJ_SCHEMA_HSQLNAME;
    }

    public void createPublicSchema() {
        this.writeLock.lock();
        try {
            HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(null, "PUBLIC", 2);
            Schema schema = new Schema(hsqlName, this.database.getGranteeManager().getDBARole());
            this.defaultSchemaHsqlName = schema.getName();
            this.schemaMap.put(schema.getName().name, schema);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(HsqlNameManager.HsqlName hsqlName, Grantee grantee) {
        this.writeLock.lock();
        try {
            SqlInvariants.checkSchemaNameNotSystem(hsqlName.name);
            Schema schema = new Schema(hsqlName, grantee);
            this.schemaMap.add(hsqlName.name, schema);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropSchema(Session session, String string, boolean bl) {
        this.writeLock.lock();
        try {
            Object object;
            Object object2;
            Schema schema = (Schema)this.schemaMap.get((Object)string);
            if (schema == null) {
                throw Error.error(5501, string);
            }
            if (SqlInvariants.isLobsSchemaName(string)) {
                throw Error.error(5503, string);
            }
            if (!bl && !schema.isEmpty()) {
                throw Error.error(4200);
            }
            OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
            this.getCascadingReferencesToSchema(schema.getName(), orderedHashSet);
            this.removeSchemaObjects(orderedHashSet);
            Iterator<SchemaObject> iterator = schema.schemaObjectIterator(3);
            while (iterator.hasNext()) {
                object2 = (Table)iterator.next();
                object = ((Table)object2).getFKConstraints();
                for (int i = 0; i < ((Constraint[])object).length; ++i) {
                    Constraint constraint = object[i];
                    if (constraint.getMain().getSchemaName() == schema.getName()) continue;
                    constraint.getMain().removeConstraint(constraint.getMainName().name);
                    this.removeReferencesFrom(constraint);
                }
                this.removeTable(session, (Table)object2);
            }
            object2 = schema.schemaObjectIterator(7);
            while (object2.hasNext()) {
                object = (NumberSequence)object2.next();
                this.database.getGranteeManager().removeDbObject(((NumberSequence)object).getName());
            }
            schema.release();
            this.schemaMap.remove(string);
            if (this.defaultSchemaHsqlName.name.equals(string)) {
                schema = new Schema(this.defaultSchemaHsqlName, this.database.getGranteeManager().getDBARole());
                this.defaultSchemaHsqlName = schema.getName();
                this.schemaMap.put(schema.getName().name, schema);
            } else {
                object = schema.getName();
                this.database.getUserManager().removeSchemaReference((HsqlNameManager.HsqlName)object);
                this.database.getSessionManager().removeSchemaReference((HsqlNameManager.HsqlName)object);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameSchema(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2) {
        this.writeLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get((Object)hsqlName.name);
            Schema schema2 = (Schema)this.schemaMap.get((Object)hsqlName2.name);
            if (schema == null) {
                throw Error.error(5501, hsqlName.name);
            }
            if (schema2 != null) {
                throw Error.error(5504, hsqlName2.name);
            }
            SqlInvariants.checkSchemaNameNotSystem(hsqlName.name);
            SqlInvariants.checkSchemaNameNotSystem(hsqlName2.name);
            int n = this.schemaMap.getIndex(hsqlName.name);
            schema.getName().rename(hsqlName2);
            this.schemaMap.set(n, hsqlName2.name, schema);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void release() {
        this.writeLock.lock();
        try {
            Iterator iterator = this.schemaMap.values().iterator();
            while (iterator.hasNext()) {
                Schema schema = (Schema)iterator.next();
                schema.release();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String[] getSchemaNamesArray() {
        this.readLock.lock();
        try {
            String[] stringArray = new String[this.schemaMap.size()];
            this.schemaMap.keysToArray(stringArray);
            String[] stringArray2 = stringArray;
            return stringArray2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Schema[] getAllSchemas() {
        this.readLock.lock();
        try {
            Schema[] schemaArray = new Schema[this.schemaMap.size()];
            this.schemaMap.valuesToArray(schemaArray);
            Schema[] schemaArray2 = schemaArray;
            return schemaArray2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Iterator<Schema> getUserSchemaIterator() {
        return new FilteredIterator<Schema>(this.schemaMap.values().iterator(), this.userSchemaFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlNameManager.HsqlName getUserSchemaHsqlName(String string) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get((Object)string);
            if (schema == null) {
                throw Error.error(4850, string);
            }
            if (schema.getName() == SqlInvariants.INFORMATION_SCHEMA_HSQLNAME) {
                throw Error.error(4850, string);
            }
            HsqlNameManager.HsqlName hsqlName = schema.getName();
            return hsqlName;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Grantee toSchemaOwner(String string) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get((Object)string);
            Grantee grantee = schema == null ? null : schema.getOwner();
            return grantee;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public HsqlNameManager.HsqlName getDefaultSchemaHsqlName() {
        return this.defaultSchemaHsqlName;
    }

    public void setDefaultSchemaHsqlName(HsqlNameManager.HsqlName hsqlName) {
        this.defaultSchemaHsqlName = hsqlName;
    }

    public boolean schemaExists(String string) {
        this.readLock.lock();
        try {
            boolean bl = this.schemaMap.containsKey(string);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlNameManager.HsqlName findSchemaHsqlName(String string) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get((Object)string);
            if (schema == null) {
                HsqlNameManager.HsqlName hsqlName = null;
                return hsqlName;
            }
            HsqlNameManager.HsqlName hsqlName = schema.getName();
            return hsqlName;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public HsqlNameManager.HsqlName getSchemaHsqlName(String string) {
        if (string == null) {
            return this.defaultSchemaHsqlName;
        }
        HsqlNameManager.HsqlName hsqlName = this.findSchemaHsqlName(string);
        if (hsqlName == null) {
            throw Error.error(4850, string);
        }
        return hsqlName;
    }

    public String getSchemaName(String string) {
        return this.getSchemaHsqlName((String)string).name;
    }

    public Schema findSchema(String string) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get((Object)string);
            return schema;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropSchemas(Session session, Grantee grantee, boolean bl) {
        this.writeLock.lock();
        try {
            HsqlArrayList<Schema> hsqlArrayList = this.getSchemas(grantee);
            Iterator iterator = hsqlArrayList.iterator();
            while (iterator.hasNext()) {
                Schema schema = (Schema)iterator.next();
                this.dropSchema(session, schema.getName().name, bl);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlArrayList<Schema> getSchemas(Grantee grantee) {
        this.readLock.lock();
        try {
            Object object;
            HsqlArrayList<Object> hsqlArrayList = new HsqlArrayList<Object>();
            Iterator iterator = this.schemaMap.values().iterator();
            while (iterator.hasNext()) {
                object = (Schema)iterator.next();
                if (!grantee.equals(((Schema)object).getOwner())) continue;
                hsqlArrayList.add(object);
            }
            object = hsqlArrayList;
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSchemas(Grantee grantee) {
        this.readLock.lock();
        try {
            Iterator iterator = this.schemaMap.values().iterator();
            while (iterator.hasNext()) {
                Schema schema = (Schema)iterator.next();
                if (!grantee.equals(schema.getOwner())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlArrayList<Table> getAllTables(boolean bl) {
        this.readLock.lock();
        try {
            HsqlArrayList<Table> hsqlArrayList = new HsqlArrayList<Table>();
            String[] stringArray = this.getSchemaNamesArray();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (!bl && SqlInvariants.isLobsSchemaName(string) || SqlInvariants.isSystemSchemaName(string)) continue;
                OrderedHashMap<String, Table> orderedHashMap = this.getTables(string);
                hsqlArrayList.addAll(orderedHashMap.values());
            }
            HsqlArrayList<Table> hsqlArrayList2 = hsqlArrayList;
            return hsqlArrayList2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderedHashMap<String, Table> getTables(String string) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get((Object)string);
            OrderedHashMap<String, Table> orderedHashMap = schema.tableList;
            return orderedHashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public HsqlNameManager.HsqlName[] getCatalogNameArray() {
        return this.catalogNameArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlNameManager.HsqlName[] getCatalogAndBaseTableNames() {
        this.readLock.lock();
        try {
            HsqlNameManager.HsqlName[] hsqlNameArray;
            OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
            HsqlArrayList<Table> hsqlArrayList = this.getAllTables(false);
            for (int i = 0; i < hsqlArrayList.size(); ++i) {
                hsqlNameArray = hsqlArrayList.get(i);
                if (hsqlNameArray.isTemp()) continue;
                orderedHashSet.add(hsqlNameArray.getName());
            }
            orderedHashSet.add(this.database.getCatalogName());
            HsqlNameManager.HsqlName[] hsqlNameArray2 = new HsqlNameManager.HsqlName[orderedHashSet.size()];
            orderedHashSet.toArray(hsqlNameArray2);
            hsqlNameArray = hsqlNameArray2;
            return hsqlNameArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlNameManager.HsqlName[] getCatalogAndBaseTableNames(HsqlNameManager.HsqlName hsqlName) {
        if (hsqlName == null) {
            return this.catalogNameArray;
        }
        this.readLock.lock();
        try {
            HsqlNameManager.HsqlName[] hsqlNameArray;
            SchemaObject schemaObject;
            switch (hsqlName.type) {
                case 2: {
                    if (this.findSchemaHsqlName(hsqlName.name) == null) {
                        HsqlNameManager.HsqlName[] hsqlNameArray2 = this.catalogNameArray;
                        return hsqlNameArray2;
                    }
                    OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
                    orderedHashSet.add(this.database.getCatalogName());
                    OrderedHashMap<String, Table> orderedHashMap = this.getTables(hsqlName.name);
                    for (int i = 0; i < orderedHashMap.size(); ++i) {
                        orderedHashSet.add(orderedHashMap.get(i).getName());
                    }
                    HsqlNameManager.HsqlName[] hsqlNameArray3 = new HsqlNameManager.HsqlName[orderedHashSet.size()];
                    orderedHashSet.toArray(hsqlNameArray3);
                    HsqlNameManager.HsqlName[] hsqlNameArray4 = hsqlNameArray3;
                    return hsqlNameArray4;
                }
                case 11: {
                    HsqlNameManager.HsqlName[] hsqlNameArray5 = this.catalogNameArray;
                    return hsqlNameArray5;
                }
            }
            SchemaObject schemaObject2 = this.findSchemaObject(hsqlName.name, hsqlName.schema.name, hsqlName.type);
            if (schemaObject2 == null) {
                HsqlNameManager.HsqlName[] hsqlNameArray6 = this.catalogNameArray;
                return hsqlNameArray6;
            }
            HsqlNameManager.HsqlName hsqlName2 = schemaObject2.getName().parent;
            OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = this.getReferencesTo(schemaObject2.getName());
            OrderedHashSet<Object> orderedHashSet2 = new OrderedHashSet<Object>();
            orderedHashSet2.add(this.database.getCatalogName());
            if (hsqlName2 != null && (schemaObject = this.findSchemaObject(hsqlName2.name, hsqlName2.schema.name, hsqlName2.type)) != null && schemaObject.getName().type == 3) {
                orderedHashSet2.add(schemaObject.getName());
            }
            if (schemaObject2.getName().type == 3) {
                orderedHashSet2.add(schemaObject2.getName());
            }
            for (int i = 0; i < orderedHashSet.size(); ++i) {
                Table table;
                hsqlNameArray = orderedHashSet.get(i);
                if (hsqlNameArray.type != 3 || (table = this.findUserTable(hsqlNameArray.name, hsqlNameArray.schema.name)) == null || table.isTemp()) continue;
                orderedHashSet2.add(hsqlNameArray);
            }
            HsqlNameManager.HsqlName[] hsqlNameArray7 = new HsqlNameManager.HsqlName[orderedHashSet2.size()];
            orderedHashSet2.toArray(hsqlNameArray7);
            hsqlNameArray = hsqlNameArray7;
            return hsqlNameArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void checkSchemaObjectNotExists(HsqlNameManager.HsqlName hsqlName) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get((Object)hsqlName.schema.name);
            schema.checkObjectNotExists(hsqlName);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Table getUserTable(HsqlNameManager.HsqlName hsqlName) {
        return this.getUserTable(hsqlName.name, hsqlName.schema.name);
    }

    public Table getUserTable(String string, String string2) {
        Table table = this.findUserTable(string, string2);
        if (table == null) {
            String string3 = string2 == null ? string : string2 + '.' + string;
            throw Error.error(5501, string3);
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table findUserTable(String string, String string2) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get((Object)string2);
            if (schema == null) {
                Table table = null;
                return table;
            }
            int n = schema.tableList.getIndex(string);
            if (n == -1) {
                Table table = null;
                return table;
            }
            Table table = schema.tableList.get(n);
            return table;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Table findSessionTable(Session session, String string) {
        return session.sessionContext.findSessionTable(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTableOrView(Session session, Table table, boolean bl) {
        this.writeLock.lock();
        try {
            if (table.isView()) {
                this.dropView(table, bl);
            } else {
                this.dropTable(session, table, bl);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void dropView(Table table, boolean bl) {
        Schema schema = (Schema)this.schemaMap.get((Object)table.getSchemaName().name);
        this.removeSchemaObject(table.getName(), bl);
        this.removeTableDependentReferences(table);
        schema.triggerLookup.removeParent(table.getName());
    }

    private void dropTable(Session session, Table table, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Schema schema = (Schema)this.schemaMap.get((Object)table.getSchemaName().name);
        OrderedHashSet<Constraint> orderedHashSet = table.getDependentExternalConstraints();
        OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet2 = new OrderedHashSet<HsqlNameManager.HsqlName>();
        this.getCascadingReferencesTo(table.getName(), orderedHashSet2);
        if (!bl) {
            int n;
            for (n = 0; n < orderedHashSet.size(); ++n) {
                object3 = orderedHashSet.get(n);
                object2 = ((Constraint)object3).getRefName();
                if (((Constraint)object3).getConstraintType() != 1) continue;
                throw Error.error(5533, ((HsqlNameManager.HsqlName)object2).getSchemaQualifiedStatementName());
            }
            if (!orderedHashSet2.isEmpty()) {
                for (n = 0; n < orderedHashSet2.size(); ++n) {
                    object3 = orderedHashSet2.get(n);
                    if (((HsqlNameManager.HsqlName)object3).parent == table.getName()) continue;
                    throw Error.error(5502, ((HsqlNameManager.HsqlName)object3).getSchemaQualifiedStatementName());
                }
            }
        }
        OrderedHashSet<Table> orderedHashSet3 = new OrderedHashSet<Table>();
        object3 = new OrderedHashSet();
        object2 = new OrderedHashSet();
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            object = orderedHashSet.get(i);
            Table table2 = ((Constraint)object).getMain();
            if (table2 != table) {
                orderedHashSet3.add(table2);
            }
            if ((table2 = ((Constraint)object).getRef()) != table) {
                orderedHashSet3.add(table2);
            }
            ((HashSet)object3).add(((Constraint)object).getMainName());
            ((HashSet)object3).add(((Constraint)object).getRefName());
            ((HashSet)object2).add(((Constraint)object).getRefIndex().getName());
        }
        OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet4 = table.getUniquePKConstraintNames();
        object = new TableWorks(session, table);
        orderedHashSet3 = ((TableWorks)object).dropConstraintsAndIndexes(orderedHashSet3, (OrderedHashSet<HsqlNameManager.HsqlName>)object3, (OrderedHashSet<HsqlNameManager.HsqlName>)object2);
        ((TableWorks)object).setNewTablesInSchema(orderedHashSet3);
        ((TableWorks)object).updateConstraints(orderedHashSet3, (OrderedHashSet<HsqlNameManager.HsqlName>)object3);
        this.removeSchemaObjects(orderedHashSet2);
        this.removeTableDependentReferences(table);
        this.removeReferencesTo(orderedHashSet4);
        this.removeReferencesTo(table.getName());
        this.removeReferencesFrom(table);
        schema.tableList.remove(table.getName().name);
        schema.indexLookup.removeParent(table.getName());
        schema.constraintLookup.removeParent(table.getName());
        schema.triggerLookup.removeParent(table.getName());
        this.removeTable(session, table);
        this.recompileDependentObjects(orderedHashSet3);
    }

    private void removeTable(Session session, Table table) {
        Session[] sessionArray;
        this.database.getGranteeManager().removeDbObject(table.getName());
        table.releaseTriggers();
        if (!table.isView() && table.hasLobColumn()) {
            sessionArray = table.rowIterator(session);
            while (sessionArray.next()) {
                Object[] objectArray = sessionArray.getCurrent();
                session.sessionData.adjustLobUsageCount(table, objectArray, -1);
            }
        }
        if (table.isTemp) {
            sessionArray = this.database.sessionManager.getAllSessions();
            for (int i = 0; i < sessionArray.length; ++i) {
                sessionArray[i].sessionData.persistentStoreCollection.removeStore(table);
            }
        } else {
            this.database.persistentStoreCollection.removeStore(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTable(int n, Table table) {
        this.writeLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get((Object)table.getSchemaName().name);
            schema.tableList.set(n, table.getName().name, table);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTableIndex(Table table) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get((Object)table.getSchemaName().name);
            if (schema == null) {
                int n = -1;
                return n;
            }
            HsqlNameManager.HsqlName hsqlName = table.getName();
            int n = schema.tableList.getIndex(hsqlName.name);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recompileDependentObjects(OrderedHashSet<Table> orderedHashSet) {
        this.writeLock.lock();
        try {
            SchemaObject schemaObject;
            OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet2 = new OrderedHashSet<HsqlNameManager.HsqlName>();
            for (int i = 0; i < orderedHashSet.size(); ++i) {
                Table table = orderedHashSet.get(i);
                orderedHashSet2.addAll(this.getReferencesTo(table.getName()));
            }
            Session session = this.database.sessionManager.getSysSession();
            block7: for (int i = 0; i < orderedHashSet2.size(); ++i) {
                HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet2.get(i);
                switch (hsqlName.type) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 24: {
                        schemaObject = this.findSchemaObject(hsqlName);
                        schemaObject.compile(session, null);
                        continue block7;
                    }
                }
            }
            if (Error.TRACE) {
                HsqlArrayList<Table> hsqlArrayList = this.getAllTables(false);
                for (int i = 0; i < hsqlArrayList.size(); ++i) {
                    schemaObject = hsqlArrayList.get(i);
                    ((Table)schemaObject).verifyConstraintsIntegrity();
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recompileDependentObjects(Table table) {
        this.writeLock.lock();
        try {
            SchemaObject schemaObject;
            OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
            this.getCascadingReferencesTo(table.getName(), orderedHashSet);
            Session session = this.database.sessionManager.getSysSession();
            block6: for (int i = 0; i < orderedHashSet.size(); ++i) {
                HsqlNameManager.HsqlName hsqlName = orderedHashSet.get(i);
                switch (hsqlName.type) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 24: {
                        schemaObject = this.findSchemaObject(hsqlName);
                        schemaObject.compile(session, null);
                        continue block6;
                    }
                }
            }
            if (Error.TRACE) {
                HsqlArrayList<Table> hsqlArrayList = this.getAllTables(false);
                for (int i = 0; i < hsqlArrayList.size(); ++i) {
                    schemaObject = hsqlArrayList.get(i);
                    ((Table)schemaObject).verifyConstraintsIntegrity();
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Collation getCollation(Session session, String string, String string2) {
        Collation collation = null;
        if (string2 == null || "INFORMATION_SCHEMA".equals(string2)) {
            try {
                collation = Collation.getCollation(string);
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }
        if (collation == null) {
            string2 = session.getSchemaName(string2);
            collation = (Collation)this.getSchemaObject(string, string2, 15);
        }
        return collation;
    }

    public NumberSequence findSequence(Session session, String string, String string2) {
        ReferenceObject referenceObject;
        NumberSequence numberSequence = this.getSequence(string, session.getSchemaName(string2), false);
        if (numberSequence == null && string2 == null && (referenceObject = this.findSynonym(string, string2 = session.getSchemaName(null), 7)) != null) {
            numberSequence = this.getSequence(referenceObject.target.name, referenceObject.target.schema.name, false);
        }
        return numberSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NumberSequence getSequence(String string, String string2, boolean bl) {
        this.readLock.lock();
        try {
            NumberSequence numberSequence;
            Schema schema = (Schema)this.schemaMap.get((Object)string2);
            if (schema != null && (numberSequence = (NumberSequence)schema.sequenceList.get((Object)string)) != null) {
                NumberSequence numberSequence2 = numberSequence;
                return numberSequence2;
            }
            if (bl) {
                throw Error.error(5501, string);
            }
            numberSequence = null;
            return numberSequence;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getUserDefinedType(String string, String string2, boolean bl) {
        this.readLock.lock();
        try {
            SchemaObject schemaObject;
            Schema schema = (Schema)this.schemaMap.get((Object)string2);
            if (schema != null && (schemaObject = schema.typeLookup.getObject(string)) != null) {
                Type type = (Type)schemaObject;
                return type;
            }
            if (bl) {
                throw Error.error(5501, string);
            }
            schemaObject = null;
            return schemaObject;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type findDomainOrUDT(Session session, String string, String string2, String string3, String string4) {
        this.readLock.lock();
        try {
            Type type;
            Type type2 = type = (Type)this.findSchemaObject(session, string, string2, string3, 12);
            return type2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getDomain(String string, String string2, boolean bl) {
        this.readLock.lock();
        try {
            SchemaObject schemaObject;
            Schema schema = (Schema)this.schemaMap.get((Object)string2);
            if (schema != null && (schemaObject = schema.typeLookup.getObject(string)) != null && ((Type)schemaObject).isDomainType()) {
                Type type = (Type)schemaObject;
                return type;
            }
            if (bl) {
                throw Error.error(5501, string);
            }
            schemaObject = null;
            return schemaObject;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getDistinctType(String string, String string2, boolean bl) {
        this.readLock.lock();
        try {
            SchemaObject schemaObject;
            Schema schema = (Schema)this.schemaMap.get((Object)string2);
            if (schema != null && (schemaObject = schema.typeLookup.getObject(string)) != null && ((Type)schemaObject).isDistinctType()) {
                Type type = (Type)schemaObject;
                return type;
            }
            if (bl) {
                throw Error.error(5501, string);
            }
            schemaObject = null;
            return schemaObject;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaObject getSchemaObject(String string, String string2, int n) {
        this.readLock.lock();
        try {
            SchemaObject schemaObject = this.findSchemaObject(string, string2, n);
            if (schemaObject == null) {
                throw Error.error(5501, string);
            }
            SchemaObject schemaObject2 = schemaObject;
            return schemaObject2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public SchemaObject getCharacterSet(Session session, String string, String string2) {
        if (string2 == null || "INFORMATION_SCHEMA".equals(string2)) {
            if (string.equals("SQL_IDENTIFIER")) {
                return Charset.SQL_IDENTIFIER_CHARSET;
            }
            if (string.equals("SQL_TEXT")) {
                return Charset.SQL_TEXT;
            }
            if (string.equals("LATIN1")) {
                return Charset.LATIN1;
            }
            if (string.equals("ASCII_GRAPHIC")) {
                return Charset.ASCII_GRAPHIC;
            }
        }
        if (string2 == null) {
            string2 = session.getSchemaName(null);
        }
        return this.getSchemaObject(string, string2, 14);
    }

    public Table findTable(Session session, String string, String string2, String string3) {
        return (Table)this.findSchemaObject(session, string, string2, string3, 3);
    }

    public SchemaObject findSchemaObject(Session session, String string, String string2, String string3, int n) {
        Table table;
        if (string3 != null && !string3.equals(this.database.getCatalogName().name)) {
            return null;
        }
        if (n == 3) {
            if (string2 == null) {
                if ((session.database.sqlSyntaxOra || session.database.sqlSyntaxDb2 || session.isProcessingScript()) && "DUAL".equals(string)) {
                    return this.dualTable;
                }
                table = this.findSessionTable(session, string);
                if (table != null) {
                    return table;
                }
            } else if (string3 == null && ("SESSION".equals(string2) || "MODULE".equals(string2)) && (table = this.findSessionTable(session, string)) != null) {
                return table;
            }
        }
        if (string2 == null) {
            string2 = session.getSchemaName(null);
        }
        if (n == 3 && "INFORMATION_SCHEMA".equals(string2) && this.database.dbInfo != null && (table = this.database.dbInfo.getSystemTable(session, string)) != null) {
            return table;
        }
        return this.findSchemaObject(string, string2, n);
    }

    public ReferenceObject findSynonym(String string, String string2, int n) {
        Schema schema = (Schema)this.schemaMap.get((Object)string2);
        if (schema == null) {
            return null;
        }
        ReferenceObject referenceObject = schema.findReference(string, n);
        return referenceObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaObject findAnySchemaObjectForSynonym(String string, String string2) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get((Object)string2);
            if (schema == null) {
                SchemaObject schemaObject = null;
                return schemaObject;
            }
            SchemaObject schemaObject = schema.findAnySchemaObjectForSynonym(string);
            return schemaObject;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaObject findSchemaObject(String string, String string2, int n) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get((Object)string2);
            if (schema == null) {
                SchemaObject schemaObject = null;
                return schemaObject;
            }
            if (n == 2) {
                Schema schema2 = schema;
                return schema2;
            }
            SchemaObject schemaObject = schema.findSchemaObject(string, n);
            return schemaObject;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Table findUserTableForIndex(Session session, String string, String string2) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get((Object)string2);
            HsqlNameManager.HsqlName hsqlName = schema.indexLookup.getName(string);
            if (hsqlName == null) {
                Table table = null;
                return table;
            }
            Table table = this.findUserTable(hsqlName.parent.name, string2);
            return table;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropIndex(Session session, HsqlNameManager.HsqlName hsqlName) {
        this.writeLock.lock();
        try {
            Table table = this.getUserTable(hsqlName.parent);
            TableWorks tableWorks = new TableWorks(session, table);
            tableWorks.dropIndex(hsqlName.name);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropConstraint(Session session, HsqlNameManager.HsqlName hsqlName, boolean bl) {
        this.writeLock.lock();
        try {
            Table table = this.getUserTable(hsqlName.parent);
            TableWorks tableWorks = new TableWorks(session, table);
            tableWorks.dropConstraint(hsqlName.name, bl);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void removeDependentObjects(HsqlNameManager.HsqlName hsqlName) {
        this.writeLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get((Object)hsqlName.schema.name);
            schema.indexLookup.removeParent(hsqlName);
            schema.constraintLookup.removeParent(hsqlName);
            schema.triggerLookup.removeParent(hsqlName);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeExportedKeys(Table table) {
        this.writeLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get((Object)table.getSchemaName().name);
            for (int i = 0; i < schema.tableList.size(); ++i) {
                Table table2 = schema.tableList.get(i);
                Constraint[] constraintArray = table2.getConstraints();
                for (int j = constraintArray.length - 1; j >= 0; --j) {
                    Table table3 = constraintArray[j].getRef();
                    if (table != table3) continue;
                    table2.removeConstraint(j);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<SchemaObject> databaseObjectIterator(String string, int n) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get((Object)string);
            Iterator<SchemaObject> iterator = schema.schemaObjectIterator(n);
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<SchemaObject> databaseObjectIterator(int n) {
        this.readLock.lock();
        try {
            Object object;
            Iterator iterator = this.schemaMap.values().iterator();
            WrapperIterator<Object> wrapperIterator = new WrapperIterator();
            while (iterator.hasNext()) {
                object = (Schema)iterator.next();
                Iterator<SchemaObject> iterator2 = ((Schema)object).schemaObjectIterator(n);
                if (!iterator2.hasNext()) continue;
                wrapperIterator = new WrapperIterator<SchemaObject>(wrapperIterator, iterator2);
            }
            object = wrapperIterator;
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Table> databaseTableIterator() {
        this.readLock.lock();
        try {
            Object object;
            Iterator iterator = this.schemaMap.values().iterator();
            WrapperIterator wrapperIterator = new WrapperIterator();
            while (iterator.hasNext()) {
                object = (Schema)iterator.next();
                Iterator iterator2 = ((Schema)object).tableList.values().iterator();
                if (!iterator2.hasNext()) continue;
                wrapperIterator = new WrapperIterator(wrapperIterator, iterator2);
            }
            object = wrapperIterator;
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Iterator<Constraint> databaseCheckConstraintIterator() {
        return new Iterator<Constraint>(){
            Iterator<SchemaObject> constraints;
            Constraint current;
            boolean b;
            {
                this.constraints = SchemaManager.this.databaseObjectIterator(5);
                this.b = this.filterToNext();
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public Constraint next() {
                Constraint constraint = this.current;
                this.filterToNext();
                return constraint;
            }

            private boolean filterToNext() {
                while (this.constraints.hasNext()) {
                    this.current = (Constraint)this.constraints.next();
                    if (this.current.constType != 3) continue;
                    return true;
                }
                this.current = null;
                return false;
            }
        };
    }

    private void addReferencesFrom(SchemaObject schemaObject) {
        OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = schemaObject.getReferences();
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        if (schemaObject instanceof Routine) {
            hsqlName = ((Routine)schemaObject).getSpecificName();
        }
        if (orderedHashSet == null) {
            return;
        }
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            HsqlNameManager.HsqlName hsqlName2 = orderedHashSet.get(i);
            this.referenceMap.put(hsqlName2, hsqlName);
        }
    }

    private void removeReferencesTo(OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet) {
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            HsqlNameManager.HsqlName hsqlName = orderedHashSet.get(i);
            this.referenceMap.remove(hsqlName);
        }
    }

    private void removeReferencesTo(HsqlNameManager.HsqlName hsqlName) {
        this.referenceMap.remove(hsqlName);
    }

    private void removeReferencesFrom(SchemaObject schemaObject) {
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = schemaObject.getReferences();
        if (schemaObject instanceof Routine) {
            hsqlName = ((Routine)schemaObject).getSpecificName();
        }
        if (orderedHashSet == null) {
            return;
        }
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            HsqlNameManager.HsqlName hsqlName2 = orderedHashSet.get(i);
            this.referenceMap.remove(hsqlName2, hsqlName);
        }
    }

    private void removeTableDependentReferences(Table table) {
        OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = table.getReferencesForDependents();
        block5: for (int i = 0; i < orderedHashSet.size(); ++i) {
            SchemaObject schemaObject;
            HsqlNameManager.HsqlName hsqlName = orderedHashSet.get(i);
            switch (hsqlName.type) {
                case 5: {
                    schemaObject = table.getConstraint(hsqlName.name);
                    break;
                }
                case 8: {
                    schemaObject = table.getTrigger(hsqlName.name);
                    break;
                }
                case 9: {
                    schemaObject = table.getColumn(table.getColumnIndex(hsqlName.name));
                    break;
                }
                default: {
                    continue block5;
                }
            }
            this.removeReferencesFrom(schemaObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderedHashSet<HsqlNameManager.HsqlName> getReferencesTo(HsqlNameManager.HsqlName hsqlName) {
        this.readLock.lock();
        try {
            Object object;
            OrderedHashSet<Object> orderedHashSet = new OrderedHashSet<Object>();
            Iterator<HsqlNameManager.HsqlName> iterator = this.referenceMap.getValuesIterator(hsqlName);
            while (iterator.hasNext()) {
                object = iterator.next();
                orderedHashSet.add(object);
            }
            object = orderedHashSet;
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderedHashSet<HsqlNameManager.HsqlName> getReferencesTo(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2) {
        this.readLock.lock();
        try {
            Object object;
            OrderedHashSet<Object> orderedHashSet = new OrderedHashSet<Object>();
            Iterator<HsqlNameManager.HsqlName> iterator = this.referenceMap.getValuesIterator(hsqlName);
            while (iterator.hasNext()) {
                object = iterator.next();
                SchemaObject schemaObject = this.findSchemaObject((HsqlNameManager.HsqlName)object);
                OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet2 = schemaObject.getReferences();
                if (!orderedHashSet2.contains(hsqlName2)) continue;
                orderedHashSet.add(object);
            }
            iterator = this.referenceMap.getValuesIterator(hsqlName2);
            while (iterator.hasNext()) {
                object = iterator.next();
                orderedHashSet.add(object);
            }
            object = orderedHashSet;
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private boolean isReferenced(HsqlNameManager.HsqlName hsqlName) {
        this.writeLock.lock();
        try {
            boolean bl = this.referenceMap.containsKey(hsqlName);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCascadingReferencesTo(HsqlNameManager.HsqlName hsqlName, OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet) {
        this.readLock.lock();
        try {
            OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet2 = new OrderedHashSet<HsqlNameManager.HsqlName>();
            Iterator<HsqlNameManager.HsqlName> iterator = this.referenceMap.getValuesIterator(hsqlName);
            while (iterator.hasNext()) {
                HsqlNameManager.HsqlName hsqlName2 = iterator.next();
                boolean bl = orderedHashSet.add(hsqlName2);
                if (!bl) continue;
                orderedHashSet2.add(hsqlName2);
            }
            for (int i = 0; i < orderedHashSet2.size(); ++i) {
                HsqlNameManager.HsqlName hsqlName3 = (HsqlNameManager.HsqlName)orderedHashSet2.get(i);
                this.getCascadingReferencesTo(hsqlName3, orderedHashSet);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void getCascadingReferencesToSchema(HsqlNameManager.HsqlName hsqlName, OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet) {
        Iterator iterator = this.referenceMap.keySet().iterator();
        while (iterator.hasNext()) {
            HsqlNameManager.HsqlName hsqlName2 = (HsqlNameManager.HsqlName)iterator.next();
            if (hsqlName2.schema != hsqlName) continue;
            this.getCascadingReferencesTo(hsqlName2, orderedHashSet);
        }
        for (int i = orderedHashSet.size() - 1; i >= 0; --i) {
            HsqlNameManager.HsqlName hsqlName3 = orderedHashSet.get(i);
            if (hsqlName3.schema != hsqlName) continue;
            orderedHashSet.remove(i);
        }
    }

    public MultiValueHashMap<HsqlNameManager.HsqlName, HsqlNameManager.HsqlName> getReferencesToSchema(String string) {
        MultiValueHashMap<HsqlNameManager.HsqlName, HsqlNameManager.HsqlName> multiValueHashMap = new MultiValueHashMap<HsqlNameManager.HsqlName, HsqlNameManager.HsqlName>();
        Iterator iterator = this.referenceMap.keySet().iterator();
        while (iterator.hasNext()) {
            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)iterator.next();
            if (!hsqlName.schema.name.equals(string)) continue;
            Iterator<HsqlNameManager.HsqlName> iterator2 = this.referenceMap.getValuesIterator(hsqlName);
            while (iterator2.hasNext()) {
                multiValueHashMap.put(hsqlName, iterator2.next());
            }
        }
        return multiValueHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlNameManager.HsqlName getSchemaObjectName(HsqlNameManager.HsqlName hsqlName, String string, int n, boolean bl) {
        this.readLock.lock();
        try {
            SchemaObject schemaObject = n == 2 ? (SchemaObject)this.schemaMap.get((Object)string) : this.findSchemaObject(string, hsqlName.name, n);
            if (schemaObject == null) {
                if (bl) {
                    throw Error.error(5501);
                }
                HsqlNameManager.HsqlName hsqlName2 = null;
                return hsqlName2;
            }
            HsqlNameManager.HsqlName hsqlName3 = schemaObject.getName();
            return hsqlName3;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaObject findSchemaObject(HsqlNameManager.HsqlName hsqlName) {
        this.readLock.lock();
        try {
            String string;
            String string2;
            if (hsqlName.type == 2) {
                string2 = hsqlName.schema.name;
                string = null;
            } else {
                string2 = hsqlName.name;
                string = hsqlName.schema.name;
            }
            SchemaObject schemaObject = this.findSchemaObject(string2, string, hsqlName.type);
            return schemaObject;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void checkColumnIsReferenced(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2) {
        OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = this.getReferencesTo(hsqlName, hsqlName2);
        if (!orderedHashSet.isEmpty()) {
            HsqlNameManager.HsqlName hsqlName3 = orderedHashSet.get(0);
            throw Error.error(5502, hsqlName3.getSchemaQualifiedStatementName());
        }
    }

    public void checkObjectIsReferenced(HsqlNameManager.HsqlName hsqlName) {
        int n;
        OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = this.getReferencesTo(hsqlName);
        HsqlNameManager.HsqlName hsqlName2 = null;
        for (n = 0; n < orderedHashSet.size(); ++n) {
            hsqlName2 = orderedHashSet.get(n);
            if (hsqlName2.parent != hsqlName) break;
            hsqlName2 = null;
        }
        if (hsqlName2 == null) {
            return;
        }
        if (hsqlName.type == 5) {
            return;
        }
        n = 5502;
        if (hsqlName2.type == 0) {
            n = 5533;
        }
        throw Error.error(n, hsqlName2.getSchemaQualifiedStatementName());
    }

    public void checkSchemaNameCanChange(HsqlNameManager.HsqlName hsqlName) {
        this.readLock.lock();
        try {
            Iterator<HsqlNameManager.HsqlName> iterator = this.referenceMap.values().iterator();
            HsqlNameManager.HsqlName hsqlName2 = null;
            block7: while (iterator.hasNext()) {
                HsqlNameManager.HsqlName hsqlName3 = iterator.next();
                switch (hsqlName3.type) {
                    case 4: 
                    case 8: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 24: {
                        if (hsqlName3.schema == hsqlName) {
                            hsqlName2 = hsqlName3;
                            break block7;
                        }
                    }
                    default: {
                        continue block7;
                    }
                }
            }
            if (hsqlName2 == null) {
                return;
            }
            throw Error.error(5502, hsqlName2.getSchemaQualifiedStatementName());
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSchemaObject(SchemaObject schemaObject) {
        this.writeLock.lock();
        try {
            HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
            Schema schema = (Schema)this.schemaMap.get((Object)hsqlName.schema.name);
            switch (hsqlName.type) {
                case 3: {
                    OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = ((Table)schemaObject).getReferencesForDependents();
                    block12: for (int i = 0; i < orderedHashSet.size(); ++i) {
                        HsqlNameManager.HsqlName hsqlName2 = orderedHashSet.get(i);
                        switch (hsqlName2.type) {
                            case 9: {
                                int n = ((Table)schemaObject).findColumn(hsqlName2.name);
                                ColumnSchema columnSchema = ((Table)schemaObject).getColumn(n);
                                this.addSchemaObject(columnSchema);
                                continue block12;
                            }
                        }
                    }
                    break;
                }
                case 9: {
                    OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = schemaObject.getReferences();
                    if (orderedHashSet == null || orderedHashSet.isEmpty()) {
                        return;
                    }
                    this.addReferencesFrom(schemaObject);
                    return;
                }
            }
            schema.addSchemaObject(this.database.nameManager, schemaObject, false);
            this.addReferencesFrom(schemaObject);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSchemaObject(HsqlNameManager.HsqlName hsqlName, boolean bl) {
        this.writeLock.lock();
        try {
            Object object;
            OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
            switch (hsqlName.type) {
                case 16: 
                case 17: 
                case 18: {
                    object = (RoutineSchema)this.findSchemaObject(hsqlName);
                    if (object == null) break;
                    Routine[] routineArray = ((RoutineSchema)object).getSpecificRoutines();
                    for (int i = 0; i < routineArray.length; ++i) {
                        this.getCascadingReferencesTo(routineArray[i].getSpecificName(), orderedHashSet);
                    }
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 12: 
                case 14: 
                case 15: 
                case 24: {
                    this.getCascadingReferencesTo(hsqlName, orderedHashSet);
                    break;
                }
                case 13: {
                    object = this.getReferencesTo(hsqlName);
                    Iterator iterator = ((HashSet)object).iterator();
                    while (iterator.hasNext()) {
                        HsqlNameManager.HsqlName hsqlName2 = (HsqlNameManager.HsqlName)iterator.next();
                        if (hsqlName2.type == 9) continue;
                        throw Error.error(5502, hsqlName2.getSchemaQualifiedStatementName());
                    }
                    break;
                }
            }
            if (orderedHashSet.isEmpty()) {
                this.removeSchemaObject(hsqlName);
                return;
            }
            if (!bl) {
                object = orderedHashSet.get(0);
                throw Error.error(5502, ((HsqlNameManager.HsqlName)object).getSchemaQualifiedStatementName());
            }
            orderedHashSet.add(hsqlName);
            this.removeSchemaObjects(orderedHashSet);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSchemaObjects(OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet) {
        this.writeLock.lock();
        try {
            HsqlNameManager.HsqlName hsqlName;
            int n;
            for (n = 0; n < orderedHashSet.size(); ++n) {
                hsqlName = orderedHashSet.get(n);
                if (hsqlName.parent == null) continue;
                this.removeSchemaObject(hsqlName);
            }
            for (n = 0; n < orderedHashSet.size(); ++n) {
                hsqlName = orderedHashSet.get(n);
                if (hsqlName.parent != null) continue;
                this.removeSchemaObject(hsqlName);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSchemaObject(HsqlNameManager.HsqlName hsqlName) {
        this.writeLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get((Object)hsqlName.schema.name);
            SchemaObject schemaObject = null;
            SchemaObjectSet schemaObjectSet = null;
            switch (hsqlName.type) {
                case 7: {
                    schemaObjectSet = schema.sequenceLookup;
                    schemaObject = schemaObjectSet.getObject(hsqlName.name);
                    break;
                }
                case 3: 
                case 4: {
                    schemaObjectSet = schema.tableLookup;
                    schemaObject = schemaObjectSet.getObject(hsqlName.name);
                    break;
                }
                case 9: {
                    Table table = (Table)this.findSchemaObject(hsqlName.parent);
                    if (table == null) break;
                    schemaObject = table.getColumn(table.getColumnIndex(hsqlName.name));
                    break;
                }
                case 14: {
                    schemaObjectSet = schema.charsetLookup;
                    schemaObject = schemaObjectSet.getObject(hsqlName.name);
                    break;
                }
                case 15: {
                    schemaObjectSet = schema.collationLookup;
                    schemaObject = schemaObjectSet.getObject(hsqlName.name);
                    break;
                }
                case 17: {
                    schemaObjectSet = schema.procedureLookup;
                    RoutineSchema routineSchema = (RoutineSchema)schemaObjectSet.getObject(hsqlName.name);
                    schemaObject = routineSchema;
                    Routine[] routineArray = routineSchema.getSpecificRoutines();
                    for (int i = 0; i < routineArray.length; ++i) {
                        this.removeSchemaObject(routineArray[i].getSpecificName());
                    }
                    break;
                }
                case 16: {
                    schemaObjectSet = schema.functionLookup;
                    RoutineSchema routineSchema = (RoutineSchema)schemaObjectSet.getObject(hsqlName.name);
                    schemaObject = routineSchema;
                    Routine[] routineArray = routineSchema.getSpecificRoutines();
                    for (int i = 0; i < routineArray.length; ++i) {
                        this.removeSchemaObject(routineArray[i].getSpecificName());
                    }
                    break;
                }
                case 24: {
                    schemaObjectSet = schema.specificRLookup;
                    Routine routine = (Routine)schemaObjectSet.getObject(hsqlName.name);
                    schemaObject = routine;
                    routine.routineSchema.removeSpecificRoutine(routine);
                    if (routine.routineSchema.getSpecificRoutines().length != 0) break;
                    this.removeSchemaObject(routine.getName());
                    break;
                }
                case 12: 
                case 13: {
                    schemaObjectSet = schema.typeLookup;
                    schemaObject = schemaObjectSet.getObject(hsqlName.name);
                    break;
                }
                case 20: {
                    schemaObjectSet = schema.indexLookup;
                    break;
                }
                case 5: {
                    schemaObjectSet = schema.constraintLookup;
                    if (hsqlName.parent.type == 3) {
                        Table table = (Table)schema.tableList.get((Object)hsqlName.parent.name);
                        schemaObject = table.getConstraint(hsqlName.name);
                        table.removeConstraint(hsqlName.name);
                        break;
                    }
                    if (hsqlName.parent.type != 13) break;
                    Type type = (Type)schema.typeLookup.getObject(hsqlName.parent.name);
                    schemaObject = type.userTypeModifier.getConstraint(hsqlName.name);
                    type.userTypeModifier.removeConstraint(hsqlName.name);
                    break;
                }
                case 8: {
                    schemaObjectSet = schema.triggerLookup;
                    Table table = (Table)schema.tableList.get((Object)hsqlName.parent.name);
                    schemaObject = table.getTrigger(hsqlName.name);
                    if (schemaObject == null) break;
                    table.removeTrigger((TriggerDef)schemaObject);
                    break;
                }
                case 29: {
                    schemaObjectSet = schema.referenceLookup;
                    schemaObject = schemaObjectSet.getObject(hsqlName.name);
                    break;
                }
                default: {
                    throw Error.runtimeError(201, "SchemaManager");
                }
            }
            if (schemaObject != null) {
                this.database.getGranteeManager().removeDbObject(hsqlName);
                this.removeReferencesFrom(schemaObject);
            }
            if (schemaObjectSet != null) {
                schemaObjectSet.remove(hsqlName.name);
            }
            this.removeReferencesTo(hsqlName);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameSchemaObject(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2) {
        this.writeLock.lock();
        try {
            if (hsqlName.schema != hsqlName2.schema) {
                throw Error.error(5505, hsqlName2.schema.name);
            }
            this.checkObjectIsReferenced(hsqlName);
            Schema schema = (Schema)this.schemaMap.get((Object)hsqlName.schema.name);
            schema.renameObject(hsqlName, hsqlName2);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void replaceReferences(SchemaObject schemaObject, SchemaObject schemaObject2) {
        this.writeLock.lock();
        try {
            this.removeReferencesFrom(schemaObject);
            this.addReferencesFrom(schemaObject2);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSQLArray() {
        this.readLock.lock();
        try {
            Iterator<SchemaObject> iterator;
            Object object;
            OrderedHashSet<HsqlNameManager.HsqlName> orderedHashSet = new OrderedHashSet<HsqlNameManager.HsqlName>();
            OrderedHashSet<SchemaObject> orderedHashSet2 = new OrderedHashSet<SchemaObject>();
            HsqlArrayList<String> hsqlArrayList = new HsqlArrayList<String>();
            Iterator<Schema> iterator2 = this.getUserSchemaIterator();
            block3: while (iterator2.hasNext()) {
                Schema schema = iterator2.next();
                hsqlArrayList.add(schema.getSQL());
                for (int i = 0; i < Schema.scriptSequenceOne.length; ++i) {
                    int n = Schema.scriptSequenceOne[i];
                    hsqlArrayList.addAll(schema.getSQLArray(n, orderedHashSet, orderedHashSet2));
                }
                while ((object = orderedHashSet2.iterator()).hasNext()) {
                    OrderedHashSet<SchemaObject> orderedHashSet3 = new OrderedHashSet<SchemaObject>();
                    SchemaObjectSet.addAllSQL(orderedHashSet, orderedHashSet2, hsqlArrayList, (Iterator<SchemaObject>)object, orderedHashSet3);
                    orderedHashSet2.removeAll(orderedHashSet3);
                    if (!orderedHashSet3.isEmpty()) continue;
                    continue block3;
                }
            }
            for (int i = 0; i < Schema.scriptSequenceTwo.length; ++i) {
                iterator2 = this.getUserSchemaIterator();
                while (iterator2.hasNext()) {
                    object = iterator2.next();
                    int n = Schema.scriptSequenceTwo[i];
                    hsqlArrayList.addAll(((Schema)object).getSQLArray(n, orderedHashSet, orderedHashSet2));
                }
            }
            while ((iterator = orderedHashSet2.iterator()).hasNext()) {
                object = new OrderedHashSet();
                SchemaObjectSet.addAllSQL(orderedHashSet, orderedHashSet2, hsqlArrayList, iterator, object);
                orderedHashSet2.removeAll((Collection<SchemaObject>)object);
                if (!((BaseHashMap)object).isEmpty()) continue;
                break;
            }
            iterator = orderedHashSet2.iterator();
            while (iterator.hasNext()) {
                object = (SchemaObject)iterator.next();
                if (!(object instanceof Routine)) continue;
                hsqlArrayList.add(((Routine)object).getSQLDeclaration());
            }
            iterator = orderedHashSet2.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (object instanceof Routine) {
                    hsqlArrayList.add(((Routine)object).getSQLAlter());
                    continue;
                }
                hsqlArrayList.add(object.getSQL());
            }
            iterator = orderedHashSet2.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (!(object instanceof ReferenceObject)) continue;
                hsqlArrayList.add(object.getSQL());
            }
            iterator2 = this.getUserSchemaIterator();
            while (iterator2.hasNext()) {
                object = iterator2.next();
                HsqlArrayList<String> hsqlArrayList2 = ((Schema)object).getTriggerSQLArray();
                if (hsqlArrayList2.size() <= 0) continue;
                hsqlArrayList.add(((Schema)object).getSetSchemaSQL());
                hsqlArrayList.addAll(hsqlArrayList2);
            }
            iterator2 = this.schemaMap.values().iterator();
            while (iterator2.hasNext()) {
                object = iterator2.next();
                hsqlArrayList.addAll(((Schema)object).getSequenceRestartSQLArray());
            }
            if (this.defaultSchemaHsqlName != null) {
                object = new StringBuilder(64);
                ((StringBuilder)object).append("SET").append(' ').append("DATABASE").append(' ').append("DEFAULT").append(' ').append("INITIAL").append(' ').append("SCHEMA").append(' ').append(this.defaultSchemaHsqlName.statementName);
                hsqlArrayList.add(((StringBuilder)object).toString());
            }
            object = hsqlArrayList;
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTablePropsSQLArray(boolean bl) {
        this.readLock.lock();
        try {
            HsqlArrayList<Table> hsqlArrayList = this.getAllTables(false);
            HsqlArrayList<String> hsqlArrayList2 = new HsqlArrayList<String>();
            for (int i = 0; i < hsqlArrayList.size(); ++i) {
                Object object;
                Table table = hsqlArrayList.get(i);
                if (table.isText()) {
                    object = table.getSQLForTextSource(bl);
                    hsqlArrayList2.addAll((Object[])object);
                }
                if ((object = table.getSQLForReadOnly()) != null) {
                    hsqlArrayList2.add((String)object);
                }
                if (!table.isCached() || (object = table.getSQLForClustered()) == null) continue;
                hsqlArrayList2.add((String)object);
            }
            HsqlArrayList<String> hsqlArrayList3 = hsqlArrayList2;
            return hsqlArrayList3;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTableSpaceSQLArray() {
        this.readLock.lock();
        try {
            HsqlArrayList<Table> hsqlArrayList = this.getAllTables(true);
            HsqlArrayList<String> hsqlArrayList2 = new HsqlArrayList<String>();
            for (int i = 0; i < hsqlArrayList.size(); ++i) {
                String string;
                Table table = hsqlArrayList.get(i);
                if (!table.isCached() || (string = table.getSQLForTableSpace()) == null) continue;
                hsqlArrayList2.add(string);
            }
            HsqlArrayList<String> hsqlArrayList3 = hsqlArrayList2;
            return hsqlArrayList3;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getIndexRootsSQLArray() {
        this.readLock.lock();
        try {
            long[][] lArray = this.getIndexRoots();
            HsqlArrayList<Table> hsqlArrayList = this.getAllTables(true);
            HsqlArrayList<String> hsqlArrayList2 = new HsqlArrayList<String>();
            for (int i = 0; i < lArray.length; ++i) {
                Table table = hsqlArrayList.get(i);
                if (lArray[i] == null || lArray[i].length <= 0 || lArray[i][0] == -1L) continue;
                String string = table.getIndexRootsSQL(lArray[i]);
                hsqlArrayList2.add(string);
            }
            HsqlArrayList<String> hsqlArrayList3 = hsqlArrayList2;
            return hsqlArrayList3;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setTempIndexRoots(long[][] lArray) {
        this.tempIndexRoots = lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[][] getIndexRoots() {
        this.readLock.lock();
        try {
            if (this.tempIndexRoots != null) {
                long[][] lArray = this.tempIndexRoots;
                this.tempIndexRoots = null;
                long[][] lArray2 = lArray;
                return lArray2;
            }
            HsqlArrayList<Table> hsqlArrayList = this.getAllTables(true);
            HsqlArrayList<long[]> hsqlArrayList2 = new HsqlArrayList<long[]>();
            int n = hsqlArrayList.size();
            for (int i = 0; i < n; ++i) {
                Table table = hsqlArrayList.get(i);
                if (table.getTableType() == 5) {
                    long[] lArray = table.getIndexRootsArray();
                    hsqlArrayList2.add(lArray);
                    continue;
                }
                hsqlArrayList2.add(null);
            }
            long[][] lArrayArray = new long[hsqlArrayList2.size()][];
            hsqlArrayList2.toArray((T[])lArrayArray);
            long[][] lArrayArray2 = lArrayArray;
            return lArrayArray2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndexRoots(long[][] lArray) {
        this.readLock.lock();
        try {
            HsqlArrayList<Table> hsqlArrayList = this.database.schemaManager.getAllTables(true);
            int n = hsqlArrayList.size();
            for (int i = 0; i < n; ++i) {
                long[] lArray2;
                Table table = hsqlArrayList.get(i);
                if (table.getTableType() != 5 || (lArray2 = lArray[i]) == null) continue;
                table.setIndexRoots(lArray2);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setDefaultTableType(int n) {
        this.defaultTableType = n;
    }

    public int getDefaultTableType() {
        return this.defaultTableType;
    }

    public void createSystemTables() {
        this.dualTable = TableUtil.newSingleColumnTable(this.database, SqlInvariants.DUAL_TABLE_HSQLNAME, 12, SqlInvariants.DUAL_COLUMN_HSQLNAME, Type.SQL_VARCHAR);
        this.dualTable.insertSys(this.database.sessionManager.getSysSession(), this.dualTable.getRowStore(null), new Object[]{"X"});
        this.dualTable.setDataReadOnly(true);
    }

    static class UserSchemaFilter
    implements FilteredIterator.Filter<Schema> {
        UserSchemaFilter() {
        }

        @Override
        public boolean test(Schema schema) {
            String string = schema.getName().name;
            return !SqlInvariants.isLobsSchemaName(string) && !SqlInvariants.isSystemSchemaName(string);
        }
    }
}

