/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.lint;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import schemacrawler.schema.CrawlInfo;
import schemacrawler.tools.lint.Lint;
import us.fatehi.utility.Utility;

public final class LintReport
implements Iterable<Lint<? extends Serializable>> {
    private final CrawlInfo crawlInfo;
    private final Collection<Lint<? extends Serializable>> lints;
    private final String title;

    public LintReport(String title, CrawlInfo crawlInfo, Collection<Lint<? extends Serializable>> lints) {
        this.title = Utility.trimToEmpty((String)title);
        this.crawlInfo = Objects.requireNonNull(crawlInfo, "No crawl information provided");
        this.lints = Objects.requireNonNull(lints, "No lints provided");
    }

    public CrawlInfo getCrawlInfo() {
        return this.crawlInfo;
    }

    public Collection<Lint<? extends Serializable>> getLints() {
        return new ArrayList<Lint<? extends Serializable>>(this.lints);
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public Iterator<Lint<? extends Serializable>> iterator() {
        return this.getLints().iterator();
    }

    public int size() {
        return this.lints.size();
    }
}

