/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.lint;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import schemacrawler.schema.AttributedObject;
import schemacrawler.schema.NamedObject;
import schemacrawler.tools.lint.LintObjectType;
import schemacrawler.tools.lint.LintSeverity;
import us.fatehi.utility.ObjectToString;
import us.fatehi.utility.Utility;

public final class Lint<V extends Serializable>
implements Serializable,
Comparable<Lint<? extends Serializable>> {
    private static final long serialVersionUID = -8627082144974643415L;
    private final String lintId = UUID.randomUUID().toString();
    private final String linterId;
    private final String linterInstanceId;
    private final String message;
    private final String objectName;
    private final LintObjectType objectType;
    private final LintSeverity severity;
    private final V value;

    public <N extends NamedObject & AttributedObject> Lint(String linterId, String linterInstanceId, LintObjectType objectType, N namedObject, LintSeverity severity, String message, V value) {
        this.linterId = Utility.requireNotBlank((String)linterId, (String)"Linter id not provided");
        this.linterInstanceId = Utility.requireNotBlank((String)linterInstanceId, (String)"Linter instance id not provided");
        this.objectType = Objects.requireNonNull(objectType, "Named object type not provided");
        Objects.requireNonNull(namedObject, "Named object not provided");
        this.objectName = namedObject.getFullName();
        this.severity = severity == null ? LintSeverity.critical : severity;
        if (Utility.isBlank((CharSequence)message)) {
            throw new IllegalArgumentException("Lint message not provided");
        }
        this.message = message;
        this.value = value;
    }

    @Override
    public int compareTo(Lint<?> lint) {
        if (lint == null) {
            return -1;
        }
        int compareTo = this.objectType.compareTo(lint.getObjectType());
        if (compareTo != 0) {
            return compareTo;
        }
        compareTo = this.objectName.compareTo(lint.getObjectName());
        if (compareTo != 0) {
            return compareTo;
        }
        compareTo = this.severity.compareTo(lint.getSeverity());
        if ((compareTo *= -1) != 0) {
            return compareTo;
        }
        compareTo = this.linterId.compareTo(lint.getLinterId());
        if (compareTo != 0) {
            return compareTo;
        }
        return this.message.compareTo(lint.getMessage());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Lint)) {
            return false;
        }
        Lint lint = (Lint)o;
        return Objects.equals(this.linterId, lint.linterId) && Objects.equals(this.message, lint.message) && Objects.equals(this.objectName, lint.objectName) && this.objectType == lint.objectType && this.severity == lint.severity && Objects.equals(this.value, lint.value);
    }

    public String getLinterId() {
        return this.linterId;
    }

    public String getLinterInstanceId() {
        return this.linterInstanceId;
    }

    public String getLintId() {
        return this.lintId;
    }

    public String getMessage() {
        return this.message;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public LintObjectType getObjectType() {
        return this.objectType;
    }

    public LintSeverity getSeverity() {
        return this.severity;
    }

    public V getValue() {
        return this.value;
    }

    public String getValueAsString() {
        if (this.value != null) {
            Class<?> valueClass = this.value.getClass();
            Object valueObject = this.value;
            if (valueClass.isArray() && NamedObject.class.isAssignableFrom(valueClass.getComponentType())) {
                valueObject = Arrays.asList((NamedObject[])Arrays.copyOf((Object[])this.value, ((Object[])this.value).length, NamedObject[].class));
            }
            if (NamedObject.class.isAssignableFrom(valueClass)) {
                valueObject = ((NamedObject)valueObject).getFullName();
            } else if (Iterable.class.isAssignableFrom(valueObject.getClass())) {
                ArrayList<String> list = new ArrayList<String>();
                for (Object valuePart : (Iterable)valueObject) {
                    if (valuePart instanceof NamedObject) {
                        list.add(((NamedObject)valuePart).getFullName());
                        continue;
                    }
                    list.add(valuePart.toString());
                }
                valueObject = list;
            }
            return ObjectToString.listOrObjectToString(valueObject);
        }
        return "";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.linterId, this.message, this.objectName, this.objectType, this.severity, this.value});
    }

    public boolean hasValue() {
        return this.value == null;
    }

    public String toString() {
        String valueString = this.value != null && !(this.value instanceof Boolean) ? ": " + this.getValueAsString() : "";
        return String.format("[%s] %s%s", this.objectName, this.message, valueString);
    }
}

