/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.metadata.loader;

import com.ibm.db2.cmx.runtime.internal.repository.metadata.SourceInfo;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.SourceLocation;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.SourceReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SourceTableCache {
    private HashMap<String, Integer> cache = new HashMap();

    public Integer searchFor(SourceInfo sourceInfo) {
        String string = this.generateKey(sourceInfo);
        return this.cache.get(string);
    }

    public Integer searchFor(List<SourceInfo> list) {
        String string = this.generateKey(list);
        return this.cache.get(string);
    }

    public void add(int n2, List<SourceInfo> list) {
        String string = this.generateKey(list);
        this.cache.put(string, n2);
    }

    public void load(Connection connection, String string, String string2) throws SQLException {
        HashMap<Integer, SourceLocation> hashMap = SourceReader.getInstance(string).getSourceInfos(string2, null, connection, null);
        Set<Map.Entry<Integer, SourceLocation>> set = hashMap.entrySet();
        for (Map.Entry<Integer, SourceLocation> entry : set) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    private String generateKey(List<SourceInfo> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(list.get(0).getProjectName());
        for (SourceInfo sourceInfo : list) {
            this.generateKey(stringBuilder, sourceInfo);
        }
        return stringBuilder.toString();
    }

    private String generateKey(SourceInfo sourceInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(sourceInfo.getProjectName());
        this.generateKey(stringBuilder, sourceInfo);
        return stringBuilder.toString();
    }

    private void generateKey(StringBuilder stringBuilder, SourceInfo sourceInfo) {
        stringBuilder.append(':');
        stringBuilder.append(sourceInfo.getPath());
        stringBuilder.append(':');
        stringBuilder.append(sourceInfo.getLineNumber());
        if (sourceInfo.getLabel() != null) {
            stringBuilder.append(':');
            stringBuilder.append(sourceInfo.getLabelType());
            stringBuilder.append(':');
            stringBuilder.append(sourceInfo.getLabel());
        }
    }
}

