/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.chatgpt.functions;

import java.util.function.Function;
import java.util.regex.Pattern;
import schemacrawler.inclusionrule.ExcludeAll;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.GrepOptionsBuilder;
import schemacrawler.schemacrawler.LimitOptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.tools.command.chatgpt.functions.AbstractExecutableFunctionDefinition;
import schemacrawler.tools.command.chatgpt.functions.LintFunctionParameters;
import schemacrawler.tools.options.Config;

public final class LintFunctionDefinition
extends AbstractExecutableFunctionDefinition<LintFunctionParameters> {
    public LintFunctionDefinition() {
        super("Lint database schemas. Find design issues with specific tables, or with the entire database.Find problems with database design, such as no indexes on foreign keys.", LintFunctionParameters.class);
    }

    @Override
    protected Config createAdditionalConfig(LintFunctionParameters args) {
        return new Config();
    }

    @Override
    protected SchemaCrawlerOptions createSchemaCrawlerOptions(LintFunctionParameters args) {
        LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder().includeSynonyms((InclusionRule)new ExcludeAll()).includeSequences((InclusionRule)new ExcludeAll()).includeRoutines((InclusionRule)new ExcludeAll());
        Pattern grepTablesPattern = this.makeNameInclusionPattern(args.getTableName());
        GrepOptionsBuilder grepOptionsBuilder = GrepOptionsBuilder.builder().includeGreppedTables(grepTablesPattern);
        return SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withLimitOptions(limitOptionsBuilder.toOptions()).withGrepOptions(grepOptionsBuilder.toOptions());
    }

    @Override
    protected String getCommand() {
        return "lint";
    }

    @Override
    protected Function<Catalog, Boolean> getResultsChecker(LintFunctionParameters args) {
        return catalog -> !catalog.getTables().isEmpty();
    }
}

