/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.chatgpt.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.exceptions.InternalRuntimeException;
import schemacrawler.tools.command.chatgpt.FunctionDefinition;
import schemacrawler.tools.registry.BasePluginRegistry;
import us.fatehi.utility.property.PropertyName;
import us.fatehi.utility.string.StringFormat;

public final class FunctionDefinitionRegistry
extends BasePluginRegistry {
    private static final Logger LOGGER = Logger.getLogger(FunctionDefinitionRegistry.class.getName());
    private static FunctionDefinitionRegistry functionDefinitionRegistrySingleton;
    private final Map<String, FunctionDefinition> functionDefinitionRegistry = FunctionDefinitionRegistry.loadFunctionDefinitionRegistry();

    public static FunctionDefinitionRegistry getFunctionDefinitionRegistry() {
        if (functionDefinitionRegistrySingleton == null) {
            functionDefinitionRegistrySingleton = new FunctionDefinitionRegistry();
        }
        functionDefinitionRegistrySingleton.log();
        return functionDefinitionRegistrySingleton;
    }

    private static Map<String, FunctionDefinition> loadFunctionDefinitionRegistry() {
        HashMap<String, FunctionDefinition> functionDefinitionRegistry = new HashMap<String, FunctionDefinition>();
        try {
            ServiceLoader<FunctionDefinition> serviceLoader = ServiceLoader.load(FunctionDefinition.class, FunctionDefinitionRegistry.class.getClassLoader());
            for (FunctionDefinition functionDefinition : serviceLoader) {
                String functionName = functionDefinition.getName();
                LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Loading function definition, %s", new Object[]{functionName}));
                functionDefinitionRegistry.put(functionName, functionDefinition);
            }
        }
        catch (Exception e) {
            throw new InternalRuntimeException("Could not load function definition registry", (Throwable)e);
        }
        LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Loaded %d function definitions", new Object[]{functionDefinitionRegistry.size()}));
        return functionDefinitionRegistry;
    }

    private FunctionDefinitionRegistry() {
    }

    public Collection<FunctionDefinition> getFunctionDefinitions() {
        return new ArrayList<FunctionDefinition>(this.functionDefinitionRegistry.values());
    }

    public Collection<PropertyName> getRegisteredPlugins() {
        ArrayList<PropertyName> registeredPlugins = new ArrayList<PropertyName>();
        for (FunctionDefinition functionDefinition : this.functionDefinitionRegistry.values()) {
            registeredPlugins.add(new PropertyName(functionDefinition.getName(), functionDefinition.getDescription()));
        }
        return registeredPlugins;
    }

    public String getName() {
        return "Function Definitions";
    }
}

