/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.chatgpt.functions;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Objects;
import java.util.function.Function;
import schemacrawler.schema.Catalog;
import schemacrawler.tools.command.chatgpt.FunctionReturn;
import schemacrawler.tools.executable.SchemaCrawlerExecutable;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;

public class ExecutableFunctionReturn
implements FunctionReturn {
    private final SchemaCrawlerExecutable executable;
    private final Function<Catalog, Boolean> resultsChecker;

    protected ExecutableFunctionReturn(SchemaCrawlerExecutable executable, Function<Catalog, Boolean> resultsChecker) {
        this.executable = Objects.requireNonNull(executable, "SchemaCrawler executable not provided");
        this.resultsChecker = Objects.requireNonNull(resultsChecker, "Check for results");
    }

    @Override
    public String get() {
        StringWriter writer = new StringWriter();
        OutputOptions outputOptions = OutputOptionsBuilder.builder().withOutputWriter((Writer)writer).toOptions();
        this.executable.setOutputOptions(outputOptions);
        this.executable.execute();
        if (!this.resultsChecker.apply(this.executable.getCatalog()).booleanValue()) {
            return "There were no matching results for your query.";
        }
        return writer.toString();
    }
}

