/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.chatgpt.embeddings;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.linear.ArrayRealVector;

public class ListRealVector
extends ArrayRealVector {
    private static final Logger LOGGER = Logger.getLogger(ListRealVector.class.getCanonicalName());
    private static final long serialVersionUID = -7262722041120229630L;
    private final List<Double> embedding;

    private static double[] convertListToArray(List<Double> list) {
        Objects.requireNonNull(list, "No embedding provided");
        int size = list.size();
        double[] array = new double[size];
        for (int i = 0; i < size; ++i) {
            Double value = list.get(i);
            if (value == null) {
                LOGGER.log(Level.WARNING, "Embedding contains null values");
                continue;
            }
            array[i] = value;
        }
        return array;
    }

    public ListRealVector() {
        this.embedding = new ArrayList<Double>();
    }

    public ListRealVector(List<Double> embedding) {
        super(ListRealVector.convertListToArray(embedding));
        this.embedding = embedding;
    }

    public List<Double> getEmbedding() {
        return this.embedding;
    }
}

