/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.chatgpt.embeddings;

import java.util.Objects;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.tools.command.chatgpt.embeddings.TextEmbedding;
import schemacrawler.tools.command.serialize.model.CompactCatalogUtility;
import schemacrawler.tools.command.serialize.model.TableDocument;

public final class EmbeddedTable
implements NamedObject {
    private static final long serialVersionUID = 5216101777323983303L;
    private final Table table;
    private final TableDocument tableDocument;
    private TextEmbedding embedding;

    EmbeddedTable(Table table) {
        this.table = Objects.requireNonNull(table, "No table provided");
        this.tableDocument = CompactCatalogUtility.getTableDocument((Table)table, (boolean)false);
    }

    public int compareTo(NamedObject object) {
        return this.table.compareTo((Object)object);
    }

    public TextEmbedding getEmbedding() {
        return this.embedding;
    }

    public String getFullName() {
        return this.table.getFullName();
    }

    public String getName() {
        return this.table.getName();
    }

    public Schema getSchema() {
        return this.table.getSchema();
    }

    public boolean hasEmbedding() {
        return this.embedding != null;
    }

    public NamedObjectKey key() {
        return this.table.key();
    }

    public String toJson() {
        return this.tableDocument.toJson();
    }

    public String toString() {
        return this.getFullName();
    }

    void setEmbedding(TextEmbedding providedEmmedding) {
        this.embedding = providedEmmedding;
    }
}

