/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.metadata;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.FunctionMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.FunctionSignature;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.ing.data.cassandra.jdbc.CassandraConnection;
import com.ing.data.cassandra.jdbc.CassandraStatement;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public abstract class AbstractMetadataResultSetBuilder {
    static final String TABLE = "TABLE";
    static final String CQL_OPTION_COMMENT = "comment";
    static final String ASC_OR_DESC = "ASC_OR_DESC";
    static final String ATTRIBUTE_DEFAULT = "ATTR_DEF";
    static final String ATTRIBUTE_NAME = "ATTR_NAME";
    static final String ATTRIBUTE_SIZE = "ATTR_SIZE";
    static final String ATTRIBUTE_TYPE_NAME = "ATTR_TYPE_NAME";
    static final String AUTO_INCREMENT = "AUTO_INCREMENT";
    static final String BASE_TYPE = "BASE_TYPE";
    static final String BUFFER_LENGTH = "BUFFER_LENGTH";
    static final String CARDINALITY = "CARDINALITY";
    static final String CASE_SENSITIVE = "CASE_SENSITIVE";
    static final String CHAR_OCTET_LENGTH = "CHAR_OCTET_LENGTH";
    static final String CLASS_NAME = "CLASS_NAME";
    static final String COLUMN_DEFAULT = "COLUMN_DEF";
    static final String COLUMN_NAME = "COLUMN_NAME";
    static final String COLUMN_SIZE = "COLUMN_SIZE";
    static final String COLUMN_TYPE = "COLUMN_TYPE";
    static final String CREATE_PARAMS = "CREATE_PARAMS";
    static final String DATA_TYPE = "DATA_TYPE";
    static final String DECIMAL_DIGITS = "DECIMAL_DIGITS";
    static final String FILTER_CONDITION = "FILTER_CONDITION";
    static final String FIXED_PRECISION_SCALE = "FIXED_PREC_SCALE";
    static final String FUNCTION_CATALOG = "FUNCTION_CAT";
    static final String FUNCTION_NAME = "FUNCTION_NAME";
    static final String FUNCTION_SCHEMA = "FUNCTION_SCHEM";
    static final String FUNCTION_TYPE = "FUNCTION_TYPE";
    static final String INDEX_NAME = "INDEX_NAME";
    static final String INDEX_QUALIFIER = "INDEX_QUALIFIER";
    static final String IS_AUTOINCREMENT = "IS_AUTOINCREMENT";
    static final String IS_GENERATED_COLUMN = "IS_GENERATEDCOLUMN";
    static final String IS_NULLABLE = "IS_NULLABLE";
    static final String KEY_SEQ = "KEY_SEQ";
    static final String LENGTH = "LENGTH";
    static final String LITERAL_PREFIX = "LITERAL_PREFIX";
    static final String LITERAL_SUFFIX = "LITERAL_SUFFIX";
    static final String LOCALIZED_TYPE_NAME = "LOCAL_TYPE_NAME";
    static final String MAXIMUM_SCALE = "MAXIMUM_SCALE";
    static final String MINIMUM_SCALE = "MINIMUM_SCALE";
    static final String NO_VALUE = "NO";
    static final String NON_UNIQUE = "NON_UNIQUE";
    static final String NULLABLE = "NULLABLE";
    static final String NUM_PRECISION_RADIX = "NUM_PREC_RADIX";
    static final String ORDINAL_POSITION = "ORDINAL_POSITION";
    static final String PAGES = "PAGES";
    static final String PRECISION = "PRECISION";
    static final String PRIMARY_KEY_NAME = "PK_NAME";
    static final String PSEUDO_COLUMN = "PSEUDO_COLUMN";
    static final String RADIX = "RADIX";
    static final String REF_GENERATION = "REF_GENERATION";
    static final String REMARKS = "REMARKS";
    static final String SCALE = "SCALE";
    static final String SCOPE = "SCOPE";
    static final String SCOPE_CATALOG = "SCOPE_CATALOG";
    static final String SCOPE_SCHEMA = "SCOPE_SCHEMA";
    static final String SCOPE_TABLE = "SCOPE_TABLE";
    static final String SEARCHABLE = "SEARCHABLE";
    static final String SELF_REFERENCING_COL_NAME = "SELF_REFERENCING_COL_NAME";
    static final String SOURCE_DATA_TYPE = "SOURCE_DATA_TYPE";
    static final String SPECIFIC_NAME = "SPECIFIC_NAME";
    static final String SQL_DATA_TYPE = "SQL_DATA_TYPE";
    static final String SQL_DATETIME_SUB = "SQL_DATETIME_SUB";
    static final String TABLE_CATALOG_SHORTNAME = "TABLE_CAT";
    static final String TABLE_CATALOG = "TABLE_CATALOG";
    static final String TABLE_NAME = "TABLE_NAME";
    static final String TABLE_SCHEMA = "TABLE_SCHEM";
    static final String TABLE_TYPE = "TABLE_TYPE";
    static final String TYPE = "TYPE";
    static final String TYPE_CATALOG = "TYPE_CAT";
    static final String TYPE_NAME = "TYPE_NAME";
    static final String TYPE_SCHEMA = "TYPE_SCHEM";
    static final String UNSIGNED_ATTRIBUTE = "UNSIGNED_ATTRIBUTE";
    static final String YES_VALUE = "YES";
    CassandraStatement statement;
    CassandraConnection connection;

    protected AbstractMetadataResultSetBuilder(CassandraStatement statement) throws SQLException {
        this.statement = statement;
        this.connection = statement.getCassandraConnection();
    }

    public boolean matchesPattern(String pattern, String testedValue) {
        return testedValue.matches(String.format("(?i)^%s$", pattern.replaceAll("%", ".*")));
    }

    void filterBySchemaNamePattern(String schemaNamePattern, Consumer<KeyspaceMetadata> consumer, Consumer<KeyspaceMetadata> altConsumer) {
        this.filterByPattern(schemaNamePattern, this.connection.getClusterMetadata().getKeyspaces(), (pattern, keyspaceMetadata) -> pattern == null || "".equals(pattern) || this.matchesPattern((String)pattern, keyspaceMetadata.getName().asInternal()), consumer, Optional.ofNullable(altConsumer).orElse(this.noOpConsumer()));
    }

    void filterByTableNamePattern(String tableNamePattern, KeyspaceMetadata keyspaceMetadata, Consumer<TableMetadata> consumer, Consumer<TableMetadata> altConsumer) {
        this.filterByPattern(tableNamePattern, keyspaceMetadata.getTables(), (pattern, tableMetadata) -> pattern == null || this.matchesPattern((String)pattern, tableMetadata.getName().asInternal()), consumer, Optional.ofNullable(altConsumer).orElse(this.noOpConsumer()));
    }

    void filterByColumnNamePattern(String columnNamePattern, TableMetadata tableMetadata, Consumer<ColumnMetadata> consumer, Consumer<ColumnMetadata> altConsumer) {
        this.filterByPattern(columnNamePattern, tableMetadata.getColumns(), (pattern, columnMetadata) -> pattern == null || this.matchesPattern((String)pattern, columnMetadata.getName().asInternal()), consumer, Optional.ofNullable(altConsumer).orElse(this.noOpConsumer()));
    }

    void filterByFunctionNamePattern(String functionNamePattern, KeyspaceMetadata keyspaceMetadata, BiConsumer<FunctionSignature, FunctionMetadata> consumer) {
        for (Map.Entry entry : keyspaceMetadata.getFunctions().entrySet()) {
            FunctionSignature functionSignature = (FunctionSignature)entry.getKey();
            FunctionMetadata functionMetadata = (FunctionMetadata)entry.getValue();
            if (functionNamePattern != null && !this.matchesPattern(functionNamePattern, functionSignature.getName().asInternal())) continue;
            consumer.accept(functionSignature, functionMetadata);
        }
    }

    <M> void filterByPattern(String pattern, Map<CqlIdentifier, M> metadataMap, BiFunction<String, M, Boolean> patternMatcher, Consumer<M> consumer, Consumer<M> altConsumer) {
        for (Map.Entry<CqlIdentifier, M> entry : metadataMap.entrySet()) {
            M entityMetadata = entry.getValue();
            if (patternMatcher.apply(pattern, entityMetadata).booleanValue()) {
                consumer.accept(entityMetadata);
                continue;
            }
            altConsumer.accept(entityMetadata);
        }
    }

    <M> Consumer<M> noOpConsumer() {
        return entityMetadata -> {};
    }
}

