/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.formatter.serialize;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.logging.Logger;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.exceptions.IORuntimeException;
import schemacrawler.tools.command.serialize.model.CatalogDocument;
import schemacrawler.tools.command.serialize.model.CompactCatalogUtility;
import schemacrawler.tools.formatter.serialize.CatalogSerializer;

public final class CompactSerializedCatalog
implements CatalogSerializer {
    private static final Logger LOGGER = Logger.getLogger(CompactSerializedCatalog.class.getName());
    private final Catalog catalog;
    private final CatalogDocument catalogDescription;

    public CompactSerializedCatalog(Catalog catalog) {
        this.catalog = Objects.requireNonNull(catalog, "No catalog provided");
        this.catalogDescription = CompactCatalogUtility.createCatalogDocument(catalog);
    }

    @Override
    public Catalog getCatalog() {
        return this.catalog;
    }

    @Override
    public void save(OutputStream out) {
        Objects.requireNonNull(out, "No output stream provided");
        this.save(new OutputStreamWriter(out, StandardCharsets.UTF_8));
    }

    @Override
    public void save(Writer out) {
        Objects.requireNonNull(out, "No writer provided");
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue(out, (Object)this.catalogDescription);
        }
        catch (IOException e) {
            throw new IORuntimeException("Could not serialize catalog", e);
        }
    }
}

