/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.serialize.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.Table;
import schemacrawler.tools.command.serialize.model.CatalogDocument;
import schemacrawler.tools.command.serialize.model.ColumnDocument;
import schemacrawler.tools.command.serialize.model.TableDocument;

public final class CompactCatalogUtility {
    public static CatalogDocument createCatalogDocument(Catalog catalog) {
        Objects.requireNonNull(catalog, "No catalog provided");
        CatalogDocument catalogDocument = new CatalogDocument(catalog.getDatabaseInfo().getDatabaseProductName());
        for (Table table : catalog.getTables()) {
            TableDocument tableDocument = CompactCatalogUtility.getTableDocument(table, true);
            catalogDocument.addTable(tableDocument);
        }
        return catalogDocument;
    }

    public static TableDocument getTableDocument(Table table, boolean withDependents) {
        Objects.requireNonNull(table, "No table provided");
        Map<String, Column> referencedColumns = CompactCatalogUtility.mapReferencedColumns(table);
        TableDocument tableDocument = new TableDocument(table);
        for (Column column : table.getColumns()) {
            ColumnDocument columnDocument = new ColumnDocument(column, referencedColumns.get(column.getName()));
            tableDocument.addColumn(columnDocument);
        }
        if (withDependents) {
            Collection dependentTables = table.getDependentTables();
            for (Table dependentTable : dependentTables) {
                TableDocument dependentTableDocument = new TableDocument(dependentTable);
                tableDocument.addDependentTable(dependentTableDocument);
            }
        }
        return tableDocument;
    }

    private static Map<String, Column> mapReferencedColumns(Table table) {
        Objects.requireNonNull(table, "No table provided");
        HashMap<String, Column> referencedColumns = new HashMap<String, Column>();
        for (ForeignKey foreignKey : table.getImportedForeignKeys()) {
            List columnReferences = foreignKey.getColumnReferences();
            for (ColumnReference columnReference : columnReferences) {
                referencedColumns.put(columnReference.getForeignKeyColumn().getName(), columnReference.getPrimaryKeyColumn());
            }
        }
        return referencedColumns;
    }

    private CompactCatalogUtility() {
    }
}

