/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.serialize.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.io.Serializable;
import java.util.Objects;
import schemacrawler.schema.Column;
import schemacrawler.tools.command.serialize.model.ReferencedColumnDocument;
import us.fatehi.utility.Utility;

@JsonNaming(value=PropertyNamingStrategies.KebabCaseStrategy.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"column", "remarks", "type", "referenced-column"})
public final class ColumnDocument
implements Serializable {
    private static final long serialVersionUID = 5110252842937512910L;
    private final String columnName;
    private final String dataType;
    private final String remarks;
    private final ReferencedColumnDocument referencedColumn;

    public ColumnDocument(Column column, Column pkColumn) {
        Objects.requireNonNull(column, "No column provided");
        this.columnName = column.getName();
        this.dataType = column.getColumnDataType().getName();
        String remarks = column.getRemarks();
        this.remarks = !Utility.isBlank((CharSequence)remarks) ? remarks : null;
        this.referencedColumn = pkColumn == null ? null : new ReferencedColumnDocument(pkColumn);
    }

    @JsonProperty(value="column")
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty(value="type")
    public String getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="referenced-column")
    public ReferencedColumnDocument getReferencedColumn() {
        return this.referencedColumn;
    }

    @JsonProperty(value="remarks")
    public String getRemarks() {
        return this.remarks;
    }
}

