# frozen_string_literal: true

# The code was auto-generated by {this script}[https://github.com/cucumber/messages/blob/main/codegen/codegen.rb]
module Cucumber
  module Messages
    ##
    # Represents the Pickle message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    ##
    #
    # A `Pickle` represents a template for a `TestCase`. It is typically derived
    # from another format, such as [GherkinDocument](#io.cucumber.messages.GherkinDocument).
    # In the future a `Pickle` may be derived from other formats such as Markdown or
    # Excel files.
    #
    # By making `Pickle` the main data structure Cucumber uses for execution, the
    # implementation of Cucumber itself becomes simpler, as it doesn't have to deal
    # with the complex structure of a [GherkinDocument](#io.cucumber.messages.GherkinDocument).
    #
    # Each `PickleStep` of a `Pickle` is matched with a `StepDefinition` to create a `TestCase`
    ##
    class Pickle < Message
      ##
      # A unique id for the pickle
      ##
      attr_reader :id

      ##
      # The uri of the source file
      ##
      attr_reader :uri

      ##
      # The name of the pickle
      ##
      attr_reader :name

      ##
      # The language of the pickle
      ##
      attr_reader :language

      ##
      # One or more steps
      ##
      attr_reader :steps

      ##
      # One or more tags. If this pickle is constructed from a Gherkin document,
      # It includes inherited tags from the `Feature` as well.
      ##
      attr_reader :tags

      ##
      # Points to the AST node locations of the pickle. The last one represents the unique
      # id of the pickle. A pickle constructed from `Examples` will have the first
      # id originating from the `Scenario` AST node, and the second from the `TableRow` AST node.
      ##
      attr_reader :ast_node_ids

      def initialize(
        id: '',
        uri: '',
        name: '',
        language: '',
        steps: [],
        tags: [],
        ast_node_ids: []
      )
        @id = id
        @uri = uri
        @name = name
        @language = language
        @steps = steps
        @tags = tags
        @ast_node_ids = ast_node_ids
        super()
      end

      ##
      # Returns a new Pickle from the given hash.
      # If the hash keys are camelCased, they are properly assigned to the
      # corresponding snake_cased attributes.
      #
      #   Cucumber::Messages::Pickle.from_h(some_hash) # => #<Cucumber::Messages::Pickle:0x... ...>
      ##
      def self.from_h(hash)
        return nil if hash.nil?

        new(
          id: hash[:id],
          uri: hash[:uri],
          name: hash[:name],
          language: hash[:language],
          steps: hash[:steps]&.map { |item| PickleStep.from_h(item) },
          tags: hash[:tags]&.map { |item| PickleTag.from_h(item) },
          ast_node_ids: hash[:astNodeIds]
        )
      end
    end
  end
end
