/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.support;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.SpecialPermission;
import org.opensearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.common.util.IndexUtils;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.repositories.Repository;
import org.opensearch.repositories.RepositoryData;
import org.opensearch.security.OpenSearchSecurityPlugin;
import org.opensearch.snapshots.SnapshotId;
import org.opensearch.snapshots.SnapshotInfo;

public class SnapshotRestoreHelper {
    protected static final Logger log = LogManager.getLogger(SnapshotRestoreHelper.class);

    public static List<String> resolveOriginalIndices(RestoreSnapshotRequest restoreRequest) {
        SnapshotInfo snapshotInfo = SnapshotRestoreHelper.getSnapshotInfo(restoreRequest);
        if (snapshotInfo == null) {
            log.warn("snapshot repository '{}', snapshot '{}' not found", (Object)restoreRequest.repository(), (Object)restoreRequest.snapshot());
            return null;
        }
        return IndexUtils.filterIndices((List)snapshotInfo.indices(), (String[])restoreRequest.indices(), (IndicesOptions)restoreRequest.indicesOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SnapshotInfo getSnapshotInfo(RestoreSnapshotRequest restoreRequest) {
        RepositoriesService repositoriesService = Objects.requireNonNull(OpenSearchSecurityPlugin.GuiceHolder.getRepositoriesService(), "RepositoriesService not initialized");
        Repository repository = repositoriesService.repository(restoreRequest.repository());
        String threadName = Thread.currentThread().getName();
        SnapshotInfo snapshotInfo = null;
        try {
            SnapshotRestoreHelper.setCurrentThreadName("[generic]");
            for (SnapshotId snapshotId : ((RepositoryData)PlainActionFuture.get(arg_0 -> ((Repository)repository).getRepositoryData(arg_0))).getSnapshotIds()) {
                if (!snapshotId.getName().equals(restoreRequest.snapshot())) continue;
                if (log.isDebugEnabled()) {
                    log.debug("snapshot found: {} (UUID: {})", (Object)snapshotId.getName(), (Object)snapshotId.getUUID());
                }
                snapshotInfo = repository.getSnapshotInfo(snapshotId);
                break;
            }
        }
        finally {
            SnapshotRestoreHelper.setCurrentThreadName(threadName);
        }
        return snapshotInfo;
    }

    private static void setCurrentThreadName(final String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Thread.currentThread().setName(name);
                return null;
            }
        });
    }
}

