/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.actions.AbstractInstallAction;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.files.AbstractRecursiveFileAction;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import java.io.File;
import java.io.IOException;
import java.util.Date;

public class SetFiletimeAction
extends AbstractRecursiveFileAction {
    private Date time = new Date();
    private boolean recursive;

    public Date getTime() {
        return this.replaceWithTextOverride("time", this.time, Date.class);
    }

    public void setTime(Date time) {
        this.time = time;
    }

    @Override
    public boolean isRecursive() {
        return this.replaceWithTextOverride("recursive", this.recursive);
    }

    @Override
    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    @Override
    protected boolean executeForSingleRecursiveFile(Context context, File file, File relativeSourceFile, ProgressAdapter progressAdapter) throws UserCanceledException, IOException {
        if (!this.isSuppressRollback()) {
            this.addRollbackAction(new PerformedAction(file, file.lastModified()));
        }
        return file.setLastModified(this.getTime().getTime());
    }

    private static class PerformedAction
    extends AbstractInstallAction {
        private File file;
        private long previousTime;

        public PerformedAction(File file, long previousTime) {
            this.file = file;
            this.previousTime = previousTime;
        }

        @Override
        public boolean install(InstallerContext context) throws UserCanceledException {
            return false;
        }

        @Override
        public void rollback(InstallerContext context) {
            if (this.file.exists()) {
                this.file.setLastModified(this.previousTime);
            }
        }
    }
}

