/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.util.Calendar;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.ASReq;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KDCOptions;
import sun.security.krb5.internal.KDCReqBody;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.PAData;
import sun.security.krb5.internal.PAEncTSEnc;
import sun.security.krb5.internal.crypto.Nonce;

public class KrbAsReq {
    private ASReq asReqMessg;
    private boolean DEBUG = Krb5.DEBUG;

    public KrbAsReq(EncryptionKey pakey, KDCOptions options, PrincipalName cname, PrincipalName sname, KerberosTime from, KerberosTime till, KerberosTime rtime, int[] eTypes, HostAddresses addresses) throws KrbException, IOException {
        Calendar cal;
        String d;
        if (options == null) {
            options = new KDCOptions();
        }
        if (options.get(2) || options.get(4) || options.get(28) || options.get(30) || options.get(31)) {
            throw new KrbException(101);
        }
        if (!options.get(6) && from != null) {
            from = null;
        }
        PAData[] paData = null;
        if (pakey != null) {
            PAEncTSEnc ts = new PAEncTSEnc();
            byte[] temp = ts.asn1Encode();
            EncryptedData encTs = new EncryptedData(pakey, temp, 1);
            paData = new PAData[]{new PAData(2, encTs.asn1Encode())};
        }
        if (cname.getRealm() == null) {
            throw new RealmException(601, "default realm not specified ");
        }
        if (this.DEBUG) {
            System.out.println(">>> KrbAsReq creating message");
        }
        Config cfg = Config.getInstance();
        if (addresses == null && cfg.useAddresses()) {
            addresses = HostAddresses.getLocalAddresses();
        }
        if (sname == null) {
            String realm = cname.getRealmAsString();
            sname = PrincipalName.tgsService(realm, realm);
        }
        if (till == null) {
            d = cfg.get("libdefaults", "ticket_lifetime");
            if (d != null) {
                cal = Calendar.getInstance();
                cal.add(13, Config.duration(d));
                till = new KerberosTime(cal.getTime());
            } else {
                till = new KerberosTime(0L);
            }
        }
        if (rtime == null && (d = cfg.get("libdefaults", "renew_lifetime")) != null) {
            cal = Calendar.getInstance();
            cal.add(13, Config.duration(d));
            rtime = new KerberosTime(cal.getTime());
        }
        if (rtime != null) {
            options.set(8, true);
            if (till.greaterThan(rtime)) {
                rtime = till;
            }
        }
        KDCReqBody kdc_req_body = new KDCReqBody(options, cname, sname, from, till, rtime, Nonce.value(), eTypes, addresses, null, null);
        this.asReqMessg = new ASReq(paData, kdc_req_body);
    }

    byte[] encoding() throws IOException, Asn1Exception {
        return this.asReqMessg.asn1Encode();
    }

    ASReq getMessage() {
        return this.asReqMessg;
    }
}

