/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.HeapFloatBuffer;
import java.nio.ReadOnlyBufferException;

class HeapFloatBufferR
extends HeapFloatBuffer {
    HeapFloatBufferR(int cap, int lim) {
        super(cap, lim);
        this.isReadOnly = true;
    }

    HeapFloatBufferR(float[] buf, int off, int len) {
        super(buf, off, len);
        this.isReadOnly = true;
    }

    protected HeapFloatBufferR(float[] buf, int mark, int pos, int lim, int cap, int off) {
        super(buf, mark, pos, lim, cap, off);
        this.isReadOnly = true;
    }

    @Override
    public FloatBuffer slice() {
        int lim;
        int pos = this.position();
        int rem = pos <= (lim = this.limit()) ? lim - pos : 0;
        return new HeapFloatBufferR(this.hb, -1, 0, rem, rem, pos + this.offset);
    }

    @Override
    public FloatBuffer duplicate() {
        return new HeapFloatBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public FloatBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public FloatBuffer put(float x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public FloatBuffer put(int i, float x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public FloatBuffer put(float[] src, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public FloatBuffer put(FloatBuffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public FloatBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

