/*
 * Decompiled with CFR 0.152.
 */
package com.android.multidex;

import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.direct.StdAttributeFactory;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.ConstantPool;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeList;
import com.android.multidex.ArchivePathElement;
import com.android.multidex.ClassPathElement;
import com.android.multidex.FolderPathElement;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ClassReferenceListBuilder {
    private static final String CLASS_EXTENSION = ".class";
    private static final int STATUS_ERROR = 1;
    private static final String EOL = System.getProperty("line.separator");
    private static String USAGE_MESSAGE = "Usage:" + EOL + EOL + "Short version: Don't use this." + EOL + EOL + "Slightly longer version: This tool is used by mainDexClasses script to find direct" + EOL + "references of some classes." + EOL;
    private Path path;
    private Set<String> toKeep = new HashSet<String>();

    public ClassReferenceListBuilder(String inputPath) throws IOException {
        this(new Path(inputPath));
    }

    private ClassReferenceListBuilder(Path path) {
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ZipFile jarOfRoots;
        if (args.length != 2) {
            ClassReferenceListBuilder.printUsage();
            System.exit(1);
        }
        try {
            jarOfRoots = new ZipFile(args[0]);
        }
        catch (IOException e) {
            System.err.println("\"" + args[0] + "\" can not be read as a zip archive. (" + e.getMessage() + ")");
            System.exit(1);
            return;
        }
        Path path = null;
        try {
            path = new Path(args[1]);
            ClassReferenceListBuilder builder = new ClassReferenceListBuilder(path);
            builder.addRoots(jarOfRoots);
            ClassReferenceListBuilder.printList(builder.toKeep);
        }
        catch (IOException e) {
            System.err.println("A fatal error occured: " + e.getMessage());
            System.exit(1);
            return;
        }
        finally {
            try {
                jarOfRoots.close();
            }
            catch (IOException e) {}
            if (path != null) {
                for (ClassPathElement element : path.elements) {
                    try {
                        element.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    public void addRoots(ZipFile jarOfRoots) throws IOException {
        String name;
        ZipEntry entry;
        Enumeration<? extends ZipEntry> entries = jarOfRoots.entries();
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            name = entry.getName();
            if (!name.endsWith(CLASS_EXTENSION)) continue;
            this.toKeep.add(name.substring(0, name.length() - CLASS_EXTENSION.length()));
        }
        entries = jarOfRoots.entries();
        while (entries.hasMoreElements()) {
            DirectClassFile classFile;
            entry = entries.nextElement();
            name = entry.getName();
            if (!name.endsWith(CLASS_EXTENSION)) continue;
            try {
                classFile = this.path.getClass(name);
            }
            catch (FileNotFoundException e) {
                throw new IOException("Class " + name + " is missing form original class path " + this.path, e);
            }
            this.addDependencies(classFile.getConstantPool());
        }
    }

    public Set<String> getMainDexList() {
        HashSet<String> resultSet = new HashSet<String>(this.toKeep.size());
        for (String classDescriptor : this.toKeep) {
            resultSet.add(classDescriptor + CLASS_EXTENSION);
        }
        return resultSet;
    }

    private static void printUsage() {
        System.err.print(USAGE_MESSAGE);
    }

    private static ClassPathElement getClassPathElement(File file) throws ZipException, IOException {
        if (file.isDirectory()) {
            return new FolderPathElement(file);
        }
        if (file.isFile()) {
            return new ArchivePathElement(new ZipFile(file));
        }
        if (file.exists()) {
            throw new IOException(file.getAbsolutePath() + " is not a directory neither a zip file");
        }
        throw new FileNotFoundException(file.getAbsolutePath());
    }

    private static void printList(Set<String> toKeep) {
        for (String classDescriptor : toKeep) {
            System.out.print(classDescriptor);
            System.out.println(CLASS_EXTENSION);
        }
    }

    private void addDependencies(ConstantPool pool) {
        for (Constant constant : pool.getEntries()) {
            Type type;
            String descriptor;
            if (!(constant instanceof CstType) || !(descriptor = (type = ((CstType)constant).getClassType()).getDescriptor()).endsWith(";")) continue;
            int lastBrace = descriptor.lastIndexOf(91);
            if (lastBrace < 0) {
                this.addClassWithHierachy(descriptor.substring(1, descriptor.length() - 1));
                continue;
            }
            assert (descriptor.length() > lastBrace + 3 && descriptor.charAt(lastBrace + 1) == 'L');
            this.addClassWithHierachy(descriptor.substring(lastBrace + 2, descriptor.length() - 1));
        }
    }

    private void addClassWithHierachy(String classBinaryName) {
        if (this.toKeep.contains(classBinaryName)) {
            return;
        }
        String fileName = classBinaryName + CLASS_EXTENSION;
        try {
            DirectClassFile classFile = this.path.getClass(fileName);
            this.toKeep.add(classBinaryName);
            CstType superClass = classFile.getSuperclass();
            if (superClass != null) {
                this.addClassWithHierachy(superClass.getClassType().getClassName());
            }
            TypeList interfaceList = classFile.getInterfaces();
            int interfaceNumber = interfaceList.size();
            for (int i = 0; i < interfaceNumber; ++i) {
                this.addClassWithHierachy(interfaceList.getType(i).getClassName());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private static class Path {
        private List<ClassPathElement> elements = new ArrayList<ClassPathElement>();
        private String definition;
        private ByteArrayOutputStream baos = new ByteArrayOutputStream(40960);
        private byte[] readBuffer = new byte[20480];

        private Path(String definition) throws IOException {
            this.definition = definition;
            for (String filePath : definition.split(Pattern.quote(File.pathSeparator))) {
                try {
                    this.addElement(ClassReferenceListBuilder.getClassPathElement(new File(filePath)));
                }
                catch (IOException e) {
                    throw new IOException("\"" + filePath + "\" can not be used as a classpath" + " element. (" + e.getMessage() + ")", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static byte[] readStream(InputStream in, ByteArrayOutputStream baos, byte[] readBuffer) throws IOException {
            try {
                int amt;
                while ((amt = in.read(readBuffer)) >= 0) {
                    baos.write(readBuffer, 0, amt);
                }
            }
            finally {
                in.close();
            }
            return baos.toByteArray();
        }

        public String toString() {
            return this.definition;
        }

        private void addElement(ClassPathElement element) {
            assert (element != null);
            this.elements.add(element);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DirectClassFile getClass(String path) throws FileNotFoundException {
            DirectClassFile classFile = null;
            for (ClassPathElement element : this.elements) {
                try {
                    InputStream in = element.open(path);
                    try {
                        byte[] bytes = Path.readStream(in, this.baos, this.readBuffer);
                        this.baos.reset();
                        classFile = new DirectClassFile(bytes, path, false);
                        classFile.setAttributeFactory(StdAttributeFactory.THE_ONE);
                        break;
                    }
                    finally {
                        in.close();
                    }
                }
                catch (IOException e) {
                }
            }
            if (classFile == null) {
                throw new FileNotFoundException(path);
            }
            return classFile;
        }
    }
}

