/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.nodes;

import javax.swing.Icon;
import org.gephi.datalab.plugin.manipulators.nodes.BasicNodesManipulator;
import org.gephi.datalab.plugin.manipulators.nodes.ui.SetNodesSizeUI;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.graph.api.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class SetNodesSize
extends BasicNodesManipulator {
    private Node[] nodes;
    private float size = 1.0f;

    public void setup(Node[] nodes, Node clickedNode) {
        this.nodes = nodes;
        this.size = clickedNode.size();
    }

    public void execute() {
        for (Node node : this.nodes) {
            node.setSize(this.size);
        }
    }

    public String getName() {
        if (this.nodes.length > 1) {
            return NbBundle.getMessage(SetNodesSize.class, (String)"SetNodesSize.name.multiple");
        }
        return NbBundle.getMessage(SetNodesSize.class, (String)"SetNodesSize.name.single");
    }

    public String getDescription() {
        return "";
    }

    public boolean canExecute() {
        return true;
    }

    public ManipulatorUI getUI() {
        return new SetNodesSizeUI();
    }

    public int getType() {
        return 400;
    }

    public int getPosition() {
        return 2112;
    }

    public Icon getIcon() {
        return ImageUtilities.loadImageIcon((String)"DataLaboratoryPlugin/size.png", (boolean)false);
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float size) {
        this.size = size;
    }
}

