/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.adapters;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.protocol.SentryId;
import java.lang.reflect.Type;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SentryIdSerializerAdapter
implements JsonSerializer<SentryId> {
    @NotNull
    private final SentryOptions options;

    public SentryIdSerializerAdapter(@NotNull SentryOptions options) {
        this.options = options;
    }

    @Nullable
    public JsonElement serialize(@Nullable SentryId src, @NotNull Type typeOfSrc, @NotNull JsonSerializationContext context) {
        try {
            return src == null ? null : new JsonPrimitive(src.toString());
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error when serializing SentryId", e);
            return null;
        }
    }
}

