/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout;

import org.gephi.layout.LayoutModelImpl;
import org.gephi.layout.api.LayoutController;
import org.gephi.layout.spi.Layout;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceListener;
import org.gephi.project.spi.Controller;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class LayoutControllerImpl
implements LayoutController,
Controller<LayoutModelImpl> {
    private LayoutRun layoutRun;

    public LayoutControllerImpl() {
        ((ProjectController)Lookup.getDefault().lookup(ProjectController.class)).addWorkspaceListener(new WorkspaceListener(){

            public void initialize(Workspace workspace) {
            }

            public void select(Workspace workspace) {
            }

            public void unselect(Workspace workspace) {
                LayoutModelImpl model = LayoutControllerImpl.this.getModel(workspace);
                if (model != null && model.getSelectedLayout() != null) {
                    try {
                        model.saveProperties(model.getSelectedLayout());
                    }
                    catch (Exception e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                }
            }

            public void close(Workspace workspace) {
                LayoutModelImpl model = LayoutControllerImpl.this.getModel(workspace);
                if (model != null) {
                    model.getExecutor().cancel();
                }
            }

            public void disable() {
            }
        });
    }

    public Class<LayoutModelImpl> getModelClass() {
        return LayoutModelImpl.class;
    }

    public LayoutModelImpl newModel(Workspace workspace) {
        return new LayoutModelImpl(workspace);
    }

    @Override
    public LayoutModelImpl getModel(Workspace workspace) {
        return (LayoutModelImpl)super.getModel(workspace);
    }

    @Override
    public LayoutModelImpl getModel() {
        return (LayoutModelImpl)super.getModel();
    }

    @Override
    public void setLayout(Layout layout) {
        this.getModel().setSelectedLayout(layout);
    }

    @Override
    public void executeLayout() {
        LayoutModelImpl model = this.getModel();
        if (model.getSelectedLayout() != null) {
            this.layoutRun = new LayoutRun(model.getSelectedLayout());
            model.getExecutor().execute((LongTask)this.layoutRun, (Runnable)this.layoutRun);
            model.setRunning(true);
        }
    }

    @Override
    public void executeLayout(int numIterations) {
        LayoutModelImpl model = this.getModel();
        if (model.getSelectedLayout() != null) {
            this.layoutRun = new LayoutRun(model.getSelectedLayout(), numIterations);
            model.getExecutor().execute((LongTask)this.layoutRun, (Runnable)this.layoutRun);
            model.setRunning(true);
        }
    }

    @Override
    public boolean canExecute() {
        LayoutModelImpl model = this.getModel();
        return model.getSelectedLayout() != null && !model.isRunning();
    }

    @Override
    public boolean canStop() {
        LayoutModelImpl model = this.getModel();
        return model.isRunning();
    }

    @Override
    public void stopLayout() {
        LayoutModelImpl model = this.getModel();
        model.getExecutor().cancel();
    }

    private static class LayoutRun
    implements LongTask,
    Runnable {
        private final Layout layout;
        private final Integer iterations;
        private boolean stopRun = false;
        private ProgressTicket progressTicket;

        public LayoutRun(Layout layout) {
            this.layout = layout;
            this.iterations = null;
        }

        public LayoutRun(Layout layout, int numIterations) {
            this.layout = layout;
            this.iterations = numIterations;
        }

        @Override
        public void run() {
            Progress.setDisplayName((ProgressTicket)this.progressTicket, (String)this.layout.getBuilder().getName());
            Progress.start((ProgressTicket)this.progressTicket);
            this.layout.initAlgo();
            long i = 0L;
            while (this.layout.canAlgo() && !this.stopRun) {
                this.layout.goAlgo();
                if (this.iterations == null || this.iterations.longValue() != ++i) continue;
            }
            this.layout.endAlgo();
            if (i > 1L) {
                Progress.finish((ProgressTicket)this.progressTicket, (String)NbBundle.getMessage(LayoutControllerImpl.class, (String)"LayoutRun.end", (Object)this.layout.getBuilder().getName(), (Object)i));
            } else {
                Progress.finish((ProgressTicket)this.progressTicket);
            }
        }

        public boolean cancel() {
            this.stopRun = true;
            if (this.layout instanceof LongTask) {
                return ((LongTask)this.layout).cancel();
            }
            return false;
        }

        public void setProgressTicket(ProgressTicket progressTicket) {
            this.progressTicket = progressTicket;
            if (this.layout instanceof LongTask) {
                ((LongTask)this.layout).setProgressTicket(progressTicket);
            }
        }
    }
}

