/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.cycle_detection;

import com.tngtech.archunit.base.ForwardingCollection;
import com.tngtech.archunit.library.cycle_detection.Cycle;
import com.tngtech.archunit.library.cycle_detection.CycleInternal;
import com.tngtech.archunit.library.cycle_detection.Cycles;
import com.tngtech.archunit.library.cycle_detection.Edge;
import com.tngtech.archunit.library.cycle_detection.JohnsonCycleFinder;
import com.tngtech.archunit.library.cycle_detection.PrimitiveGraph;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ArrayListMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableMap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ListMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class Graph<NODE, EDGE extends Edge<NODE>> {
    private final Map<NODE, Integer> nodes = new HashMap<NODE, Integer>();
    private final ListMultimap<Integer, EDGE> outgoingEdges = ArrayListMultimap.create();

    Graph() {
    }

    void addNodes(Collection<NODE> nodes) {
        for (NODE node : nodes) {
            if (this.nodes.containsKey(node)) continue;
            this.nodes.put(node, this.nodes.size());
        }
    }

    void addEdges(Iterable<EDGE> outgoingEdges) {
        for (Edge edge : outgoingEdges) {
            Preconditions.checkArgument(this.nodes.containsKey(edge.getOrigin()), "Node %s of edge %s is not part of the graph", edge.getOrigin(), (Object)edge);
            Preconditions.checkArgument(this.nodes.containsKey(edge.getTarget()), "Node %s of edge %s is not part of the graph", edge.getTarget(), (Object)edge);
            this.outgoingEdges.put(this.nodes.get(edge.getOrigin()), edge);
        }
    }

    Cycles<EDGE> findCycles() {
        JohnsonCycleFinder johnsonCycleFinder = new JohnsonCycleFinder(this.createPrimitiveGraph());
        JohnsonCycleFinder.Result rawCycles = johnsonCycleFinder.findCycles();
        return new CyclesInternal(this.mapToCycles(rawCycles), rawCycles.maxNumberOfCyclesReached());
    }

    private PrimitiveGraph createPrimitiveGraph() {
        int[][] edges = new int[this.nodes.size()][];
        for (Map.Entry<NODE, Integer> nodeToIndex : this.nodes.entrySet()) {
            Collection outgoing = this.outgoingEdges.get((Object)nodeToIndex.getValue());
            edges[nodeToIndex.getValue().intValue()] = new int[outgoing.size()];
            for (int j = 0; j < outgoing.size(); ++j) {
                edges[nodeToIndex.getValue().intValue()][j] = this.nodes.get(((Edge)outgoing.get(j)).getTarget());
            }
        }
        return new PrimitiveGraph(edges);
    }

    private ImmutableList<Cycle<EDGE>> mapToCycles(JohnsonCycleFinder.Result rawCycles) {
        ImmutableMap<Integer, Map<Integer, EDGE>> edgesByTargetIndexByOriginIndex = this.indexEdgesByTargetIndexByOriginIndex(this.nodes, this.outgoingEdges);
        ImmutableList.Builder result = ImmutableList.builder();
        for (int[] rawCycle : rawCycles) {
            result.add(this.mapToCycle(edgesByTargetIndexByOriginIndex, rawCycle));
        }
        return result.build();
    }

    private ImmutableMap<Integer, Map<Integer, EDGE>> indexEdgesByTargetIndexByOriginIndex(Map<NODE, Integer> nodes, Multimap<Integer, EDGE> outgoingEdges) {
        ImmutableMap.Builder edgeMapBuilder = ImmutableMap.builder();
        for (Map.Entry<Integer, Collection<EDGE>> originIndexToEdges : outgoingEdges.asMap().entrySet()) {
            ImmutableMap.Builder<Integer, Edge> targetIndexToEdges = ImmutableMap.builder();
            for (Edge edge : originIndexToEdges.getValue()) {
                targetIndexToEdges.put(nodes.get(edge.getTarget()), edge);
            }
            edgeMapBuilder.put(originIndexToEdges.getKey(), targetIndexToEdges.build());
        }
        return edgeMapBuilder.build();
    }

    private Cycle<EDGE> mapToCycle(Map<Integer, Map<Integer, EDGE>> edgesByTargetIndexByOriginIndex, int[] rawCycle) {
        ImmutableList.Builder edges = ImmutableList.builder();
        int originIndex = -1;
        for (int targetIndex : rawCycle) {
            if (originIndex >= 0) {
                edges.add((Edge)edgesByTargetIndexByOriginIndex.get(originIndex).get(targetIndex));
            }
            originIndex = targetIndex;
        }
        edges.add((Edge)edgesByTargetIndexByOriginIndex.get(originIndex).get(rawCycle[0]));
        return new CycleInternal(edges.build());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{nodes=" + this.nodes + ", edges=" + this.outgoingEdges + '}';
    }

    private static class CyclesInternal<EDGE extends Edge<?>>
    extends ForwardingCollection<Cycle<EDGE>>
    implements Cycles<EDGE> {
        private final Collection<Cycle<EDGE>> cycles;
        private final boolean maxNumberOfCyclesReached;

        private CyclesInternal(Collection<Cycle<EDGE>> cycles, boolean maxNumberOfCyclesReached) {
            this.cycles = cycles;
            this.maxNumberOfCyclesReached = maxNumberOfCyclesReached;
        }

        @Override
        public boolean maxNumberOfCyclesReached() {
            return this.maxNumberOfCyclesReached;
        }

        @Override
        protected Collection<Cycle<EDGE>> delegate() {
            return this.cycles;
        }
    }
}

