/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain.properties;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ChainableFunction;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.properties.HasName;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public interface HasReturnType {
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaType getReturnType();

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getRawReturnType();

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Functions {
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<HasReturnType, JavaType> GET_RETURN_TYPE = new ChainableFunction<HasReturnType, JavaType>(){

            @Override
            public JavaType apply(HasReturnType input) {
                return input.getReturnType();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<HasReturnType, JavaClass> GET_RAW_RETURN_TYPE = new ChainableFunction<HasReturnType, JavaClass>(){

            @Override
            public JavaClass apply(HasReturnType input) {
                return input.getRawReturnType();
            }
        };

        private Functions() {
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Predicates {
        private Predicates() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<HasReturnType> rawReturnType(Class<?> returnType) {
            return Predicates.rawReturnType(returnType.getName());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<HasReturnType> rawReturnType(String returnTypeName) {
            return Predicates.rawReturnType(HasName.Predicates.name(returnTypeName).as(returnTypeName, new Object[0]));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<HasReturnType> rawReturnType(DescribedPredicate<? super JavaClass> predicate) {
            return predicate.onResultOf(Functions.GET_RAW_RETURN_TYPE).as("raw return type %s", predicate.getDescription());
        }
    }
}

