/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.attribute;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.url.UrlManager;
import org.freeplane.features.url.mindmapmode.MFileManager;
import org.freeplane.view.swing.map.attribute.AttributeTable;
import org.freeplane.view.swing.map.attribute.AttributeTableModel;
import org.freeplane.view.swing.ui.mindmapmode.INodeSelector;
import org.freeplane.view.swing.ui.mindmapmode.NodeSelector;

class AttributePopupMenu
extends JPopupMenu
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private JMenuItem delete = null;
    private JMenuItem down = null;
    private JMenuItem insert = null;
    private JMenuItem insertFileLink = null;
    private boolean oldTable;
    private JMenuItem optimalWidth = null;
    private int row;
    private AttributeTable table;
    private JMenuItem up = null;
    private int col;
    private JMenuItem insertLink;
    private JMenuItem insertNodeLink;
    private JMenuItem insertAnchoredLink;

    AttributePopupMenu() {
    }

    @Override
    protected void firePopupMenuWillBecomeInvisible() {
        if (this.row != -1) {
            this.table.removeRowSelectionInterval(this.row, this.row);
        }
        this.oldTable = true;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!AttributePopupMenu.this.oldTable) {
                    return;
                }
                KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                Container focusOwner = SwingUtilities.getAncestorOfClass(AttributeTable.class, focusManager.getFocusOwner());
                if (AttributePopupMenu.this.table != focusOwner && focusOwner instanceof JComponent) {
                    AttributePopupMenu.this.table.requestFocus(true);
                    ((JComponent)focusOwner).requestFocusInWindow();
                }
                AttributePopupMenu.this.table = null;
            }
        });
    }

    @Override
    protected void firePopupMenuWillBecomeVisible() {
        super.firePopupMenuWillBecomeVisible();
        if (this.row != -1) {
            this.table.addRowSelectionInterval(this.row, this.row);
        }
    }

    private JMenuItem getDelete() {
        if (this.delete == null) {
            this.delete = new JMenuItem(TextUtils.getText("attributes_popup_delete"));
            this.delete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!AttributePopupMenu.this.table.getAttributeTableModel().getAttribute(AttributePopupMenu.this.row).isManaged()) {
                        AttributePopupMenu.this.table.removeRow(AttributePopupMenu.this.row);
                    }
                }
            });
        }
        return this.delete;
    }

    private JMenuItem getDown() {
        if (this.down == null) {
            this.down = new JMenuItem(TextUtils.getText("attributes_popup_down"));
            this.down.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributeTableModel attributeTableModel = AttributePopupMenu.this.table.getAttributeTableModel();
                    if (AttributePopupMenu.this.row < AttributePopupMenu.this.table.getRowCount() - 1 && !attributeTableModel.getAttribute(AttributePopupMenu.this.row).isManaged() && !attributeTableModel.getAttribute(AttributePopupMenu.this.row + 1).isManaged()) {
                        AttributePopupMenu.this.table.moveRowDown(AttributePopupMenu.this.row);
                    }
                }
            });
        }
        return this.down;
    }

    private JMenuItem getInsert() {
        if (this.insert == null) {
            this.insert = new JMenuItem(TextUtils.getText("attributes_popup_new"));
            this.insert.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributePopupMenu.this.table.insertRow(AttributePopupMenu.this.row + 1);
                }
            });
        }
        return this.insert;
    }

    private JMenuItem getInsertFileLink() {
        if (this.insertFileLink == null) {
            this.insertFileLink = new JMenuItem(TextUtils.getText("SetLinkByFileChooserAction.text"));
            this.insertFileLink.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributeTable table = AttributePopupMenu.this.table;
                    URI relative = ((MFileManager)UrlManager.getController()).getLinkByFileChooser(Controller.getCurrentController().getMap());
                    if (relative != null) {
                        table.setValueAt(relative, AttributePopupMenu.this.row, AttributePopupMenu.this.col);
                    }
                }
            });
        }
        return this.insertFileLink;
    }

    private JMenuItem getInsertLink() {
        if (this.insertLink == null) {
            this.insertLink = new JMenuItem(TextUtils.getText("SetLinkByTextFieldAction.text"));
            this.insertLink.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributeTable table = AttributePopupMenu.this.table;
                    Object oldValue = table.getValueAt(AttributePopupMenu.this.row, AttributePopupMenu.this.col);
                    String inputValue = JOptionPane.showInputDialog(table, TextUtils.getText("edit_link_manually"), oldValue.toString());
                    if (inputValue != null && (oldValue instanceof String || !oldValue.equals(inputValue))) {
                        if (inputValue.toString().equals("")) {
                            table.setValueAt("", AttributePopupMenu.this.row, AttributePopupMenu.this.col);
                        }
                        try {
                            Hyperlink link = LinkController.createHyperlink(inputValue.trim());
                            if (!oldValue.equals(link)) {
                                table.setValueAt(link, AttributePopupMenu.this.row, AttributePopupMenu.this.col);
                            }
                        }
                        catch (URISyntaxException e1) {
                            LogUtils.warn(e1);
                            UITools.errorMessage(TextUtils.format("invalid_uri", inputValue));
                            return;
                        }
                    }
                }
            });
        }
        return this.insertLink;
    }

    private JMenuItem getInsertNodeLink() {
        if (this.insertNodeLink == null) {
            this.insertNodeLink = new JMenuItem(TextUtils.getText("SetNodeLink.text"));
            this.insertNodeLink.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final AttributeTable table = AttributePopupMenu.this.table;
                    final Object oldValue = table.getValueAt(AttributePopupMenu.this.row, AttributePopupMenu.this.col);
                    NodeSelector nodeSelector = new NodeSelector();
                    nodeSelector.show((Component)table, new INodeSelector(){

                        public void nodeSelected(NodeModel node) {
                            if (node == null) {
                                return;
                            }
                            String inputValue = "#" + node.getID();
                            try {
                                Hyperlink link = LinkController.createHyperlink(inputValue);
                                if (!oldValue.equals(link)) {
                                    table.setValueAt(link, AttributePopupMenu.this.row, AttributePopupMenu.this.col);
                                }
                            }
                            catch (URISyntaxException e1) {
                                LogUtils.severe(e1);
                                return;
                            }
                        }
                    });
                }
            });
        }
        return this.insertNodeLink;
    }

    private JMenuItem getInsertAnchoredLink() {
        if (this.insertAnchoredLink == null) {
            this.insertAnchoredLink = new JMenuItem(TextUtils.getText("MakeLinkToAnchorAction.text"));
            this.insertAnchoredLink.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MLinkController mLinkController;
                    AttributeTable table = AttributePopupMenu.this.table;
                    Object oldValue = table.getValueAt(AttributePopupMenu.this.row, AttributePopupMenu.this.col);
                    LinkController linkController = LinkController.getController();
                    if (linkController instanceof MLinkController && (mLinkController = (MLinkController)linkController).isAnchored()) {
                        try {
                            Hyperlink link;
                            String anchorIDforNode = mLinkController.getAnchorIDforNode(((AttributeTableModel)table.getModel()).getNode());
                            if (anchorIDforNode != null && !oldValue.equals(link = LinkController.createHyperlink(anchorIDforNode))) {
                                table.setValueAt(link, AttributePopupMenu.this.row, AttributePopupMenu.this.col);
                            }
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        return this.insertAnchoredLink;
    }

    private JMenuItem getOptimalWidth() {
        if (this.optimalWidth == null) {
            this.optimalWidth = new JMenuItem(TextUtils.getText("attributes_popup_optimal_width"));
            this.optimalWidth.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributePopupMenu.this.table.setOptimalColumnWidths();
                }
            });
        }
        return this.optimalWidth;
    }

    public AttributeTable getTable() {
        return this.table;
    }

    private JMenuItem getUp() {
        if (this.up == null) {
            this.up = new JMenuItem(TextUtils.getText("attributes_popup_up"));
            this.up.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributeTableModel attributeTableModel = AttributePopupMenu.this.table.getAttributeTableModel();
                    if (AttributePopupMenu.this.row >= 1 && !attributeTableModel.getAttribute(AttributePopupMenu.this.row).isManaged() && !attributeTableModel.getAttribute(AttributePopupMenu.this.row - 1).isManaged()) {
                        AttributePopupMenu.this.table.moveRowUp(AttributePopupMenu.this.row);
                    }
                }
            });
        }
        return this.up;
    }

    private void make() {
        String attributeViewType = this.table.getAttributeView().getViewType();
        AttributeTableModel model = this.table.getAttributeTableModel();
        int rowCount = model.getRowCount();
        this.add(this.getOptimalWidth());
        if (this.col == 1) {
            this.add(this.getInsertLink());
            this.add(this.getInsertFileLink());
            this.add(this.getInsertNodeLink());
            LinkController linkController = LinkController.getController();
            if (linkController instanceof MLinkController && ((MLinkController)linkController).isAnchored()) {
                this.add(this.getInsertAnchoredLink());
            }
        }
        if (attributeViewType.equals("extended")) {
            this.add(this.getInsert());
            if (this.row != -1) {
                this.add(this.getDelete());
                if (this.row != 0) {
                    this.add(this.getUp());
                }
                if (this.row != rowCount - 1) {
                    this.add(this.getDown());
                }
            }
        }
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.selectTable(e.getComponent(), e.getPoint());
            if (this.table.isEditing()) {
                return;
            }
            this.table.requestFocusInWindow();
            this.make();
            this.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    private void selectTable(Component component, Point point) throws AssertionError {
        int componentCount;
        int i = componentCount = this.getComponentCount();
        while (i > 0) {
            this.remove(--i);
        }
        if (component instanceof AttributeTable) {
            this.table = (AttributeTable)component;
            if (this.table.isEditing()) {
                return;
            }
            this.oldTable = false;
            this.row = this.table.rowAtPoint(point);
            this.col = this.table.columnAtPoint(point);
            if (this.row >= 0 && this.table.getValueAt(this.row, 0).equals("")) {
                --this.row;
            }
            if (this.row >= 0) {
                this.table.changeSelection(this.row, this.table.columnAtPoint(point), false, false);
            }
            return;
        }
        if (component instanceof JTableHeader) {
            JTableHeader header = (JTableHeader)component;
            this.table = (AttributeTable)header.getTable();
            if (this.table.isEditing()) {
                return;
            }
            this.oldTable = false;
            this.row = -1;
            this.col = -1;
            return;
        }
        throw new AssertionError();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            return;
        }
        this.table.requestFocusInWindow();
    }
}

