/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.StringMatchingStrategy;
import org.freeplane.features.link.ConnectorLabelCondition;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.LinkController;

public class ConnectorLabelEqualsCondition
extends ConnectorLabelCondition {
    public static final String NAME = "connector_label_equals";

    public ConnectorLabelEqualsCondition(String text, boolean matchCase, boolean matchApproximately, boolean ignoreDiacritics) {
        super(text, matchCase, matchApproximately, false, ignoreDiacritics);
    }

    @Override
    public boolean check(ConnectorModel connector) {
        LinkController linkController = LinkController.getController();
        String middleLabel = linkController.getMiddleLabel(connector);
        if (this.equals(middleLabel)) {
            return true;
        }
        String sourceLabel = linkController.getSourceLabel(connector);
        if (this.equals(sourceLabel)) {
            return true;
        }
        String targetLabel = linkController.getTargetLabel(connector);
        return this.equals(targetLabel);
    }

    private boolean equals(String middleLabel) {
        if (middleLabel == null) {
            return false;
        }
        return this.getStringMatchingStrategy().matches(this.normalizedValue(), this.normalize(middleLabel), StringMatchingStrategy.Type.ALL);
    }

    @Override
    protected String createDescription() {
        String condition = TextUtils.getText("connector_label");
        String simpleCondition = TextUtils.getText("filter_is_equal_to");
        return this.createDescription(condition, simpleCondition, this.getText());
    }

    @Override
    protected String getName() {
        return NAME;
    }
}

