"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const extend_1 = __importDefault(require("../lib/extend"));
const definitions = [
    {
        zigbeeModel: ['1001248', 'ZBT-ColorTemperature-Panel'],
        model: '1001248',
        vendor: 'SLV',
        description: 'VALETO CCT LED driver',
        extend: extend_1.default.light_onoff_brightness_colortemp({ colorTempRange: [153, 370] }),
    },
    {
        zigbeeModel: ['1002994'],
        model: '1002994',
        vendor: 'SLV',
        description: 'VALETO remote (binds to device)',
        fromZigbee: [],
        toZigbee: [],
        exposes: [],
    },
    {
        zigbeeModel: ['ZBT-RGBWLight-AR0844'],
        model: '1001923',
        vendor: 'SLV',
        description: 'VALETO LED GU10 RGBW',
        extend: extend_1.default.light_onoff_brightness_colortemp_color({ colorTempRange: [153, 556] }),
    },
    {
        zigbeeModel: ['1005318'],
        model: '1005318',
        vendor: 'SLV',
        description: 'VALETO LED E27 RGBW',
        extend: extend_1.default.light_onoff_brightness_colortemp_color({ colorTempRange: [153, 555] }),
    },
];
module.exports = definitions;
//# sourceMappingURL=slv.js.map