/*
 * Decompiled with CFR 0.152.
 */
package vtk;

import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import vtk.vtkJavaGarbageCollector;
import vtk.vtkObjectBase;
import vtk.vtkRenderWindow;
import vtk.vtkSettings;
import vtk.vtkTesting;

public class vtkJavaTesting {
    public static final int FAILED = 0;
    public static final int PASSED = 1;
    public static final int NOT_RUN = 2;
    public static final int DO_INTERACTOR = 3;
    private static vtkTesting Tester = null;

    private static int LoadLib(String string, boolean bl) {
        try {
            if (bl) {
                System.out.println("Try to load: " + string);
            }
            if (!new File(string).exists() && bl) {
                System.out.println("File does not exist: " + string);
                return 0;
            }
            Runtime.getRuntime().load(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (bl) {
                System.out.println("Failed to load: " + string);
                unsatisfiedLinkError.printStackTrace();
            }
            return 0;
        }
        if (bl) {
            System.out.println("Successfully loaded: " + string);
        }
        return 1;
    }

    private static void LoadLibrary(String string, String string2, boolean bl) {
        String string3 = System.mapLibraryName(string2);
        String string4 = System.getProperty("file.separator");
        String string5 = string + string4 + string3;
        String string6 = string + string4 + "Release" + string4 + string3;
        String string7 = string + string4 + "Debug" + string4 + string3;
        if (vtkJavaTesting.LoadLib(string2, bl) != 1 && vtkJavaTesting.LoadLib(string5, bl) != 1 && vtkJavaTesting.LoadLib(string6, bl) != 1 && vtkJavaTesting.LoadLib(string7, bl) != 1) {
            System.out.println("Problem loading appropriate library");
        }
    }

    public static void Initialize(String[] stringArray) {
        vtkJavaTesting.Initialize(stringArray, false);
    }

    public static void Initialize(String[] stringArray, boolean bl) {
        int n;
        Object object;
        String string = vtkSettings.GetVTKLibraryDir();
        if (string != null) {
            object = System.getProperty("path.separator");
            String string2 = System.getProperty("java.library.path");
            string2 = string2 + (String)object + string;
            System.setProperty("java.library.path", string2);
        }
        object = vtkSettings.GetKits();
        for (n = 0; n < ((String[])object).length; ++n) {
            vtkJavaTesting.LoadLibrary(string, object[n] + "Java", bl);
        }
        Tester = new vtkTesting();
        for (n = 0; n < stringArray.length; ++n) {
            Tester.AddArgument(stringArray[n]);
        }
    }

    public static boolean IsInteractive() {
        return Tester.IsInteractiveModeSpecified() != 0;
    }

    public static void Exit(int n) {
        Tester = null;
        System.gc();
        vtkObjectBase.JAVA_OBJECT_MANAGER.gc(true);
        if (n == 0 || n == 2) {
            System.out.println("Test failed or was not run");
            System.exit(1);
        }
        System.out.println("Test passed");
        System.exit(0);
    }

    public static int RegressionTest(vtkRenderWindow vtkRenderWindow2, int n) {
        Tester.SetRenderWindow(vtkRenderWindow2);
        if (Tester.RegressionTest(n) == 1) {
            return 1;
        }
        System.out.println("Image difference: " + Tester.GetImageDifference());
        return 0;
    }

    public static void StartTimeoutExit(long l, TimeUnit timeUnit) {
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                System.exit(0);
            }
        };
        scheduledExecutorService.schedule(runnable, l, timeUnit);
    }

    public static vtkJavaGarbageCollector StartGCInEDT(long l, TimeUnit timeUnit) {
        vtkJavaGarbageCollector vtkJavaGarbageCollector2 = vtkObjectBase.JAVA_OBJECT_MANAGER.getAutoGarbageCollector();
        vtkJavaGarbageCollector2.SetScheduleTime(l, timeUnit);
        vtkJavaGarbageCollector2.SetAutoGarbageCollection(true);
        return vtkJavaGarbageCollector2;
    }
}

