/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator.jaspic;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.config.ServerAuthConfig;
import jakarta.security.auth.message.config.ServerAuthContext;
import jakarta.security.auth.message.module.ServerAuthModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.apache.catalina.authenticator.jaspic.SimpleServerAuthContext;
import org.apache.tomcat.util.res.StringManager;

public class SimpleServerAuthConfig
implements ServerAuthConfig {
    private static StringManager sm = StringManager.getManager(SimpleServerAuthConfig.class);
    private static final String SERVER_AUTH_MODULE_KEY_PREFIX = "org.apache.catalina.authenticator.jaspic.ServerAuthModule.";
    private final String layer;
    private final String appContext;
    private final CallbackHandler handler;
    private final Map<String, Object> properties;
    private volatile ServerAuthContext serverAuthContext;

    public SimpleServerAuthConfig(String string, String string2, CallbackHandler callbackHandler, Map<String, Object> map) {
        this.layer = string;
        this.appContext = string2;
        this.handler = callbackHandler;
        this.properties = map;
    }

    public String getMessageLayer() {
        return this.layer;
    }

    public String getAppContext() {
        return this.appContext;
    }

    public String getAuthContextID(MessageInfo messageInfo) {
        return messageInfo.toString();
    }

    public void refresh() {
        this.serverAuthContext = null;
    }

    public boolean isProtected() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerAuthContext getAuthContext(String string, Subject subject, Map<String, Object> map) throws AuthException {
        ServerAuthContext serverAuthContext = this.serverAuthContext;
        if (serverAuthContext == null) {
            SimpleServerAuthConfig simpleServerAuthConfig = this;
            synchronized (simpleServerAuthConfig) {
                if (this.serverAuthContext == null) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    if (this.properties != null) {
                        hashMap.putAll(this.properties);
                    }
                    if (map != null) {
                        hashMap.putAll(map);
                    }
                    ArrayList<ServerAuthModule> arrayList = new ArrayList<ServerAuthModule>();
                    int n = 1;
                    String string2 = SERVER_AUTH_MODULE_KEY_PREFIX + n;
                    Object v = hashMap.get(string2);
                    while (v instanceof String) {
                        AuthException authException;
                        try {
                            Class<?> clazz = Class.forName((String)v);
                            authException = (ServerAuthModule)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                            authException.initialize(null, null, this.handler, hashMap);
                            arrayList.add((ServerAuthModule)authException);
                        }
                        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException exception) {
                            authException = new AuthException();
                            authException.initCause((Throwable)exception);
                            throw authException;
                        }
                        string2 = SERVER_AUTH_MODULE_KEY_PREFIX + ++n;
                        v = hashMap.get(string2);
                    }
                    if (arrayList.size() == 0) {
                        throw new AuthException(sm.getString("simpleServerAuthConfig.noModules"));
                    }
                    this.serverAuthContext = this.createServerAuthContext(arrayList);
                }
                serverAuthContext = this.serverAuthContext;
            }
        }
        return serverAuthContext;
    }

    protected ServerAuthContext createServerAuthContext(List<ServerAuthModule> list) {
        return new SimpleServerAuthContext(list);
    }
}

