/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.io;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.luaj.vm2.internal.ToolsKt;
import org.luaj.vm2.io.LuaBinOutput;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0006\u0010\u0012\u001a\u00020\u0003J\u0006\u0010\u0013\u001a\u00020\u0006J\b\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0003H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\f\"\u0004\b\u000f\u0010\u0004\u00a8\u0006\u001a"}, d2={"Lorg/luaj/vm2/io/ByteArrayLuaBinOutput;", "Lorg/luaj/vm2/io/LuaBinOutput;", "initialCapacity", "", "(I)V", "buf", "", "getBuf", "()[B", "setBuf", "([B)V", "getInitialCapacity", "()I", "pos", "getPos", "setPos", "ensure", "", "size", "toByteArray", "toString", "", "write", "b", "i", "value", "luak"})
public class ByteArrayLuaBinOutput
extends LuaBinOutput {
    private final int initialCapacity;
    private int pos;
    @NotNull
    private byte[] buf;

    public ByteArrayLuaBinOutput(int initialCapacity) {
        this.initialCapacity = initialCapacity;
        this.buf = new byte[this.initialCapacity];
    }

    public /* synthetic */ ByteArrayLuaBinOutput(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 64;
        }
        this(n);
    }

    public final int getInitialCapacity() {
        return this.initialCapacity;
    }

    public final int getPos() {
        return this.pos;
    }

    public final void setPos(int n) {
        this.pos = n;
    }

    @NotNull
    public final byte[] getBuf() {
        return this.buf;
    }

    public final void setBuf(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "<set-?>");
        this.buf = byArray;
    }

    private final void ensure(int size2) {
        if (this.pos + size2 >= this.buf.length) {
            byte[] byArray = Arrays.copyOf(this.buf, Math.max(this.buf.length * 2 + 1, this.pos + size2 + 7));
            Intrinsics.checkNotNullExpressionValue(byArray, "copyOf(this, newSize)");
            this.buf = byArray;
        }
    }

    @Override
    public void write(int value) {
        this.ensure(1);
        int n = this.pos;
        this.pos = n + 1;
        this.buf[n] = (byte)value;
    }

    @Override
    public void write(@NotNull byte[] b, int i, int size2) {
        Intrinsics.checkNotNullParameter(b, "b");
        this.ensure(size2);
        ToolsKt.arraycopy(b, i, this.buf, this.pos, size2);
        this.pos += size2;
    }

    public final int size() {
        return this.pos;
    }

    @NotNull
    public final byte[] toByteArray() {
        byte[] byArray = Arrays.copyOf(this.buf, this.pos);
        Intrinsics.checkNotNullExpressionValue(byArray, "copyOf(this, newSize)");
        return byArray;
    }

    @NotNull
    public String toString() {
        String string = Arrays.toString(this.toByteArray());
        Intrinsics.checkNotNullExpressionValue(string, "toString(this)");
        return string;
    }

    public ByteArrayLuaBinOutput() {
        this(0, 1, null);
    }
}

