/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.AppearanceRetained;
import javax.media.j3d.CompileState;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.ShaderAttributeSet;
import javax.media.j3d.ShaderAttributeSetRetained;
import javax.media.j3d.ShaderProgram;
import javax.media.j3d.ShaderProgramRetained;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.VirtualUniverse;

class ShaderAppearanceRetained
extends AppearanceRetained {
    static final int SHADER_PROGRAM = 2048;
    static final int SHADER_ATTRIBUTE_SET = 4096;
    protected ShaderProgramRetained shaderProgram = null;
    protected ShaderAttributeSetRetained shaderAttributeSet = null;
    protected boolean isMirror = false;

    ShaderAppearanceRetained() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setShaderProgram(ShaderProgram shaderProgram) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                if (this.shaderProgram != null) {
                    this.shaderProgram.clearLive(this.refCount);
                    this.shaderProgram.removeMirrorUsers(this);
                }
                if (shaderProgram != null) {
                    ((ShaderProgramRetained)shaderProgram.retained).setLive(this.inBackgroundGroup, this.refCount);
                    ((ShaderProgramRetained)shaderProgram.retained).copyMirrorUsers(this);
                }
                this.sendMessage(2048, shaderProgram != null ? ((ShaderProgramRetained)shaderProgram.retained).mirror : null);
            }
            this.shaderProgram = shaderProgram == null ? null : (ShaderProgramRetained)shaderProgram.retained;
        }
    }

    ShaderProgram getShaderProgram() {
        return this.shaderProgram == null ? null : (ShaderProgram)this.shaderProgram.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setShaderAttributeSet(ShaderAttributeSet shaderAttributeSet) {
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                if (this.shaderAttributeSet != null) {
                    this.shaderAttributeSet.clearLive(this.refCount);
                    this.shaderAttributeSet.removeMirrorUsers(this);
                }
                if (shaderAttributeSet != null) {
                    ((ShaderAttributeSetRetained)shaderAttributeSet.retained).setLive(this.inBackgroundGroup, this.refCount);
                    ((ShaderAttributeSetRetained)shaderAttributeSet.retained).copyMirrorUsers(this);
                }
                this.sendMessage(4096, shaderAttributeSet != null ? ((ShaderAttributeSetRetained)shaderAttributeSet.retained).mirror : null);
            }
            this.shaderAttributeSet = shaderAttributeSet == null ? null : (ShaderAttributeSetRetained)shaderAttributeSet.retained;
        }
    }

    ShaderAttributeSet getShaderAttributeSet() {
        return this.shaderAttributeSet == null ? null : (ShaderAttributeSet)this.shaderAttributeSet.source;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ShaderAppearanceRetained && this.equals((ShaderAppearanceRetained)object);
    }

    boolean equals(ShaderAppearanceRetained shaderAppearanceRetained) {
        boolean bl;
        boolean bl2 = bl = shaderAppearanceRetained == this;
        if (bl) {
            return bl;
        }
        boolean bl3 = bl = shaderAppearanceRetained != null && this.shaderProgram == shaderAppearanceRetained.shaderProgram && this.shaderAttributeSet == shaderAppearanceRetained.shaderAttributeSet;
        if (!bl) {
            return bl;
        }
        return super.equals(shaderAppearanceRetained);
    }

    @Override
    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            this.mirror = new ShaderAppearanceRetained();
            ((ShaderAppearanceRetained)this.mirror).isMirror = true;
        }
        this.initMirrorObject();
    }

    @Override
    synchronized void initMirrorObject() {
        super.initMirrorObject();
        ShaderAppearanceRetained shaderAppearanceRetained = (ShaderAppearanceRetained)this.mirror;
        shaderAppearanceRetained.shaderProgram = this.shaderProgram != null ? (ShaderProgramRetained)this.shaderProgram.mirror : null;
        shaderAppearanceRetained.shaderAttributeSet = this.shaderAttributeSet != null ? (ShaderAttributeSetRetained)this.shaderAttributeSet.mirror : null;
    }

    @Override
    synchronized void updateMirrorObject(int n, Object object) {
        super.updateMirrorObject(n, object);
        ShaderAppearanceRetained shaderAppearanceRetained = (ShaderAppearanceRetained)this.mirror;
        if ((n & 0x800) != 0) {
            shaderAppearanceRetained.shaderProgram = (ShaderProgramRetained)object;
        } else if ((n & 0x1000) != 0) {
            shaderAppearanceRetained.shaderAttributeSet = (ShaderAttributeSetRetained)object;
        }
    }

    @Override
    void doSetLive(boolean bl, int n) {
        if (this.shaderProgram != null) {
            this.shaderProgram.setLive(bl, n);
        }
        if (this.shaderAttributeSet != null) {
            this.shaderAttributeSet.setLive(bl, n);
        }
        super.doSetLive(bl, n);
    }

    @Override
    void clearLive(int n) {
        super.clearLive(n);
        if (this.shaderProgram != null) {
            this.shaderProgram.clearLive(n);
        }
        if (this.shaderAttributeSet != null) {
            this.shaderAttributeSet.clearLive(n);
        }
    }

    @Override
    synchronized void addAMirrorUser(Shape3DRetained shape3DRetained) {
        super.addAMirrorUser(shape3DRetained);
        if (this.shaderProgram != null) {
            this.shaderProgram.addAMirrorUser(shape3DRetained);
        }
        if (this.shaderAttributeSet != null) {
            this.shaderAttributeSet.addAMirrorUser(shape3DRetained);
        }
    }

    @Override
    synchronized void removeAMirrorUser(Shape3DRetained shape3DRetained) {
        super.removeAMirrorUser(shape3DRetained);
        if (this.shaderProgram != null) {
            this.shaderProgram.removeAMirrorUser(shape3DRetained);
        }
        if (this.shaderAttributeSet != null) {
            this.shaderAttributeSet.removeAMirrorUser(shape3DRetained);
        }
    }

    final void sendMessage(int n, Object object) {
        ArrayList<VirtualUniverse> arrayList = new ArrayList<VirtualUniverse>();
        ArrayList<ArrayList<GeometryAtom>> arrayList2 = Shape3DRetained.getGeomAtomsList(this.mirror.users, arrayList);
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 65;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(j3dMessage);
        for (int i = 0; i < arrayList.size(); ++i) {
            j3dMessage = new J3dMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 65;
            j3dMessage.universe = arrayList.get(i);
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n);
            j3dMessage.args[2] = object;
            ArrayList<GeometryAtom> arrayList3 = arrayList2.get(i);
            GeometryAtom[] geometryAtomArray = new GeometryAtom[arrayList3.size()];
            arrayList3.toArray(geometryAtomArray);
            j3dMessage.args[3] = geometryAtomArray;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    @Override
    boolean isStatic() {
        if (!super.isStatic()) {
            return false;
        }
        boolean bl = !(!this.source.capabilityBitsEmpty() || this.shaderProgram != null && !this.shaderProgram.source.capabilityBitsEmpty() || this.shaderAttributeSet != null && !this.shaderAttributeSet.source.capabilityBitsEmpty());
        return bl;
    }

    @Override
    void compile(CompileState compileState) {
        super.compile(compileState);
        if (this.shaderProgram != null) {
            this.shaderProgram.compile(compileState);
        }
        if (this.shaderAttributeSet != null) {
            this.shaderAttributeSet.compile(compileState);
        }
    }

    @Override
    boolean isOpaque(int n) {
        return super.isOpaque(n);
    }

    @Override
    void handleFrequencyChange(int n) {
        super.handleFrequencyChange(n);
        int n2 = 0;
        if (n == 23) {
            n2 = 2048;
        } else if (n == 25) {
            n2 = 4096;
        }
        if (n2 != 0) {
            this.setFrequencyChangeMask(n, n2);
        }
    }
}

