/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.ColorButton;
import com.eteks.sweethome3d.swing.NullableCheckBox;
import com.eteks.sweethome3d.swing.NullableSpinner;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.DimensionLineController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DimensionLinePanel
extends JPanel
implements DialogView {
    private final boolean dimensionLineModification;
    private final DimensionLineController controller;
    private JLabel xStartLabel;
    private JSpinner xStartSpinner;
    private JLabel yStartLabel;
    private JSpinner yStartSpinner;
    private JLabel elevationStartLabel;
    private JSpinner elevationStartSpinner;
    private JLabel xEndLabel;
    private JSpinner xEndSpinner;
    private JLabel yEndLabel;
    private JSpinner yEndSpinner;
    private JLabel distanceToEndPointLabel;
    private JSpinner distanceToEndPointSpinner;
    private JLabel offsetLabel;
    private JSpinner offsetSpinner;
    private JRadioButton planDimensionLineRadioButton;
    private JRadioButton elevationDimensionLineRadioButton;
    private JLabel lengthFontSizeLabel;
    private JSpinner lengthFontSizeSpinner;
    private JLabel colorLabel;
    private ColorButton colorButton;
    private NullableCheckBox visibleIn3DViewCheckBox;
    private JLabel pitchLabel;
    private JRadioButton pitch0DegreeRadioButton;
    private JRadioButton pitch90DegreeRadioButton;
    private String dialogTitle;

    public DimensionLinePanel(boolean bl, UserPreferences userPreferences, DimensionLineController dimensionLineController) {
        super(new GridBagLayout());
        this.dimensionLineModification = bl;
        this.controller = dimensionLineController;
        this.createComponents(bl, userPreferences, dimensionLineController);
        this.setMnemonics(userPreferences);
        this.layoutComponents(userPreferences, dimensionLineController);
    }

    private void createComponents(boolean bl, UserPreferences userPreferences, final DimensionLineController dimensionLineController) {
        String string = userPreferences.getLengthUnit().getName();
        this.xStartLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, DimensionLinePanel.class, "xLabel.text", string));
        float f = userPreferences.getLengthUnit().getMaximumLength();
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, -f, f);
        this.xStartSpinner = new NullableSpinner(nullableSpinnerLengthModel);
        nullableSpinnerLengthModel.setNullable(dimensionLineController.getXStart() == null);
        nullableSpinnerLengthModel.setLength(dimensionLineController.getXStart());
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel.setNullable(propertyChangeEvent.getNewValue() == null);
                nullableSpinnerLengthModel.setLength((Float)propertyChangeEvent.getNewValue());
            }
        };
        dimensionLineController.addPropertyChangeListener(DimensionLineController.Property.X_START, propertyChangeListener);
        nullableSpinnerLengthModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                dimensionLineController.removePropertyChangeListener(DimensionLineController.Property.X_START, propertyChangeListener);
                dimensionLineController.setXStart(nullableSpinnerLengthModel.getLength());
                dimensionLineController.addPropertyChangeListener(DimensionLineController.Property.X_START, propertyChangeListener);
            }
        });
        this.yStartLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, DimensionLinePanel.class, "yLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel2 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, -f, f);
        this.yStartSpinner = new NullableSpinner(nullableSpinnerLengthModel2);
        nullableSpinnerLengthModel2.setNullable(dimensionLineController.getYStart() == null);
        nullableSpinnerLengthModel2.setLength(dimensionLineController.getYStart());
        final PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel2.setNullable(propertyChangeEvent.getNewValue() == null);
                nullableSpinnerLengthModel2.setLength((Float)propertyChangeEvent.getNewValue());
            }
        };
        dimensionLineController.addPropertyChangeListener(DimensionLineController.Property.Y_START, propertyChangeListener2);
        nullableSpinnerLengthModel2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                dimensionLineController.removePropertyChangeListener(DimensionLineController.Property.Y_START, propertyChangeListener2);
                dimensionLineController.setYStart(nullableSpinnerLengthModel2.getLength());
                dimensionLineController.addPropertyChangeListener(DimensionLineController.Property.Y_START, propertyChangeListener2);
            }
        });
        this.elevationStartLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, DimensionLinePanel.class, "elevationLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel3 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, 0.0f, f);
        this.elevationStartSpinner = new NullableSpinner(nullableSpinnerLengthModel3);
        nullableSpinnerLengthModel3.setNullable(dimensionLineController.getElevationStart() == null);
        nullableSpinnerLengthModel3.setLength(dimensionLineController.getElevationStart());
        final PropertyChangeListener propertyChangeListener3 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel3.setNullable(propertyChangeEvent.getNewValue() == null);
                nullableSpinnerLengthModel3.setLength((Float)propertyChangeEvent.getNewValue());
            }
        };
        dimensionLineController.addPropertyChangeListener(DimensionLineController.Property.ELEVATION_START, propertyChangeListener3);
        nullableSpinnerLengthModel3.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                dimensionLineController.removePropertyChangeListener(DimensionLineController.Property.ELEVATION_START, propertyChangeListener3);
                Float f = nullableSpinnerLengthModel3.getLength();
                if (f != null && dimensionLineController.getElevationEnd() != null && dimensionLineController.getElevationStart() != null) {
                    dimensionLineController.setElevationEnd(Float.valueOf(dimensionLineController.getElevationEnd().floatValue() + f.floatValue() - dimensionLineController.getElevationStart().floatValue()));
                }
                dimensionLineController.setElevationStart(f);
                dimensionLineController.addPropertyChangeListener(DimensionLineController.Property.ELEVATION_START, propertyChangeListener3);
            }
        });
        this.xEndLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, DimensionLinePanel.class, "xLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel4 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, -f, f);
        this.xEndSpinner = new NullableSpinner(nullableSpinnerLengthModel4);
        nullableSpinnerLengthModel4.setNullable(dimensionLineController.getXEnd() == null);
        nullableSpinnerLengthModel4.setLength(dimensionLineController.getXEnd());
        final PropertyChangeListener propertyChangeListener4 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel4.setNullable(propertyChangeEvent.getNewValue() == null);
                nullableSpinnerLengthModel4.setLength((Float)propertyChangeEvent.getNewValue());
            }
        };
        dimensionLineController.addPropertyChangeListener(DimensionLineController.Property.X_END, propertyChangeListener4);
        nullableSpinnerLengthModel4.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                dimensionLineController.removePropertyChangeListener(DimensionLineController.Property.X_END, propertyChangeListener4);
                dimensionLineController.setXEnd(nullableSpinnerLengthModel4.getLength());
                dimensionLineController.addPropertyChangeListener(DimensionLineController.Property.X_END, propertyChangeListener4);
            }
        });
        this.yEndLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, DimensionLinePanel.class, "yLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel5 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, -f, f);
        this.yEndSpinner = new NullableSpinner(nullableSpinnerLengthModel5);
        nullableSpinnerLengthModel5.setNullable(dimensionLineController.getYEnd() == null);
        nullableSpinnerLengthModel5.setLength(dimensionLineController.getYEnd());
        final PropertyChangeListener propertyChangeListener5 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel5.setNullable(propertyChangeEvent.getNewValue() == null);
                nullableSpinnerLengthModel5.setLength((Float)propertyChangeEvent.getNewValue());
            }
        };
        dimensionLineController.addPropertyChangeListener(DimensionLineController.Property.Y_END, propertyChangeListener5);
        nullableSpinnerLengthModel5.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                dimensionLineController.removePropertyChangeListener(DimensionLineController.Property.Y_END, propertyChangeListener5);
                dimensionLineController.setYEnd(nullableSpinnerLengthModel5.getLength());
                dimensionLineController.addPropertyChangeListener(DimensionLineController.Property.Y_END, propertyChangeListener5);
            }
        });
        this.distanceToEndPointLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, DimensionLinePanel.class, "distanceToEndPointLabel.text", string));
        float f2 = userPreferences.getLengthUnit().getMinimumLength();
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel6 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, f2, 2.0f * f * (float)Math.sqrt(2.0));
        this.distanceToEndPointSpinner = new NullableSpinner(nullableSpinnerLengthModel6);
        nullableSpinnerLengthModel6.setNullable(dimensionLineController.getDistanceToEndPoint() == null);
        nullableSpinnerLengthModel6.setLength(dimensionLineController.getDistanceToEndPoint());
        final PropertyChangeListener propertyChangeListener6 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel6.setNullable(propertyChangeEvent.getNewValue() == null);
                nullableSpinnerLengthModel6.setLength((Float)propertyChangeEvent.getNewValue());
            }
        };
        dimensionLineController.addPropertyChangeListener(DimensionLineController.Property.DISTANCE_TO_END_POINT, propertyChangeListener6);
        nullableSpinnerLengthModel6.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                dimensionLineController.removePropertyChangeListener(DimensionLineController.Property.DISTANCE_TO_END_POINT, propertyChangeListener6);
                dimensionLineController.setDistanceToEndPoint(nullableSpinnerLengthModel6.getLength());
                dimensionLineController.addPropertyChangeListener(DimensionLineController.Property.DISTANCE_TO_END_POINT, propertyChangeListener6);
            }
        });
        this.offsetLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, DimensionLinePanel.class, "offsetLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel7 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, -10000.0f, 10000.0f);
        this.offsetSpinner = new NullableSpinner(nullableSpinnerLengthModel7);
        nullableSpinnerLengthModel7.setNullable(dimensionLineController.getOffset() == null);
        nullableSpinnerLengthModel7.setLength(dimensionLineController.getOffset());
        final PropertyChangeListener propertyChangeListener7 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel7.setNullable(propertyChangeEvent.getNewValue() == null);
                nullableSpinnerLengthModel7.setLength((Float)propertyChangeEvent.getNewValue());
            }
        };
        dimensionLineController.addPropertyChangeListener(DimensionLineController.Property.OFFSET, propertyChangeListener7);
        nullableSpinnerLengthModel7.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                dimensionLineController.removePropertyChangeListener(DimensionLineController.Property.OFFSET, propertyChangeListener7);
                dimensionLineController.setOffset(nullableSpinnerLengthModel7.getLength());
                dimensionLineController.addPropertyChangeListener(DimensionLineController.Property.OFFSET, propertyChangeListener7);
            }
        });
        this.planDimensionLineRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, DimensionLinePanel.class, "planDimensionLineRadioButton.text", new Object[0]));
        this.planDimensionLineRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (DimensionLinePanel.this.planDimensionLineRadioButton.isSelected()) {
                    dimensionLineController.setOrientation(DimensionLineController.DimensionLineOrientation.PLAN);
                }
            }
        });
        this.elevationDimensionLineRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, DimensionLinePanel.class, "elevationDimensionLineRadioButton.text", new Object[0]));
        this.elevationDimensionLineRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (DimensionLinePanel.this.elevationDimensionLineRadioButton.isSelected()) {
                    dimensionLineController.setOrientation(DimensionLineController.DimensionLineOrientation.ELEVATION);
                }
            }
        });
        dimensionLineController.addPropertyChangeListener(DimensionLineController.Property.ORIENTATION, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DimensionLinePanel.this.updateOrientationRadioButtons(dimensionLineController);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.planDimensionLineRadioButton);
        buttonGroup.add(this.elevationDimensionLineRadioButton);
        this.lengthFontSizeLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, DimensionLinePanel.class, "lengthFontSizeLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel8 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, 5.0f, 999.0f);
        this.lengthFontSizeSpinner = new NullableSpinner(nullableSpinnerLengthModel8);
        final PropertyChangeListener propertyChangeListener8 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Float f = dimensionLineController.getLengthFontSize();
                nullableSpinnerLengthModel8.setNullable(f == null);
                nullableSpinnerLengthModel8.setLength(f);
            }
        };
        propertyChangeListener8.propertyChange(null);
        dimensionLineController.addPropertyChangeListener(DimensionLineController.Property.LENGTH_FONT_SIZE, propertyChangeListener8);
        nullableSpinnerLengthModel8.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                dimensionLineController.removePropertyChangeListener(DimensionLineController.Property.LENGTH_FONT_SIZE, propertyChangeListener8);
                dimensionLineController.setLengthFontSize(nullableSpinnerLengthModel8.getLength());
                dimensionLineController.addPropertyChangeListener(DimensionLineController.Property.LENGTH_FONT_SIZE, propertyChangeListener8);
            }
        });
        this.colorLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, DimensionLinePanel.class, "colorLabel.text", new Object[0]));
        this.colorButton = new ColorButton(userPreferences);
        if (OperatingSystem.isMacOSX()) {
            this.colorButton.putClientProperty("JButton.buttonType", "segmented");
            this.colorButton.putClientProperty("JButton.segmentPosition", "only");
        }
        this.colorButton.setColorDialogTitle(userPreferences.getLocalizedString(DimensionLinePanel.class, "colorDialog.title", new Object[0]));
        this.colorButton.setColor(dimensionLineController.getColor() != null ? dimensionLineController.getColor().intValue() : this.getForeground().getRGB());
        this.colorButton.addPropertyChangeListener("color", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                dimensionLineController.setColor(DimensionLinePanel.this.colorButton.getColor());
            }
        });
        dimensionLineController.addPropertyChangeListener(DimensionLineController.Property.COLOR, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DimensionLinePanel.this.colorButton.setColor(dimensionLineController.getColor());
            }
        });
        this.visibleIn3DViewCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, DimensionLinePanel.class, "visibleIn3DViewCheckBox.text", new Object[0]));
        this.visibleIn3DViewCheckBox.setNullable(dimensionLineController.isVisibleIn3D() == null);
        this.visibleIn3DViewCheckBox.setValue(dimensionLineController.isVisibleIn3D());
        final PropertyChangeListener propertyChangeListener9 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DimensionLinePanel.this.visibleIn3DViewCheckBox.setValue(dimensionLineController.isVisibleIn3D());
            }
        };
        dimensionLineController.addPropertyChangeListener(DimensionLineController.Property.VISIBLE_IN_3D, propertyChangeListener9);
        this.visibleIn3DViewCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                dimensionLineController.removePropertyChangeListener(DimensionLineController.Property.VISIBLE_IN_3D, propertyChangeListener9);
                dimensionLineController.setVisibleIn3D(DimensionLinePanel.this.visibleIn3DViewCheckBox.getValue());
                if (DimensionLinePanel.this.visibleIn3DViewCheckBox.isNullable()) {
                    DimensionLinePanel.this.visibleIn3DViewCheckBox.setNullable(false);
                }
                DimensionLinePanel.this.updateOrientationRadioButtons(dimensionLineController);
                dimensionLineController.addPropertyChangeListener(DimensionLineController.Property.VISIBLE_IN_3D, propertyChangeListener9);
            }
        });
        this.pitchLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, DimensionLinePanel.class, "pitchLabel.text", new Object[0]));
        this.pitch0DegreeRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, DimensionLinePanel.class, "pitch0DegreeRadioButton.text", new Object[0]));
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (DimensionLinePanel.this.pitch0DegreeRadioButton.isSelected()) {
                    dimensionLineController.setPitch(Float.valueOf(0.0f));
                } else if (DimensionLinePanel.this.pitch90DegreeRadioButton.isSelected()) {
                    dimensionLineController.setPitch(Float.valueOf(-1.5707964f));
                }
            }
        };
        this.pitch0DegreeRadioButton.addItemListener(itemListener);
        this.pitch90DegreeRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, DimensionLinePanel.class, "pitch90DegreeRadioButton.text", new Object[0]));
        this.pitch90DegreeRadioButton.addItemListener(itemListener);
        final PropertyChangeListener propertyChangeListener10 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DimensionLinePanel.this.updateOrientationRadioButtons(dimensionLineController);
            }
        };
        dimensionLineController.addPropertyChangeListener(DimensionLineController.Property.PITCH, propertyChangeListener10);
        this.visibleIn3DViewCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                dimensionLineController.removePropertyChangeListener(DimensionLineController.Property.PITCH, propertyChangeListener10);
                DimensionLinePanel.this.updateOrientationRadioButtons(dimensionLineController);
                dimensionLineController.addPropertyChangeListener(DimensionLineController.Property.PITCH, propertyChangeListener10);
            }
        });
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.pitch0DegreeRadioButton);
        buttonGroup2.add(this.pitch90DegreeRadioButton);
        this.updateOrientationRadioButtons(dimensionLineController);
        this.dialogTitle = userPreferences.getLocalizedString(DimensionLinePanel.class, bl ? "dimensionLineModification.title" : "dimensionLineCreation.title", new Object[0]);
    }

    private void updateOrientationRadioButtons(DimensionLineController dimensionLineController) {
        if (dimensionLineController.getOrientation() == DimensionLineController.DimensionLineOrientation.PLAN) {
            this.planDimensionLineRadioButton.setSelected(true);
        } else if (dimensionLineController.getOrientation() == DimensionLineController.DimensionLineOrientation.ELEVATION) {
            this.elevationDimensionLineRadioButton.setSelected(true);
        } else {
            SwingTools.deselectAllRadioButtons(this.planDimensionLineRadioButton, this.elevationDimensionLineRadioButton);
        }
        boolean bl = dimensionLineController.isEditableDistance();
        this.planDimensionLineRadioButton.setEnabled(bl);
        this.elevationDimensionLineRadioButton.setEnabled(bl);
        if (dimensionLineController.getPitch() == null || dimensionLineController.getOrientation() == DimensionLineController.DimensionLineOrientation.ELEVATION) {
            SwingTools.deselectAllRadioButtons(this.pitch0DegreeRadioButton, this.pitch90DegreeRadioButton);
        } else if (dimensionLineController.getPitch().floatValue() == 0.0f) {
            this.pitch0DegreeRadioButton.setSelected(true);
        } else if (Math.abs(dimensionLineController.getPitch().floatValue()) == 1.5707964f) {
            this.pitch90DegreeRadioButton.setSelected(true);
        } else {
            SwingTools.deselectAllRadioButtons(this.pitch0DegreeRadioButton, this.pitch90DegreeRadioButton);
        }
        boolean bl2 = dimensionLineController.getOrientation() == DimensionLineController.DimensionLineOrientation.PLAN;
        boolean bl3 = Boolean.TRUE.equals(dimensionLineController.isVisibleIn3D());
        this.pitch0DegreeRadioButton.setEnabled(bl3 && bl2);
        this.pitch90DegreeRadioButton.setEnabled(bl3 && bl2);
        this.elevationStartSpinner.setEnabled(bl3 || dimensionLineController.getOrientation() == DimensionLineController.DimensionLineOrientation.ELEVATION);
        this.xEndSpinner.setEnabled(bl2);
        this.yEndSpinner.setEnabled(bl2);
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            this.xStartLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(DimensionLinePanel.class, "xLabel.mnemonic", new Object[0])).getKeyCode());
            this.xStartLabel.setLabelFor(this.xStartSpinner);
            this.yStartLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(DimensionLinePanel.class, "yLabel.mnemonic", new Object[0])).getKeyCode());
            this.yStartLabel.setLabelFor(this.yStartSpinner);
            this.elevationStartLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(DimensionLinePanel.class, "elevationLabel.mnemonic", new Object[0])).getKeyCode());
            this.elevationStartLabel.setLabelFor(this.elevationStartSpinner);
            this.xEndLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(DimensionLinePanel.class, "xLabel.mnemonic", new Object[0])).getKeyCode());
            this.xEndLabel.setLabelFor(this.xEndSpinner);
            this.yEndLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(DimensionLinePanel.class, "yLabel.mnemonic", new Object[0])).getKeyCode());
            this.yEndLabel.setLabelFor(this.yEndSpinner);
            this.planDimensionLineRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(DimensionLinePanel.class, "planDimensionLineRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.elevationDimensionLineRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(DimensionLinePanel.class, "elevationDimensionLineRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.distanceToEndPointLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(DimensionLinePanel.class, "distanceToEndPointLabel.mnemonic", new Object[0])).getKeyCode());
            this.distanceToEndPointLabel.setLabelFor(this.distanceToEndPointSpinner);
            this.offsetLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(DimensionLinePanel.class, "offsetLabel.mnemonic", new Object[0])).getKeyCode());
            this.offsetLabel.setLabelFor(this.offsetSpinner);
            this.lengthFontSizeLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(DimensionLinePanel.class, "lengthFontSizeLabel.mnemonic", new Object[0])).getKeyCode());
            this.lengthFontSizeLabel.setLabelFor(this.lengthFontSizeSpinner);
            this.visibleIn3DViewCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(DimensionLinePanel.class, "visibleIn3DViewCheckBox.mnemonic", new Object[0])).getKeyCode());
            this.pitch0DegreeRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(DimensionLinePanel.class, "pitch0DegreeRadioButton.mnemonic", new Object[0])).getKeyCode());
            this.pitch90DegreeRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(DimensionLinePanel.class, "pitch90DegreeRadioButton.mnemonic", new Object[0])).getKeyCode());
        }
    }

    private void layoutComponents(UserPreferences userPreferences, final DimensionLineController dimensionLineController) {
        int n = OperatingSystem.isMacOSX() ? 22 : 21;
        int n2 = Math.round(5.0f * SwingTools.getResolutionScale());
        JPanel jPanel = SwingTools.createTitledPanel(userPreferences.getLocalizedString(DimensionLinePanel.class, "startPointPanel.title", new Object[0]));
        jPanel.add((Component)this.xStartLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, 0, n2), 0, 0));
        jPanel.add((Component)this.xStartSpinner, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 5, 0));
        jPanel.add((Component)this.yStartLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 2 * n2, 0, n2), 0, 0));
        jPanel.add((Component)this.yStartSpinner, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 5, 0));
        jPanel.add((Component)this.elevationStartLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, n, 0, new Insets(n2, 0, 0, n2), 0, 0));
        jPanel.add((Component)this.elevationStartSpinner, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(n2, 0, 0, 0), 5, 0));
        Insets insets = OperatingSystem.isMacOSXLeopardOrSuperior() ? new Insets(0, 0, 0, 0) : new Insets(0, 0, n2, 0);
        this.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, insets, 0, 0));
        JPanel jPanel2 = SwingTools.createTitledPanel(userPreferences.getLocalizedString(DimensionLinePanel.class, "endPointPanel.title", new Object[0]));
        jPanel2.add((Component)this.xEndLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, 0, n2), 0, 0));
        jPanel2.add((Component)this.xEndSpinner, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 5, 0));
        jPanel2.add((Component)this.yEndLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 2 * n2, 0, n2), 0, 0));
        jPanel2.add((Component)this.yEndSpinner, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 5, 0));
        jPanel2.add((Component)this.distanceToEndPointLabel, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 22, 0, new Insets(n2, 0, 0, n2), 0, 0));
        jPanel2.add((Component)this.distanceToEndPointSpinner, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(n2, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this.offsetLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, n, 0, new Insets(n2, 0, 0, n2), 0, 0));
        jPanel2.add((Component)this.offsetSpinner, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(n2, 0, 0, 0), 0, 0));
        jPanel2.add((Component)new JSeparator(), new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 10, 2, new Insets(n2, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this.planDimensionLineRadioButton, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 0, new Insets(3, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this.elevationDimensionLineRadioButton, new GridBagConstraints(2, 4, 2, 1, 0.0, 0.0, 10, 0, new Insets(3, 2 * n2, 0, 0), 0, 0));
        this.add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 2, insets, 0, 0));
        JPanel jPanel3 = SwingTools.createTitledPanel(userPreferences.getLocalizedString(DimensionLinePanel.class, "stylePanel.title", new Object[0]));
        jPanel3.add((Component)this.lengthFontSizeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, 0, n2), 0, 0));
        jPanel3.add((Component)this.lengthFontSizeSpinner, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 5, 0));
        jPanel3.add((Component)this.colorLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 2 * n2, 0, n2), 0, 0));
        jPanel3.add((Component)this.colorButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel4 = SwingTools.createTitledPanel(userPreferences.getLocalizedString(DimensionLinePanel.class, "rendering3DPanel.title", new Object[0]));
        jPanel4.add((Component)this.visibleIn3DViewCheckBox, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 21, 0, new Insets(0, OperatingSystem.isMacOSX() ? -8 : 0, n2, 0), 0, 0));
        jPanel4.add((Component)this.pitchLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, n2, n2), 0, 0));
        jPanel4.add((Component)this.pitch0DegreeRadioButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n2, n2), 0, 0));
        jPanel4.add((Component)this.pitch90DegreeRadioButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, n2, 0), 0, 0));
        this.add((Component)jPanel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DimensionLinePanel.this.distanceToEndPointLabel.setVisible(dimensionLineController.isEditableDistance());
                DimensionLinePanel.this.distanceToEndPointSpinner.setVisible(dimensionLineController.isEditableDistance());
            }
        };
        dimensionLineController.addPropertyChangeListener(DimensionLineController.Property.EDITABLE_DISTANCE, propertyChangeListener);
        propertyChangeListener.propertyChange(null);
    }

    @Override
    public void displayView(View view) {
        JSpinner jSpinner;
        JSpinner jSpinner2 = jSpinner = this.distanceToEndPointSpinner.getValue() != null ? this.distanceToEndPointSpinner : this.offsetSpinner;
        if (SwingTools.showConfirmDialog((JComponent)((Object)view), this, this.dialogTitle, ((JSpinner.DefaultEditor)jSpinner.getEditor()).getTextField()) == 0 && this.controller != null) {
            if (this.dimensionLineModification) {
                this.controller.modifyDimensionLines();
            } else {
                this.controller.createDimensionLine();
            }
        }
    }
}

