# -*- coding: utf-8 -*-

"""
***************************************************************************
    __init__.py
    ---------------------
    Date                 : May 2014
    Copyright            : (C) 2014 by Nathan Woodrow
    Email                : woodrow dot nathan at gmail dot com
***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
"""

__author__ = 'Nathan Woodrow'
__date__ = 'May 2014'
__copyright__ = '(C) 2014, Nathan Woodrow'

from qgis.PyQt import QtCore
from qgis._gui import *
from qgis._core import Qgis

# monkey patching scoped based enum
QgsMapToolCapture.CaptureTechnique = Qgis.CaptureTechnique
QgsMapToolCapture.StraightSegments = Qgis.CaptureTechnique.StraightSegments
QgsMapToolCapture.StraightSegments.is_monkey_patched = True
QgsMapToolCapture.StraightSegments.__doc__ = "Default capture mode - capture occurs with straight line segments"
QgsMapToolCapture.CircularString = Qgis.CaptureTechnique.CircularString
QgsMapToolCapture.CircularString.is_monkey_patched = True
QgsMapToolCapture.CircularString.__doc__ = "Capture in circular strings"
QgsMapToolCapture.Streaming = Qgis.CaptureTechnique.Streaming
QgsMapToolCapture.Streaming.is_monkey_patched = True
QgsMapToolCapture.Streaming.__doc__ = "Streaming points digitizing mode (points are automatically added as the mouse cursor moves)."
QgsMapToolCapture.Shape = Qgis.CaptureTechnique.Shape
QgsMapToolCapture.Shape.is_monkey_patched = True
QgsMapToolCapture.Shape.__doc__ = "Digitize shapes."

QgsActionMenu.ActionType = Qgis.ActionType
# monkey patching scoped based enum
QgsActionMenu.Invalid = Qgis.ActionType.Invalid
QgsActionMenu.Invalid.is_monkey_patched = True
QgsActionMenu.Invalid.__doc__ = "Invalid"
QgsActionMenu.MapLayerAction = Qgis.ActionType.MapLayerAction
QgsActionMenu.MapLayerAction.is_monkey_patched = True
QgsActionMenu.MapLayerAction.__doc__ = "Standard actions (defined by core or plugins), corresponds to QgsMapLayerAction class."
QgsActionMenu.AttributeAction = Qgis.ActionType.AttributeAction
QgsActionMenu.AttributeAction.is_monkey_patched = True
QgsActionMenu.AttributeAction.__doc__ = "Custom actions (manually defined in layer properties), corresponds to QgsAction class."

QgsMapLayerAction.Target = Qgis.MapLayerActionTarget
# monkey patching scoped based enum
QgsMapLayerAction.Layer = Qgis.MapLayerActionTarget.Layer
QgsMapLayerAction.Layer.is_monkey_patched = True
QgsMapLayerAction.Layer.__doc__ = "Action targets a complete layer"
QgsMapLayerAction.SingleFeature = Qgis.MapLayerActionTarget.SingleFeature
QgsMapLayerAction.SingleFeature.is_monkey_patched = True
QgsMapLayerAction.SingleFeature.__doc__ = "Action targets a single feature from a layer"
QgsMapLayerAction.MultipleFeatures = Qgis.MapLayerActionTarget.MultipleFeatures
QgsMapLayerAction.MultipleFeatures.is_monkey_patched = True
QgsMapLayerAction.MultipleFeatures.__doc__ = "Action targets multiple features from a layer"
QgsMapLayerAction.AllActions = Qgis.MapLayerActionTarget.AllActions
QgsMapLayerAction.AllActions.is_monkey_patched = True
QgsMapLayerAction.AllActions.__doc__ = ""
QgsMapLayerAction.Targets = Qgis.MapLayerActionTargets

QgsMapLayerAction.Flag = Qgis.MapLayerActionFlag
# monkey patching scoped based enum
QgsMapLayerAction.EnabledOnlyWhenEditable = Qgis.MapLayerActionFlag.EnabledOnlyWhenEditable
QgsMapLayerAction.EnabledOnlyWhenEditable.is_monkey_patched = True
QgsMapLayerAction.EnabledOnlyWhenEditable.__doc__ = "Action should be shown only for editable layers"
QgsMapLayerAction.Flags = Qgis.MapLayerActionFlags
"""
This folder is completed using sipify.pl script
It is not aimed to be manually edited
"""
# The following has been generated automatically from src/gui/qgsadvanceddigitizingdockwidget.h
QgsAdvancedDigitizingDockWidget.CadCapacities.baseClass = QgsAdvancedDigitizingDockWidget
CadCapacities = QgsAdvancedDigitizingDockWidget  # dirty hack since SIP seems to introduce the flags in module
# The following has been generated automatically from src/gui/qgsadvanceddigitizingfloater.h
# monkey patching scoped based enum
QgsAdvancedDigitizingFloater.FloaterItem.XCoordinate.__doc__ = ""
QgsAdvancedDigitizingFloater.FloaterItem.YCoordinate.__doc__ = ""
QgsAdvancedDigitizingFloater.FloaterItem.MCoordinate.__doc__ = ""
QgsAdvancedDigitizingFloater.FloaterItem.ZCoordinate.__doc__ = ""
QgsAdvancedDigitizingFloater.FloaterItem.Angle.__doc__ = ""
QgsAdvancedDigitizingFloater.FloaterItem.CommonAngleSnapping.__doc__ = ""
QgsAdvancedDigitizingFloater.FloaterItem.Distance.__doc__ = ""
QgsAdvancedDigitizingFloater.FloaterItem.Bearing.__doc__ = ""
QgsAdvancedDigitizingFloater.FloaterItem.__doc__ = "Available floater items\n\n" + '* ``XCoordinate``: ' + QgsAdvancedDigitizingFloater.FloaterItem.XCoordinate.__doc__ + '\n' + '* ``YCoordinate``: ' + QgsAdvancedDigitizingFloater.FloaterItem.YCoordinate.__doc__ + '\n' + '* ``MCoordinate``: ' + QgsAdvancedDigitizingFloater.FloaterItem.MCoordinate.__doc__ + '\n' + '* ``ZCoordinate``: ' + QgsAdvancedDigitizingFloater.FloaterItem.ZCoordinate.__doc__ + '\n' + '* ``Angle``: ' + QgsAdvancedDigitizingFloater.FloaterItem.Angle.__doc__ + '\n' + '* ``CommonAngleSnapping``: ' + QgsAdvancedDigitizingFloater.FloaterItem.CommonAngleSnapping.__doc__ + '\n' + '* ``Distance``: ' + QgsAdvancedDigitizingFloater.FloaterItem.Distance.__doc__ + '\n' + '* ``Bearing``: ' + QgsAdvancedDigitizingFloater.FloaterItem.Bearing.__doc__
# --
QgsAdvancedDigitizingFloater.FloaterItem.baseClass = QgsAdvancedDigitizingFloater
FloaterItem = QgsAdvancedDigitizingFloater  # dirty hack since SIP seems to introduce the flags in module
# The following has been generated automatically from src/gui/qgsattributeeditorcontext.h
QgsAttributeEditorContext.Mode.baseClass = QgsAttributeEditorContext
# The following has been generated automatically from src/gui/attributetable/qgsattributetablefiltermodel.h
QgsAttributeTableFilterModel.FilterMode.baseClass = QgsAttributeTableFilterModel
QgsAttributeTableFilterModel.ColumnType.baseClass = QgsAttributeTableFilterModel
# The following has been generated automatically from src/gui/auth/qgsauthsettingswidget.h
QgsAuthSettingsWidget.WarningType.baseClass = QgsAuthSettingsWidget
# The following has been generated automatically from src/gui/codeeditors/qgscodeeditor.h
# monkey patching scoped based enum
QgsCodeEditor.Mode.ScriptEditor.__doc__ = "Standard mode, allows for display and edit of entire scripts"
QgsCodeEditor.Mode.OutputDisplay.__doc__ = "Read only mode for display of command outputs"
QgsCodeEditor.Mode.CommandInput.__doc__ = "Command input mode"
QgsCodeEditor.Mode.__doc__ = "Code editor modes.\n\n.. versionadded:: 3.30\n\n" + '* ``ScriptEditor``: ' + QgsCodeEditor.Mode.ScriptEditor.__doc__ + '\n' + '* ``OutputDisplay``: ' + QgsCodeEditor.Mode.OutputDisplay.__doc__ + '\n' + '* ``CommandInput``: ' + QgsCodeEditor.Mode.CommandInput.__doc__
# --
QgsCodeEditor.Mode.baseClass = QgsCodeEditor
# monkey patching scoped based enum
QgsCodeEditor.LineNumbers = QgsCodeEditor.MarginRole.LineNumbers
QgsCodeEditor.LineNumbers.is_monkey_patched = True
QgsCodeEditor.LineNumbers.__doc__ = "Line numbers"
QgsCodeEditor.ErrorIndicators = QgsCodeEditor.MarginRole.ErrorIndicators
QgsCodeEditor.ErrorIndicators.is_monkey_patched = True
QgsCodeEditor.ErrorIndicators.__doc__ = "Error indicators"
QgsCodeEditor.FoldingControls = QgsCodeEditor.MarginRole.FoldingControls
QgsCodeEditor.FoldingControls.is_monkey_patched = True
QgsCodeEditor.FoldingControls.__doc__ = "Folding controls"
QgsCodeEditor.MarginRole.__doc__ = "Margin roles.\n\nThis enum contains the roles which the different numbered margins are used for.\n\n.. versionadded:: 3.16\n\n" + '* ``LineNumbers``: ' + QgsCodeEditor.MarginRole.LineNumbers.__doc__ + '\n' + '* ``ErrorIndicators``: ' + QgsCodeEditor.MarginRole.ErrorIndicators.__doc__ + '\n' + '* ``FoldingControls``: ' + QgsCodeEditor.MarginRole.FoldingControls.__doc__
# --
QgsCodeEditor.MarginRole.baseClass = QgsCodeEditor
# monkey patching scoped based enum
QgsCodeEditor.Flag.CodeFolding.__doc__ = "Indicates that code folding should be enabled for the editor"
QgsCodeEditor.Flag.ImmediatelyUpdateHistory.__doc__ = "Indicates that the history file should be immediately updated whenever a command is executed, instead of the default behavior of only writing the history on widget close. Since QGIS 3.32."
QgsCodeEditor.Flag.__doc__ = "Flags controlling behavior of code editor\n\n.. versionadded:: 3.28\n\n" + '* ``CodeFolding``: ' + QgsCodeEditor.Flag.CodeFolding.__doc__ + '\n' + '* ``ImmediatelyUpdateHistory``: ' + QgsCodeEditor.Flag.ImmediatelyUpdateHistory.__doc__
# --
QgsCodeEditor.Flag.baseClass = QgsCodeEditor
QgsCodeEditor.Flags.baseClass = QgsCodeEditor
Flags = QgsCodeEditor  # dirty hack since SIP seems to introduce the flags in module
# The following has been generated automatically from src/gui/codeeditors/qgscodeeditorcolorscheme.h
# monkey patching scoped based enum
QgsCodeEditorColorScheme.ColorRole.Default.__doc__ = "Default text color"
QgsCodeEditorColorScheme.ColorRole.Keyword.__doc__ = "Keyword color"
QgsCodeEditorColorScheme.ColorRole.Class.__doc__ = "Class color"
QgsCodeEditorColorScheme.ColorRole.Method.__doc__ = "Method color"
QgsCodeEditorColorScheme.ColorRole.Decoration.__doc__ = "Decoration color"
QgsCodeEditorColorScheme.ColorRole.Number.__doc__ = "Number color"
QgsCodeEditorColorScheme.ColorRole.Comment.__doc__ = "Comment color"
QgsCodeEditorColorScheme.ColorRole.CommentLine.__doc__ = "Line comment color"
QgsCodeEditorColorScheme.ColorRole.CommentBlock.__doc__ = "Comment block color"
QgsCodeEditorColorScheme.ColorRole.Background.__doc__ = "Background color"
QgsCodeEditorColorScheme.ColorRole.Cursor.__doc__ = "Cursor color"
QgsCodeEditorColorScheme.ColorRole.CaretLine.__doc__ = "Caret line color"
QgsCodeEditorColorScheme.ColorRole.SingleQuote.__doc__ = "Single quote color"
QgsCodeEditorColorScheme.ColorRole.DoubleQuote.__doc__ = "Double quote color"
QgsCodeEditorColorScheme.ColorRole.TripleSingleQuote.__doc__ = "Triple single quote color"
QgsCodeEditorColorScheme.ColorRole.TripleDoubleQuote.__doc__ = "Triple double quote color"
QgsCodeEditorColorScheme.ColorRole.Operator.__doc__ = "Operator color"
QgsCodeEditorColorScheme.ColorRole.QuotedOperator.__doc__ = "Quoted operator color"
QgsCodeEditorColorScheme.ColorRole.Identifier.__doc__ = "Identifier color"
QgsCodeEditorColorScheme.ColorRole.QuotedIdentifier.__doc__ = "Quoted identifier color"
QgsCodeEditorColorScheme.ColorRole.Tag.__doc__ = "Tag color"
QgsCodeEditorColorScheme.ColorRole.UnknownTag.__doc__ = "Unknown tag"
QgsCodeEditorColorScheme.ColorRole.MarginBackground.__doc__ = "Margin background color"
QgsCodeEditorColorScheme.ColorRole.MarginForeground.__doc__ = "Margin foreground color"
QgsCodeEditorColorScheme.ColorRole.SelectionBackground.__doc__ = "Selection background color"
QgsCodeEditorColorScheme.ColorRole.SelectionForeground.__doc__ = "Selection foreground color"
QgsCodeEditorColorScheme.ColorRole.MatchedBraceBackground.__doc__ = "Matched brace background color"
QgsCodeEditorColorScheme.ColorRole.MatchedBraceForeground.__doc__ = "Matched brace foreground color"
QgsCodeEditorColorScheme.ColorRole.Edge.__doc__ = "Edge color"
QgsCodeEditorColorScheme.ColorRole.Fold.__doc__ = "Fold color"
QgsCodeEditorColorScheme.ColorRole.Error.__doc__ = "Error color"
QgsCodeEditorColorScheme.ColorRole.ErrorBackground.__doc__ = "Error background color"
QgsCodeEditorColorScheme.ColorRole.FoldIconForeground.__doc__ = "Fold icon foreground color"
QgsCodeEditorColorScheme.ColorRole.FoldIconHalo.__doc__ = "Fold icon halo color"
QgsCodeEditorColorScheme.ColorRole.IndentationGuide.__doc__ = "Indentation guide line"
QgsCodeEditorColorScheme.ColorRole.__doc__ = "Color roles.\n\n" + '* ``Default``: ' + QgsCodeEditorColorScheme.ColorRole.Default.__doc__ + '\n' + '* ``Keyword``: ' + QgsCodeEditorColorScheme.ColorRole.Keyword.__doc__ + '\n' + '* ``Class``: ' + QgsCodeEditorColorScheme.ColorRole.Class.__doc__ + '\n' + '* ``Method``: ' + QgsCodeEditorColorScheme.ColorRole.Method.__doc__ + '\n' + '* ``Decoration``: ' + QgsCodeEditorColorScheme.ColorRole.Decoration.__doc__ + '\n' + '* ``Number``: ' + QgsCodeEditorColorScheme.ColorRole.Number.__doc__ + '\n' + '* ``Comment``: ' + QgsCodeEditorColorScheme.ColorRole.Comment.__doc__ + '\n' + '* ``CommentLine``: ' + QgsCodeEditorColorScheme.ColorRole.CommentLine.__doc__ + '\n' + '* ``CommentBlock``: ' + QgsCodeEditorColorScheme.ColorRole.CommentBlock.__doc__ + '\n' + '* ``Background``: ' + QgsCodeEditorColorScheme.ColorRole.Background.__doc__ + '\n' + '* ``Cursor``: ' + QgsCodeEditorColorScheme.ColorRole.Cursor.__doc__ + '\n' + '* ``CaretLine``: ' + QgsCodeEditorColorScheme.ColorRole.CaretLine.__doc__ + '\n' + '* ``SingleQuote``: ' + QgsCodeEditorColorScheme.ColorRole.SingleQuote.__doc__ + '\n' + '* ``DoubleQuote``: ' + QgsCodeEditorColorScheme.ColorRole.DoubleQuote.__doc__ + '\n' + '* ``TripleSingleQuote``: ' + QgsCodeEditorColorScheme.ColorRole.TripleSingleQuote.__doc__ + '\n' + '* ``TripleDoubleQuote``: ' + QgsCodeEditorColorScheme.ColorRole.TripleDoubleQuote.__doc__ + '\n' + '* ``Operator``: ' + QgsCodeEditorColorScheme.ColorRole.Operator.__doc__ + '\n' + '* ``QuotedOperator``: ' + QgsCodeEditorColorScheme.ColorRole.QuotedOperator.__doc__ + '\n' + '* ``Identifier``: ' + QgsCodeEditorColorScheme.ColorRole.Identifier.__doc__ + '\n' + '* ``QuotedIdentifier``: ' + QgsCodeEditorColorScheme.ColorRole.QuotedIdentifier.__doc__ + '\n' + '* ``Tag``: ' + QgsCodeEditorColorScheme.ColorRole.Tag.__doc__ + '\n' + '* ``UnknownTag``: ' + QgsCodeEditorColorScheme.ColorRole.UnknownTag.__doc__ + '\n' + '* ``MarginBackground``: ' + QgsCodeEditorColorScheme.ColorRole.MarginBackground.__doc__ + '\n' + '* ``MarginForeground``: ' + QgsCodeEditorColorScheme.ColorRole.MarginForeground.__doc__ + '\n' + '* ``SelectionBackground``: ' + QgsCodeEditorColorScheme.ColorRole.SelectionBackground.__doc__ + '\n' + '* ``SelectionForeground``: ' + QgsCodeEditorColorScheme.ColorRole.SelectionForeground.__doc__ + '\n' + '* ``MatchedBraceBackground``: ' + QgsCodeEditorColorScheme.ColorRole.MatchedBraceBackground.__doc__ + '\n' + '* ``MatchedBraceForeground``: ' + QgsCodeEditorColorScheme.ColorRole.MatchedBraceForeground.__doc__ + '\n' + '* ``Edge``: ' + QgsCodeEditorColorScheme.ColorRole.Edge.__doc__ + '\n' + '* ``Fold``: ' + QgsCodeEditorColorScheme.ColorRole.Fold.__doc__ + '\n' + '* ``Error``: ' + QgsCodeEditorColorScheme.ColorRole.Error.__doc__ + '\n' + '* ``ErrorBackground``: ' + QgsCodeEditorColorScheme.ColorRole.ErrorBackground.__doc__ + '\n' + '* ``FoldIconForeground``: ' + QgsCodeEditorColorScheme.ColorRole.FoldIconForeground.__doc__ + '\n' + '* ``FoldIconHalo``: ' + QgsCodeEditorColorScheme.ColorRole.FoldIconHalo.__doc__ + '\n' + '* ``IndentationGuide``: ' + QgsCodeEditorColorScheme.ColorRole.IndentationGuide.__doc__
# --
# The following has been generated automatically from src/gui/qgscolorbutton.h
QgsColorButton.Behavior.baseClass = QgsColorButton
# The following has been generated automatically from src/gui/qgscolorwidgets.h
QgsColorTextWidget.ColorTextFormat.baseClass = QgsColorTextWidget
# The following has been generated automatically from src/gui/qgscoordinatereferencesystemmodel.h
QgsCoordinateReferenceSystemProxyModel.Filters.baseClass = QgsCoordinateReferenceSystemProxyModel
Filters = QgsCoordinateReferenceSystemProxyModel  # dirty hack since SIP seems to introduce the flags in module
# The following has been generated automatically from src/gui/attributetable/qgsdualview.h
QgsDualView.ViewMode.baseClass = QgsDualView
QgsDualView.FeatureListBrowsingAction.baseClass = QgsDualView
# The following has been generated automatically from src/gui/qgsexpressionbuilderwidget.h
QgsExpressionBuilderWidget.Flag.baseClass = QgsExpressionBuilderWidget
Flag = QgsExpressionBuilderWidget  # dirty hack since SIP seems to introduce the flags in module
# The following has been generated automatically from src/gui/qgsfieldmappingmodel.h
# monkey patching scoped based enum
QgsFieldMappingModel.ColumnDataIndex.SourceExpression.__doc__ = "Expression"
QgsFieldMappingModel.ColumnDataIndex.DestinationName.__doc__ = "Destination field name"
QgsFieldMappingModel.ColumnDataIndex.DestinationType.__doc__ = "Destination field type string"
QgsFieldMappingModel.ColumnDataIndex.DestinationLength.__doc__ = "Destination field length"
QgsFieldMappingModel.ColumnDataIndex.DestinationPrecision.__doc__ = "Destination field precision"
QgsFieldMappingModel.ColumnDataIndex.DestinationConstraints.__doc__ = "Destination field constraints"
QgsFieldMappingModel.ColumnDataIndex.DestinationAlias.__doc__ = "Destination alias"
QgsFieldMappingModel.ColumnDataIndex.DestinationComment.__doc__ = "Destination comment"
QgsFieldMappingModel.ColumnDataIndex.__doc__ = "The ColumnDataIndex enum represents the column index for the view\n\n" + '* ``SourceExpression``: ' + QgsFieldMappingModel.ColumnDataIndex.SourceExpression.__doc__ + '\n' + '* ``DestinationName``: ' + QgsFieldMappingModel.ColumnDataIndex.DestinationName.__doc__ + '\n' + '* ``DestinationType``: ' + QgsFieldMappingModel.ColumnDataIndex.DestinationType.__doc__ + '\n' + '* ``DestinationLength``: ' + QgsFieldMappingModel.ColumnDataIndex.DestinationLength.__doc__ + '\n' + '* ``DestinationPrecision``: ' + QgsFieldMappingModel.ColumnDataIndex.DestinationPrecision.__doc__ + '\n' + '* ``DestinationConstraints``: ' + QgsFieldMappingModel.ColumnDataIndex.DestinationConstraints.__doc__ + '\n' + '* ``DestinationAlias``: ' + QgsFieldMappingModel.ColumnDataIndex.DestinationAlias.__doc__ + '\n' + '* ``DestinationComment``: ' + QgsFieldMappingModel.ColumnDataIndex.DestinationComment.__doc__
# --
QgsFieldMappingModel.ColumnDataIndex.baseClass = QgsFieldMappingModel
# The following has been generated automatically from src/gui/qgsfilewidget.h
QgsFileWidget.StorageMode.baseClass = QgsFileWidget
QgsFileWidget.RelativeStorage.baseClass = QgsFileWidget
# The following has been generated automatically from src/gui/qgsfilterlineedit.h
QgsFilterLineEdit.ClearMode.baseClass = QgsFilterLineEdit
# The following has been generated automatically from src/gui/qgsfloatingwidget.h
QgsFloatingWidget.AnchorPoint.baseClass = QgsFloatingWidget
# The following has been generated automatically from src/gui/qgsfontbutton.h
QgsFontButton.Mode.baseClass = QgsFontButton
# The following has been generated automatically from src/gui/qgsgui.h
QgsGui.ProjectCrsBehavior.baseClass = QgsGui
# The following has been generated automatically from src/gui/editorwidgets/qgsjsoneditwidget.h
# monkey patching scoped based enum
QgsJsonEditWidget.View.Text.__doc__ = "JSON data displayed as text."
QgsJsonEditWidget.View.Tree.__doc__ = "JSON data displayed as tree. Tree view is disabled for invalid JSON data."
QgsJsonEditWidget.View.__doc__ = "View mode, text or tree.\n\n" + '* ``Text``: ' + QgsJsonEditWidget.View.Text.__doc__ + '\n' + '* ``Tree``: ' + QgsJsonEditWidget.View.Tree.__doc__
# --
# monkey patching scoped based enum
QgsJsonEditWidget.FormatJson.Indented.__doc__ = "JSON data formatted with regular indentation"
QgsJsonEditWidget.FormatJson.Compact.__doc__ = "JSON data formatted as a compact one line string"
QgsJsonEditWidget.FormatJson.Disabled.__doc__ = "JSON data is not formatted"
QgsJsonEditWidget.FormatJson.__doc__ = "Format mode in the text view\n\n" + '* ``Indented``: ' + QgsJsonEditWidget.FormatJson.Indented.__doc__ + '\n' + '* ``Compact``: ' + QgsJsonEditWidget.FormatJson.Compact.__doc__ + '\n' + '* ``Disabled``: ' + QgsJsonEditWidget.FormatJson.Disabled.__doc__
# --
# The following has been generated automatically from src/gui/qgsmapcanvasinteractionblocker.h
# monkey patching scoped based enum
QgsMapCanvasInteractionBlocker.Interaction.MapPanOnSingleClick.__doc__ = "A map pan interaction caused by a single click and release on the map canvas"
QgsMapCanvasInteractionBlocker.Interaction.__doc__ = "Available interactions to block.\n\n" + '* ``MapPanOnSingleClick``: ' + QgsMapCanvasInteractionBlocker.Interaction.MapPanOnSingleClick.__doc__
# --
# The following has been generated automatically from src/gui/qgsmaplayerconfigwidgetfactory.h
# monkey patching scoped based enum
QgsMapLayerConfigWidgetFactory.ParentPage.NoParent.__doc__ = "Factory creates pages itself, not sub-components"
QgsMapLayerConfigWidgetFactory.ParentPage.Temporal.__doc__ = "Factory creates sub-components of the temporal properties page (only supported for raster layer temporal properties)"
QgsMapLayerConfigWidgetFactory.ParentPage.__doc__ = "Available parent pages, for factories which create a widget which is a sub-component\nof a standard page.\n\n.. versionadded:: 3.20\n\n" + '* ``NoParent``: ' + QgsMapLayerConfigWidgetFactory.ParentPage.NoParent.__doc__ + '\n' + '* ``Temporal``: ' + QgsMapLayerConfigWidgetFactory.ParentPage.Temporal.__doc__
# --
# The following has been generated automatically from src/gui/qgsmaptoolidentify.h
QgsMapToolIdentify.IdentifyMode.baseClass = QgsMapToolIdentify
QgsMapToolIdentify.LayerType.baseClass = QgsMapToolIdentify
LayerType = QgsMapToolIdentify  # dirty hack since SIP seems to introduce the flags in module
# The following has been generated automatically from src/gui/qgsmediawidget.h
QgsMediaWidget.Mode.baseClass = QgsMediaWidget
# The following has been generated automatically from src/gui/processing/models/qgsmodeldesignerdialog.h
# monkey patching scoped based enum
QgsModelDesignerDialog.SaveAction.SaveAsFile.__doc__ = "Save model as a file"
QgsModelDesignerDialog.SaveAction.SaveInProject.__doc__ = "Save model into project"
QgsModelDesignerDialog.SaveAction.__doc__ = "Save action.\n\n.. versionadded:: 3.24\n\n" + '* ``SaveAsFile``: ' + QgsModelDesignerDialog.SaveAction.SaveAsFile.__doc__ + '\n' + '* ``SaveInProject``: ' + QgsModelDesignerDialog.SaveAction.SaveInProject.__doc__
# --
# The following has been generated automatically from src/gui/processing/qgsprocessingaggregatewidgets.h
# monkey patching scoped based enum
QgsAggregateMappingModel.ColumnDataIndex.SourceExpression.__doc__ = "Expression"
QgsAggregateMappingModel.ColumnDataIndex.Aggregate.__doc__ = "Aggregate name"
QgsAggregateMappingModel.ColumnDataIndex.Delimiter.__doc__ = "Delimiter"
QgsAggregateMappingModel.ColumnDataIndex.DestinationName.__doc__ = "Destination field name"
QgsAggregateMappingModel.ColumnDataIndex.DestinationType.__doc__ = "Destination field type string"
QgsAggregateMappingModel.ColumnDataIndex.DestinationLength.__doc__ = "Destination field length"
QgsAggregateMappingModel.ColumnDataIndex.DestinationPrecision.__doc__ = "Destination field precision"
QgsAggregateMappingModel.ColumnDataIndex.__doc__ = "The ColumnDataIndex enum represents the column index for the view\n\n" + '* ``SourceExpression``: ' + QgsAggregateMappingModel.ColumnDataIndex.SourceExpression.__doc__ + '\n' + '* ``Aggregate``: ' + QgsAggregateMappingModel.ColumnDataIndex.Aggregate.__doc__ + '\n' + '* ``Delimiter``: ' + QgsAggregateMappingModel.ColumnDataIndex.Delimiter.__doc__ + '\n' + '* ``DestinationName``: ' + QgsAggregateMappingModel.ColumnDataIndex.DestinationName.__doc__ + '\n' + '* ``DestinationType``: ' + QgsAggregateMappingModel.ColumnDataIndex.DestinationType.__doc__ + '\n' + '* ``DestinationLength``: ' + QgsAggregateMappingModel.ColumnDataIndex.DestinationLength.__doc__ + '\n' + '* ``DestinationPrecision``: ' + QgsAggregateMappingModel.ColumnDataIndex.DestinationPrecision.__doc__
# --
QgsAggregateMappingModel.ColumnDataIndex.baseClass = QgsAggregateMappingModel
# The following has been generated automatically from src/gui/processing/qgsprocessingalgorithmdialogbase.h
# monkey patching scoped based enum
QgsProcessingAlgorithmDialogBase.DialogMode.Single.__doc__ = "Single algorithm execution mode"
QgsProcessingAlgorithmDialogBase.DialogMode.Batch.__doc__ = "Batch processing mode"
QgsProcessingAlgorithmDialogBase.DialogMode.__doc__ = "Dialog modes.\n\n.. versionadded:: 3.24\n\n" + '* ``Single``: ' + QgsProcessingAlgorithmDialogBase.DialogMode.Single.__doc__ + '\n' + '* ``Batch``: ' + QgsProcessingAlgorithmDialogBase.DialogMode.Batch.__doc__
# --
# The following has been generated automatically from src/gui/processing/qgsprocessingtoolboxmodel.h
QgsProcessingToolboxProxyModel.Filters.baseClass = QgsProcessingToolboxProxyModel
Filters = QgsProcessingToolboxProxyModel  # dirty hack since SIP seems to introduce the flags in module
# The following has been generated automatically from src/gui/processing/qgsprocessingwidgetwrapper.h
# monkey patching scoped based enum
QgsProcessingParametersGenerator.Flag.SkipDefaultValueParameters.__doc__ = "Parameters which are unchanged from their default values should not be included"
QgsProcessingParametersGenerator.Flag.__doc__ = "Flags controlling parameter generation.\n\n.. versionadded:: 3.24\n\n" + '* ``SkipDefaultValueParameters``: ' + QgsProcessingParametersGenerator.Flag.SkipDefaultValueParameters.__doc__
# --
# The following has been generated automatically from src/gui/qgsqueryresultwidget.h
# monkey patching scoped based enum
QgsQueryResultWidget.QueryWidgetMode.SqlQueryMode.__doc__ = "Defaults widget mode for SQL execution and SQL query layer creation."
QgsQueryResultWidget.QueryWidgetMode.QueryLayerUpdateMode.__doc__ = "SQL query layer update mode: the create SQL layer button is renamed to 'Update' and the SQL layer creation group box is expanded."
QgsQueryResultWidget.QueryWidgetMode.__doc__ = "The QueryWidgetMode enum represents various modes for the widget appearance.\n\n" + '* ``SqlQueryMode``: ' + QgsQueryResultWidget.QueryWidgetMode.SqlQueryMode.__doc__ + '\n' + '* ``QueryLayerUpdateMode``: ' + QgsQueryResultWidget.QueryWidgetMode.QueryLayerUpdateMode.__doc__
# --
QgsQueryResultWidget.QueryWidgetMode.baseClass = QgsQueryResultWidget
# The following has been generated automatically from src/gui/qgsrelationeditorwidget.h
QgsRelationEditorWidget.Button.baseClass = QgsRelationEditorWidget
QgsRelationEditorWidget.Buttons.baseClass = QgsRelationEditorWidget
Buttons = QgsRelationEditorWidget  # dirty hack since SIP seems to introduce the flags in module
# The following has been generated automatically from src/gui/settings/qgssettingstreemodel.h
# monkey patching scoped based enum
QgsSettingsTreeModel.Column.Name.__doc__ = "Name"
QgsSettingsTreeModel.Column.Value.__doc__ = "Value"
QgsSettingsTreeModel.Column.Description.__doc__ = "Description"
QgsSettingsTreeModel.Column.__doc__ = "Columns\n\n" + '* ``Name``: ' + QgsSettingsTreeModel.Column.Name.__doc__ + '\n' + '* ``Value``: ' + QgsSettingsTreeModel.Column.Value.__doc__ + '\n' + '* ``Description``: ' + QgsSettingsTreeModel.Column.Description.__doc__
# --
# The following has been generated automatically from src/gui/qgssublayersdialog.h
QgsSublayersDialog.PromptMode.baseClass = QgsSublayersDialog
# The following has been generated automatically from src/gui/ogr/qgsvectorlayersaveasdialog.h
# monkey patching scoped based enum
QgsVectorLayerSaveAsDialog.Option.Symbology.__doc__ = "Show symbology options"
QgsVectorLayerSaveAsDialog.Option.DestinationCrs.__doc__ = "Show destination CRS (reprojection) option"
QgsVectorLayerSaveAsDialog.Option.Fields.__doc__ = "Show field customization group"
QgsVectorLayerSaveAsDialog.Option.AddToCanvas.__doc__ = "Show add to map option"
QgsVectorLayerSaveAsDialog.Option.SelectedOnly.__doc__ = "Show selected features only option"
QgsVectorLayerSaveAsDialog.Option.GeometryType.__doc__ = "Show geometry group"
QgsVectorLayerSaveAsDialog.Option.Extent.__doc__ = "Show extent group"
QgsVectorLayerSaveAsDialog.Option.Metadata.__doc__ = "Show metadata options"
QgsVectorLayerSaveAsDialog.Option.AllOptions.__doc__ = ""
QgsVectorLayerSaveAsDialog.Option.__doc__ = "Available dialog options.\n\n" + '* ``Symbology``: ' + QgsVectorLayerSaveAsDialog.Option.Symbology.__doc__ + '\n' + '* ``DestinationCrs``: ' + QgsVectorLayerSaveAsDialog.Option.DestinationCrs.__doc__ + '\n' + '* ``Fields``: ' + QgsVectorLayerSaveAsDialog.Option.Fields.__doc__ + '\n' + '* ``AddToCanvas``: ' + QgsVectorLayerSaveAsDialog.Option.AddToCanvas.__doc__ + '\n' + '* ``SelectedOnly``: ' + QgsVectorLayerSaveAsDialog.Option.SelectedOnly.__doc__ + '\n' + '* ``GeometryType``: ' + QgsVectorLayerSaveAsDialog.Option.GeometryType.__doc__ + '\n' + '* ``Extent``: ' + QgsVectorLayerSaveAsDialog.Option.Extent.__doc__ + '\n' + '* ``Metadata``: ' + QgsVectorLayerSaveAsDialog.Option.Metadata.__doc__ + '\n' + '* ``AllOptions``: ' + QgsVectorLayerSaveAsDialog.Option.AllOptions.__doc__
# --
QgsVectorLayerSaveAsDialog.Option.baseClass = QgsVectorLayerSaveAsDialog
QgsVectorLayerSaveAsDialog.Options.baseClass = QgsVectorLayerSaveAsDialog
Options = QgsVectorLayerSaveAsDialog  # dirty hack since SIP seems to introduce the flags in module
