/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view.individual;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import org.protege.editor.owl.model.selection.OWLSelectionModelListener;
import org.protege.editor.owl.ui.view.individual.OWLIndividualListViewComponent;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.search.EntitySearcher;

public class OWLMembersListViewComponent
extends OWLIndividualListViewComponent {
    private final JLabel typeLabel = new JLabel();
    private OWLSelectionModelListener l = () -> {
        if (this.getOWLWorkspace().getOWLSelectionModel().getSelectedObject() instanceof OWLClass) {
            this.refill();
        }
    };

    @Override
    public void initialiseIndividualsView() throws Exception {
        super.initialiseIndividualsView();
        this.getOWLWorkspace().getOWLSelectionModel().addListener(this.l);
        Box typePanel = new Box(0);
        typePanel.add(new JLabel("For: "));
        typePanel.add(this.typeLabel);
        typePanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 0));
        this.add(typePanel, "North");
    }

    @Override
    protected void refill() {
        this.individualsInList.clear();
        OWLClass cls = this.getOWLWorkspace().getOWLSelectionModel().getLastSelectedClass();
        if (cls != null) {
            this.typeLabel.setText(this.getOWLModelManager().getRendering((OWLObject)cls));
            this.typeLabel.setIcon(this.getOWLWorkspace().getOWLIconProvider().getIcon((OWLObject)cls));
            Collection individuals = EntitySearcher.getIndividuals((OWLClass)cls, this.getOntologies());
            for (OWLIndividual ind : individuals) {
                if (ind.isAnonymous()) continue;
                this.individualsInList.add(ind.asOWLNamedIndividual());
            }
            if (cls.equals(this.getOWLModelManager().getOWLDataFactory().getOWLThing())) {
                this.individualsInList.addAll(this.getUntypedIndividuals());
            }
        } else {
            this.typeLabel.setIcon(null);
            this.typeLabel.setText("Nothing selected");
            this.individualsInList.addAll(this.getUntypedIndividuals());
        }
        this.reset();
    }

    protected Set<OWLNamedIndividual> getUntypedIndividuals() {
        HashSet<OWLNamedIndividual> untypedIndividuals = new HashSet<OWLNamedIndividual>();
        OWLOntology activeOntology = this.getOWLModelManager().getActiveOntology();
        Set importsClosure = activeOntology.getImportsClosure();
        for (OWLNamedIndividual individual : activeOntology.getIndividualsInSignature(Imports.INCLUDED)) {
            Collection types = EntitySearcher.getTypes((OWLIndividual)individual, (Iterable)importsClosure);
            if (types.size() != 0) continue;
            untypedIndividuals.add(individual);
        }
        return untypedIndividuals;
    }

    @Override
    protected void processChanges(List<? extends OWLOntologyChange> changes) {
        this.refill();
    }

    @Override
    protected List<OWLOntologyChange> dofurtherCreateSteps(OWLIndividual newIndividual) {
        OWLClass cls = this.getOWLWorkspace().getOWLSelectionModel().getLastSelectedClass();
        if (cls != null && !cls.isOWLThing()) {
            OWLClassAssertionAxiom typeAxiom = this.getOWLModelManager().getOWLDataFactory().getOWLClassAssertionAxiom((OWLClassExpression)cls, newIndividual);
            AddAxiom change = new AddAxiom(this.getOWLModelManager().getActiveOntology(), (OWLAxiom)typeAxiom);
            return Collections.singletonList(change);
        }
        return new ArrayList<OWLOntologyChange>();
    }

    @Override
    public void disposeView() {
        this.getOWLWorkspace().getOWLSelectionModel().removeListener(this.l);
        super.disposeView();
    }
}

