/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.AxiomListFrameSectionRow;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;

public class AxiomListFrameSection
extends AbstractOWLFrameSection<Set<OWLAxiom>, OWLAxiom, OWLAxiom> {
    private RowComparator rowComparator = new RowComparator();
    private Set<OWLAxiom> added = new HashSet<OWLAxiom>();

    public AxiomListFrameSection(OWLEditorKit editorKit, OWLFrame<Set<OWLAxiom>> owlFrame) {
        super(editorKit, "Axioms", "Axiom", owlFrame);
    }

    @Override
    protected OWLAxiom createAxiom(OWLAxiom object) {
        return null;
    }

    @Override
    public OWLObjectEditor<OWLAxiom> getObjectEditor() {
        return null;
    }

    @Override
    protected void refill(OWLOntology ontology) {
        Set axs = (Set)this.getRootObject();
        for (OWLAxiom ax : axs) {
            if (!ontology.containsAxiom(ax)) continue;
            this.addRow(new AxiomListFrameSectionRow(this.getOWLEditorKit(), this, ontology, (Set)this.getRootObject(), ax));
            this.added.add(ax);
        }
    }

    @Override
    protected void refillInferred() {
        Set axs = (Set)this.getRootObject();
        for (OWLAxiom ax : axs) {
            if (this.added.contains(ax)) continue;
            this.addRow(new AxiomListFrameSectionRow(this.getOWLEditorKit(), this, null, (Set)this.getRootObject(), ax));
        }
    }

    @Override
    protected void clear() {
        this.added.clear();
    }

    @Override
    public Comparator<OWLFrameSectionRow<Set<OWLAxiom>, OWLAxiom, OWLAxiom>> getRowComparator() {
        return this.rowComparator;
    }

    @Override
    public boolean canAdd() {
        return false;
    }

    @Override
    protected boolean isResettingChange(OWLOntologyChange change) {
        return change.isAxiomChange();
    }

    private class RowComparator
    implements Comparator<OWLFrameSectionRow<Set<OWLAxiom>, OWLAxiom, OWLAxiom>> {
        private Comparator<OWLObject> objComparator;

        public RowComparator() {
            this.objComparator = AxiomListFrameSection.this.getOWLModelManager().getOWLObjectComparator();
        }

        @Override
        public int compare(OWLFrameSectionRow<Set<OWLAxiom>, OWLAxiom, OWLAxiom> o1, OWLFrameSectionRow<Set<OWLAxiom>, OWLAxiom, OWLAxiom> o2) {
            return this.objComparator.compare((OWLObject)o1.getAxiom(), (OWLObject)o2.getAxiom());
        }
    }
}

