/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.menu;

import com.google.common.base.MoreObjects;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.KeyStroke;
import org.eclipse.core.runtime.IExtension;
import org.protege.editor.core.PropertyUtil;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.ui.action.ProtegeAction;
import org.protege.editor.core.ui.action.ProtegeActionPluginJPFImpl;
import org.protege.editor.core.ui.menu.MenuActionPlugin;
import org.protege.editor.core.ui.menu.NullMenuAction;
import org.protege.editor.core.ui.menu.OpenURLMenuAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuActionPluginJPFImpl
extends ProtegeActionPluginJPFImpl
implements MenuActionPlugin {
    private Logger logger = LoggerFactory.getLogger(MenuActionPluginJPFImpl.class);
    public static final String EXTENSION_POINT_ID = "EditorKitMenuAction";
    private static final String ACCELERATOR_PARAM = "accelerator";
    private static final String URL_PARAM = "url";
    private static final String PATH_PARAM = "path";
    private static final String SEPARATOR = "/";
    private static final String DYNAMIC_PARAM = "dynamic";
    private static final String CHECKBOX_PARAM = "checkbox";
    private static final String RADIOBUTTON_PARAM = "radiobutton";
    private String parentId;
    private String group;
    private String groupIndex;

    public MenuActionPluginJPFImpl(EditorKit editorKit, IExtension extension) {
        super(editorKit, extension);
        this.parse();
    }

    private String getPath() {
        return this.getPluginProperty(PATH_PARAM, SEPARATOR);
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getGroupIndex() {
        return this.groupIndex;
    }

    @Override
    public KeyStroke getAccelerator() {
        KeyStroke ks;
        String acceleratorString = this.getPluginProperty(ACCELERATOR_PARAM);
        if (acceleratorString != null && (ks = KeyStroke.getKeyStroke(acceleratorString)) != null) {
            return KeyStroke.getKeyStroke(ks.getKeyCode(), Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | ks.getModifiers());
        }
        return null;
    }

    public URL getURL() {
        String urlStr = this.getPluginProperty(URL_PARAM, null);
        if (urlStr != null) {
            try {
                return new URL(urlStr);
            }
            catch (MalformedURLException e) {
                LoggerFactory.getLogger(MenuActionPluginJPFImpl.class).warn("Invalid URL for action " + this.getId(), (Throwable)e);
            }
        }
        return null;
    }

    private boolean isClassSpecified() {
        return this.getPluginProperty("class") != null;
    }

    @Override
    public boolean isDynamic() {
        return PropertyUtil.getBoolean(this.getPluginProperty(DYNAMIC_PARAM), false);
    }

    @Override
    @Deprecated
    public boolean isJCheckBox() {
        return this.isCheckBox();
    }

    @Override
    public boolean isCheckBox() {
        return PropertyUtil.getBoolean(this.getPluginProperty(CHECKBOX_PARAM), false);
    }

    @Override
    public boolean isRadioButton() {
        return PropertyUtil.getBoolean(this.getPluginProperty(RADIOBUTTON_PARAM), false);
    }

    @Override
    public ProtegeAction newInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ProtegeAction menuAction = null;
        if (this.isClassSpecified()) {
            menuAction = (ProtegeAction)super.newInstance();
        }
        if (menuAction == null) {
            URL url = this.getURL();
            menuAction = url != null ? new OpenURLMenuAction(url) : new NullMenuAction();
        }
        menuAction.putValue("Name", this.getName());
        String toolTip = this.getToolTipText();
        if (toolTip != null) {
            toolTip = toolTip.replace("\n", "");
            toolTip = toolTip.replace("\t", "");
            menuAction.putValue("ShortDescription", toolTip);
        }
        menuAction.putValue("AcceleratorKey", this.getAccelerator());
        menuAction.setEditorKit(this.getEditorKit());
        try {
            menuAction.initialise();
        }
        catch (Exception e) {
            this.logger.error("An error occurred whilst instantiating a menu action.", (Throwable)e);
        }
        return menuAction;
    }

    private void parse() {
        this.group = "";
        this.groupIndex = "";
        String path = this.getPath();
        int separatorIndex = path.indexOf(SEPARATOR);
        if (separatorIndex > -1) {
            this.parentId = path.substring(0, separatorIndex).trim();
            String groupPart = path.substring(separatorIndex + 1, path.length()).trim();
            int groupPartIndex = groupPart.indexOf("-");
            if (groupPartIndex > -1) {
                this.group = groupPart.substring(0, groupPartIndex).trim();
                this.groupIndex = groupPart.substring(groupPartIndex + 1, groupPart.length());
            } else {
                this.group = groupPart;
            }
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MenuActionPlugin").add("name", (Object)this.getName()).add("group", (Object)this.getGroup()).add("groupIndex", (Object)this.getGroupIndex()).add(ACCELERATOR_PARAM, (Object)this.getAccelerator()).add("parentId", (Object)this.getParentId()).add(PATH_PARAM, (Object)this.getPath()).toString();
    }
}

