/*
 * Decompiled with CFR 0.152.
 */
package org.protege.common;

import javax.xml.parsers.SAXParserFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private final Logger logger = LoggerFactory.getLogger(Activator.class);
    private ServiceListener listener;

    public void start(BundleContext context) throws Exception {
        this.logger.debug("Starting org.protege.common bundle");
        context.registerService(SAXParserFactory.class.getName(), (Object)SAXParserFactory.newInstance(), null);
        if (this.logger.isDebugEnabled()) {
            this.startDebug(context);
        }
    }

    public void startDebug(BundleContext context) {
        this.listener = new DebugServicesListener();
        context.addServiceListener(this.listener);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.listener != null) {
            context.removeServiceListener(this.listener);
            this.listener = null;
        }
    }

    private class DebugServicesListener
    implements ServiceListener {
        private DebugServicesListener() {
        }

        public void serviceChanged(ServiceEvent event) {
            if (event.getType() == 1) {
                Activator.this.logger.debug(event.getServiceReference().getBundle().getSymbolicName() + " registering service " + this.displayClass(event.getServiceReference()));
            } else if (event.getType() == 4) {
                Activator.this.logger.debug(event.getServiceReference().getBundle().getSymbolicName() + " unregistering service " + this.displayClass(event.getServiceReference()));
            } else {
                Activator.this.logger.debug("Modifying service " + event.getServiceReference());
            }
        }

        private String displayClass(ServiceReference ref) {
            Object classes = ref.getProperty("objectClass");
            if (classes instanceof String[]) {
                String[] classArray = (String[])classes;
                return classArray[0];
            }
            return classes.toString();
        }
    }
}

