/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.nio.utils;

import java.nio.ByteBuffer;

public final class ByteBufferUtils {
    private ByteBufferUtils() {
    }

    public static long copyBytes(ByteBuffer[] source, ByteBuffer destination) {
        long bytesCopied = 0L;
        for (int i = 0; i < source.length && destination.hasRemaining(); ++i) {
            ByteBuffer buffer = source[i];
            bytesCopied += (long)ByteBufferUtils.copyBytes(buffer, destination);
        }
        return bytesCopied;
    }

    public static int copyBytes(ByteBuffer source, ByteBuffer destination) {
        int nBytesToCopy = Math.min(destination.remaining(), source.remaining());
        int initialLimit = source.limit();
        source.limit(source.position() + nBytesToCopy);
        destination.put(source);
        source.limit(initialLimit);
        return nBytesToCopy;
    }
}

