/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.utils;

import java.util.Locale;
import lombok.Generated;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.opensearch.sql.common.antlr.CaseInsensitiveCharStream;
import org.opensearch.sql.common.antlr.SyntaxAnalysisErrorListener;
import org.opensearch.sql.common.antlr.SyntaxCheckException;
import org.opensearch.sql.spark.antlr.parser.FlintSparkSqlExtensionsBaseVisitor;
import org.opensearch.sql.spark.antlr.parser.FlintSparkSqlExtensionsLexer;
import org.opensearch.sql.spark.antlr.parser.FlintSparkSqlExtensionsParser;
import org.opensearch.sql.spark.antlr.parser.SqlBaseLexer;
import org.opensearch.sql.spark.antlr.parser.SqlBaseParser;
import org.opensearch.sql.spark.antlr.parser.SqlBaseParserBaseVisitor;
import org.opensearch.sql.spark.dispatcher.model.FullyQualifiedTableName;
import org.opensearch.sql.spark.dispatcher.model.IndexDetails;
import org.opensearch.sql.spark.flint.FlintIndexType;

public final class SQLQueryUtils {
    public static FullyQualifiedTableName extractFullyQualifiedTableName(String sqlQuery) {
        SqlBaseParser sqlBaseParser = new SqlBaseParser((TokenStream)new CommonTokenStream((TokenSource)new SqlBaseLexer((CharStream)new CaseInsensitiveCharStream(sqlQuery))));
        sqlBaseParser.addErrorListener((ANTLRErrorListener)new SyntaxAnalysisErrorListener());
        SqlBaseParser.StatementContext statement = sqlBaseParser.statement();
        SparkSqlTableNameVisitor sparkSqlTableNameVisitor = new SparkSqlTableNameVisitor();
        statement.accept(sparkSqlTableNameVisitor);
        return sparkSqlTableNameVisitor.getFullyQualifiedTableName();
    }

    public static IndexDetails extractIndexDetails(String sqlQuery) {
        FlintSparkSqlExtensionsParser flintSparkSqlExtensionsParser = new FlintSparkSqlExtensionsParser((TokenStream)new CommonTokenStream((TokenSource)new FlintSparkSqlExtensionsLexer((CharStream)new CaseInsensitiveCharStream(sqlQuery))));
        flintSparkSqlExtensionsParser.addErrorListener((ANTLRErrorListener)new SyntaxAnalysisErrorListener());
        FlintSparkSqlExtensionsParser.StatementContext statementContext = flintSparkSqlExtensionsParser.statement();
        FlintSQLIndexDetailsVisitor flintSQLIndexDetailsVisitor = new FlintSQLIndexDetailsVisitor();
        statementContext.accept(flintSQLIndexDetailsVisitor);
        return flintSQLIndexDetailsVisitor.getIndexDetails();
    }

    public static boolean isIndexQuery(String sqlQuery) {
        FlintSparkSqlExtensionsParser flintSparkSqlExtensionsParser = new FlintSparkSqlExtensionsParser((TokenStream)new CommonTokenStream((TokenSource)new FlintSparkSqlExtensionsLexer((CharStream)new CaseInsensitiveCharStream(sqlQuery))));
        flintSparkSqlExtensionsParser.addErrorListener((ANTLRErrorListener)new SyntaxAnalysisErrorListener());
        try {
            flintSparkSqlExtensionsParser.statement();
            return true;
        }
        catch (SyntaxCheckException syntaxCheckException) {
            return false;
        }
    }

    @Generated
    private SQLQueryUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class FlintSQLIndexDetailsVisitor
    extends FlintSparkSqlExtensionsBaseVisitor<Void> {
        private final IndexDetails indexDetails = new IndexDetails();

        @Override
        public Void visitIndexName(FlintSparkSqlExtensionsParser.IndexNameContext ctx) {
            this.indexDetails.setIndexName(ctx.getText());
            return (Void)super.visitIndexName(ctx);
        }

        @Override
        public Void visitTableName(FlintSparkSqlExtensionsParser.TableNameContext ctx) {
            this.indexDetails.setFullyQualifiedTableName(new FullyQualifiedTableName(ctx.getText()));
            return (Void)super.visitTableName(ctx);
        }

        @Override
        public Void visitCreateSkippingIndexStatement(FlintSparkSqlExtensionsParser.CreateSkippingIndexStatementContext ctx) {
            this.indexDetails.setDropIndex(false);
            this.indexDetails.setIndexType(FlintIndexType.SKIPPING);
            this.visitPropertyList(ctx.propertyList());
            return (Void)super.visitCreateSkippingIndexStatement(ctx);
        }

        @Override
        public Void visitCreateCoveringIndexStatement(FlintSparkSqlExtensionsParser.CreateCoveringIndexStatementContext ctx) {
            this.indexDetails.setDropIndex(false);
            this.indexDetails.setIndexType(FlintIndexType.COVERING);
            this.visitPropertyList(ctx.propertyList());
            return (Void)super.visitCreateCoveringIndexStatement(ctx);
        }

        @Override
        public Void visitDropCoveringIndexStatement(FlintSparkSqlExtensionsParser.DropCoveringIndexStatementContext ctx) {
            this.indexDetails.setDropIndex(true);
            this.indexDetails.setIndexType(FlintIndexType.COVERING);
            return (Void)super.visitDropCoveringIndexStatement(ctx);
        }

        @Override
        public Void visitDropSkippingIndexStatement(FlintSparkSqlExtensionsParser.DropSkippingIndexStatementContext ctx) {
            this.indexDetails.setDropIndex(true);
            this.indexDetails.setIndexType(FlintIndexType.SKIPPING);
            return (Void)super.visitDropSkippingIndexStatement(ctx);
        }

        @Override
        public Void visitPropertyList(FlintSparkSqlExtensionsParser.PropertyListContext ctx) {
            if (ctx != null) {
                ctx.property().forEach(property -> {
                    if (this.propertyKey(property.key).toLowerCase(Locale.ROOT).contains("auto_refresh") && this.propertyValue(property.value).toLowerCase(Locale.ROOT).contains("true")) {
                        this.indexDetails.setAutoRefresh(true);
                    }
                });
            }
            return null;
        }

        private String propertyKey(FlintSparkSqlExtensionsParser.PropertyKeyContext key) {
            if (key.STRING() != null) {
                return key.STRING().getText();
            }
            return key.getText();
        }

        private String propertyValue(FlintSparkSqlExtensionsParser.PropertyValueContext value) {
            if (value.STRING() != null) {
                return value.STRING().getText();
            }
            if (value.booleanValue() != null) {
                return value.getText();
            }
            return value.getText();
        }

        @Generated
        public IndexDetails getIndexDetails() {
            return this.indexDetails;
        }
    }

    public static class SparkSqlTableNameVisitor
    extends SqlBaseParserBaseVisitor<Void> {
        private FullyQualifiedTableName fullyQualifiedTableName = new FullyQualifiedTableName();

        @Override
        public Void visitTableName(SqlBaseParser.TableNameContext ctx) {
            this.fullyQualifiedTableName = new FullyQualifiedTableName(ctx.getText());
            return (Void)super.visitTableName(ctx);
        }

        @Override
        public Void visitDropTable(SqlBaseParser.DropTableContext ctx) {
            for (ParseTree parseTree : ctx.children) {
                if (!(parseTree instanceof SqlBaseParser.IdentifierReferenceContext)) continue;
                this.fullyQualifiedTableName = new FullyQualifiedTableName(parseTree.getText());
            }
            return (Void)super.visitDropTable(ctx);
        }

        @Override
        public Void visitDescribeRelation(SqlBaseParser.DescribeRelationContext ctx) {
            for (ParseTree parseTree : ctx.children) {
                if (!(parseTree instanceof SqlBaseParser.IdentifierReferenceContext)) continue;
                this.fullyQualifiedTableName = new FullyQualifiedTableName(parseTree.getText());
            }
            return (Void)super.visitDescribeRelation(ctx);
        }

        @Override
        public Void visitCreateTableHeader(SqlBaseParser.CreateTableHeaderContext ctx) {
            for (ParseTree parseTree : ctx.children) {
                if (!(parseTree instanceof SqlBaseParser.IdentifierReferenceContext)) continue;
                this.fullyQualifiedTableName = new FullyQualifiedTableName(parseTree.getText());
            }
            return (Void)super.visitCreateTableHeader(ctx);
        }

        @Generated
        public FullyQualifiedTableName getFullyQualifiedTableName() {
            return this.fullyQualifiedTableName;
        }
    }
}

